/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleMulticaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleTracker
extends AbstractTool {
    private Handle masterHandle;
    private HandleMulticaster multicaster;
    private Point anchor;

    public HandleTracker(Handle handle) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }

    public HandleTracker(Handle master, Collection<Handle> handles) {
        this.masterHandle = master;
        this.multicaster = new HandleMulticaster(handles);
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().setCursor(this.masterHandle.getCursor());
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.getView().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.multicaster.keyPressed(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        this.multicaster.keyReleased(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        this.multicaster.keyTyped(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.multicaster.trackDoubleClick(new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.multicaster.trackStep(this.anchor, new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.anchor = new Point(evt.getX(), evt.getY());
        this.multicaster.trackStart(this.anchor, evt.getModifiersEx(), this.getView());
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.multicaster.trackEnd(this.anchor, new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
        this.fireToolDone();
    }
}

