/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.Paint;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;

public class SVGAttributeKeys
extends AttributeKeys {
    public static final AttributeKey<TextAnchor> TEXT_ANCHOR = new AttributeKey<TextAnchor>("textAnchor", TextAnchor.START, false);
    public static final AttributeKey<TextAlign> TEXT_ALIGN = new AttributeKey<TextAlign>("textAlign", TextAlign.START, false);
    public static final AttributeKey<Gradient> FILL_GRADIENT = new AttributeKey<Object>("fillGradient", null);
    public static final AttributeKey<Double> FILL_OPACITY = new AttributeKey<Double>("fillOpacity", 1.0, false);
    public static final AttributeKey<Double> OPACITY = new AttributeKey<Double>("opacity", 1.0, false);
    public static final AttributeKey<Gradient> STROKE_GRADIENT = new AttributeKey<Object>("strokeGradient", null);
    public static final AttributeKey<Double> STROKE_OPACITY = new AttributeKey<Double>("strokeOpacity", 1.0, false);
    public static final AttributeKey<String> LINK = new AttributeKey<Object>("link", null);

    public static Paint getFillPaint(Figure f) {
        double opacity = FILL_OPACITY.get(f);
        if (FILL_GRADIENT.get(f) != null) {
            return FILL_GRADIENT.get(f).getPaint(f, opacity);
        }
        Color color = (Color)FILL_COLOR.get(f);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static Paint getStrokePaint(Figure f) {
        double opacity = STROKE_OPACITY.get(f);
        if (STROKE_GRADIENT.get(f) != null) {
            return STROKE_GRADIENT.get(f).getPaint(f, opacity);
        }
        Color color = (Color)STROKE_COLOR.get(f);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static void setDefaults(Figure f) {
        FILL_COLOR.basicSet(f, Color.black);
        WINDING_RULE.basicSet(f, AttributeKeys.WindingRule.NON_ZERO);
        STROKE_COLOR.basicSet(f, null);
        STROKE_WIDTH.basicSet(f, 1.0);
        STROKE_CAP.basicSet(f, 0);
        STROKE_JOIN.basicSet(f, 0);
        STROKE_MITER_LIMIT.basicSet(f, 4.0);
        IS_STROKE_MITER_LIMIT_FACTOR.basicSet(f, false);
        STROKE_DASHES.basicSet(f, null);
        STROKE_DASH_PHASE.basicSet(f, 0.0);
        IS_STROKE_DASH_FACTOR.basicSet(f, false);
    }

    public static double getPerpendicularHitGrowth(Figure f) {
        double grow;
        if (STROKE_COLOR.get(f) == null && STROKE_GRADIENT.get(f) == null) {
            grow = SVGAttributeKeys.getPerpendicularFillGrowth(f);
        } else {
            double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
            grow = SVGAttributeKeys.getPerpendicularDrawGrowth(f) + strokeWidth / 2.0;
        }
        return grow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAlign {
        START,
        CENTER,
        END;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAnchor {
        START,
        MIDDLE,
        END;

    }
}

