/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutUtils;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

class FlatLayout
implements Layout {
    static final String DESCRIPTION = "Layout the images in a square grid.";
    private ViewerSorter sorter;
    private List<ImageNode> images = new ArrayList<ImageNode>();
    private ImageSet root;
    private Set oldNodes;
    private int itemsPerRow;

    FlatLayout(ViewerSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public void doLayout() {
        if (this.root != null) {
            List l = this.sorter.sort(this.images);
            if (this.oldNodes == null || this.oldNodes.size() != l.size()) {
                LayoutUtils.doSquareGridLayout(this.root, l);
            } else {
                LayoutUtils.redoLayout(this.root, null, l, this.oldNodes);
            }
        }
    }

    @Override
    public void visit(ImageNode node) {
        this.images.add(node);
    }

    @Override
    public void visit(ImageSet node) {
        if (!(node.getHierarchyObject() instanceof DataObject) && node.getParentDisplay() == null) {
            this.root = node;
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getIndex() {
        return 2;
    }

    @Override
    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }

    @Override
    public void setImagesPerRow(int number) {
        this.itemsPerRow = number;
    }

    @Override
    public int getImagesPerRow() {
        return this.itemsPerRow;
    }
}

