/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import ij.ImagePlus;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.DataNodeElement;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileElement;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileTableRendererContainerColumn;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileTableRendererFileColumn;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportLocationSettings;
import org.openmicroscopy.shoola.agents.util.browser.DataNode;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MultilineHeaderSelectionRenderer;
import org.openmicroscopy.shoola.util.ui.TooltipTableHeader;

class FileSelectionTable
extends JPanel
implements ActionListener {
    private static final String TOOLTIP_BUTTON_REMOVE_ALL = "Remove all files from the queue.";
    private static final String TOOLTIP_BUTTON_REMOVE = "Remove the selected files from the queue.";
    private static final String TOOLTIP_BUTTON_ADD = "Add the selected files to the queue.";
    private static final String TOOLTIP_GROUP = "The group where to import data.";
    private static final String TOOLTIP_OWNER = "The owner of imported data";
    private static final String TOOLTIP_FAD = "Convert the folder as dataset.";
    private static final String TOOLTIP_CONTAINER = "The container where to import the data.";
    private static final String TOOLTIP_SIZE = "Size of File or Folder.";
    private static final String TOOLTIP_FILE = "File or Folder to import.";
    static final String ADD_PROPERTY = "add";
    static final String REMOVE_PROPERTY = "remove";
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int REMOVE_ALL = 2;
    private static final String FAD_TEXT = "Folder as\nDataset";
    private static final String FILE_TEXT = "File or\nFolder";
    private static final String SIZE_TEXT = "Size";
    private static final String CONTAINER_PROJECT_TEXT = "Project/Dataset\nor Screen";
    private static final String GROUP_TEXT = "Group";
    private static final String OWNER_TEXT = "Owner";
    private JButton addButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private JTable table;
    private ImportDialog model;
    private KeyAdapter keyListener;
    private Integer fileIndex;
    private Integer groupIndex;
    private Integer ownerIndex;
    private Integer containerIndex;
    private Integer folderAsDatasetIndex;
    private Integer sizeIndex;
    private final Vector<String> columnHeadings = new Vector();
    private final Vector<String> columnTooltips = new Vector();

    private void formatTableModel() {
        TableColumnModel tcm = this.table.getColumnModel();
        int index = 0;
        this.columnHeadings.clear();
        this.columnTooltips.clear();
        this.fileIndex = index++;
        this.columnHeadings.add(FILE_TEXT);
        this.columnTooltips.add(TOOLTIP_FILE);
        tcm.getColumn(this.fileIndex).setCellRenderer(new FileTableRendererFileColumn());
        if (this.model.isSingleGroup()) {
            this.groupIndex = null;
        } else {
            this.groupIndex = index++;
            this.columnHeadings.add(GROUP_TEXT);
            this.columnTooltips.add(TOOLTIP_GROUP);
        }
        if (this.model.canImportAs()) {
            this.ownerIndex = index++;
            this.columnHeadings.add(OWNER_TEXT);
            this.columnTooltips.add(TOOLTIP_OWNER);
        } else {
            this.ownerIndex = null;
        }
        this.containerIndex = index++;
        this.columnHeadings.add(CONTAINER_PROJECT_TEXT);
        this.columnTooltips.add(TOOLTIP_CONTAINER);
        tcm.getColumn(this.containerIndex).setCellRenderer(new FileTableRendererContainerColumn());
        this.folderAsDatasetIndex = index++;
        this.columnHeadings.add(FAD_TEXT);
        this.columnTooltips.add(TOOLTIP_FAD);
        this.setColumnAsBoolean(tcm.getColumn(this.folderAsDatasetIndex));
        this.sizeIndex = index++;
        this.columnHeadings.add(SIZE_TEXT);
        this.columnTooltips.add(TOOLTIP_SIZE);
        this.table.setTableHeader(new TooltipTableHeader(tcm, this.columnTooltips));
        MultilineHeaderSelectionRenderer renderer = new MultilineHeaderSelectionRenderer();
        while (--index >= 0) {
            this.setHeaderRenderer(tcm, index, renderer);
        }
        this.table.getTableHeader().resizeAndRepaint();
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void setColumnAsBoolean(TableColumn column) {
        column.setCellEditor(this.table.getDefaultEditor(Boolean.class));
        column.setCellRenderer(this.table.getDefaultRenderer(Boolean.class));
        column.setResizable(false);
    }

    private void setHeaderRenderer(TableColumnModel columnModel, int columnIndex, TableCellRenderer renderer) {
        TableColumn column = columnModel.getColumn(columnIndex);
        column.setHeaderRenderer(renderer);
    }

    private void initColumns() {
        int index = 0;
        this.columnHeadings.clear();
        this.columnTooltips.clear();
        this.fileIndex = index++;
        this.columnHeadings.add(FILE_TEXT);
        this.columnTooltips.add(TOOLTIP_FILE);
        if (this.model.isSingleGroup()) {
            this.groupIndex = null;
        } else {
            this.groupIndex = index++;
            this.columnHeadings.add(GROUP_TEXT);
            this.columnTooltips.add(TOOLTIP_GROUP);
        }
        if (this.model.canImportAs()) {
            this.ownerIndex = index++;
            this.columnHeadings.add(OWNER_TEXT);
            this.columnTooltips.add(TOOLTIP_OWNER);
        } else {
            this.ownerIndex = null;
        }
        this.containerIndex = index++;
        this.columnHeadings.add(CONTAINER_PROJECT_TEXT);
        this.columnTooltips.add(TOOLTIP_CONTAINER);
        this.folderAsDatasetIndex = index++;
        this.columnHeadings.add(FAD_TEXT);
        this.columnTooltips.add(TOOLTIP_FAD);
        this.sizeIndex = index++;
        this.columnHeadings.add(SIZE_TEXT);
        this.columnTooltips.add(TOOLTIP_SIZE);
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(86));
        this.addButton.setToolTipText(TOOLTIP_BUTTON_ADD);
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(icons.getIcon(87));
        this.removeButton.setToolTipText(TOOLTIP_BUTTON_REMOVE);
        this.removeButton.setEnabled(false);
        this.removeAllButton = new JButton(icons.getIcon(85));
        this.removeAllButton.setToolTipText(TOOLTIP_BUTTON_REMOVE_ALL);
        this.removeAllButton.setEnabled(false);
        this.addButton.setActionCommand("0");
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeAllButton.setActionCommand("2");
        this.removeAllButton.addActionListener(this);
        this.table = new JTable(new FileTableModel());
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && FileSelectionTable.this.table.isFocusOwner()) {
                    FileSelectionTable.this.removeSelectedFiles();
                }
            }
        };
        this.table.addKeyListener(this.keyListener);
        this.formatTableModel();
    }

    private JPanel buildTablePane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add(Box.createVerticalStrut(5));
        p.add(new JScrollPane(this.table));
        return p;
    }

    private void buildGUI() {
        double[][] size = new double[][]{{-1.0}, {-1.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.buildTablePane(), "0, 0");
    }

    private void removeSelectedFiles() {
        this.table.removeKeyListener(this.keyListener);
        int[] rows = this.table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        Vector<Vector> v = dtm.getDataVector();
        ArrayList<Vector> indexes = new ArrayList<Vector>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.table.isRowSelected(i)) continue;
            indexes.add(v.get(i));
        }
        v.removeAll(indexes);
        dtm.setDataVector(v, this.columnHeadings);
        this.table.clearSelection();
        this.formatTableModel();
        this.table.repaint();
        this.table.addKeyListener(this.keyListener);
        int n = this.table.getRowCount();
        this.firePropertyChange(REMOVE_PROPERTY, n - 1, n);
        this.enabledControl(this.table.getRowCount() > 0);
        this.model.onSelectionChanged();
    }

    private boolean allowAddToQueue(List<FileElement> queue, FileObject f, long gID, long userID) {
        if (f == null) {
            return false;
        }
        if (queue == null) {
            return true;
        }
        Object o = f.getFile();
        if (f.isNewImage()) {
            return true;
        }
        File file = f.getTrueFile();
        if (file == null) {
            return false;
        }
        Iterator<FileElement> i = queue.iterator();
        String name = file.getAbsolutePath();
        while (i.hasNext()) {
            FileElement fe = i.next();
            if (!fe.getFile().getAbsolutePath().equals(name) || fe.getGroup().getId() != gID || fe.getUser().getId() != userID) continue;
            o = fe.getFile().getFile();
            if (o instanceof ImagePlus && f.getFile() instanceof ImagePlus) {
                fe.getFile().addAssociatedFile(new FileObject(f.getFile()));
            }
            return false;
        }
        return true;
    }

    private void enabledControl(boolean value) {
        this.removeButton.setEnabled(value);
        this.removeAllButton.setEnabled(value);
    }

    FileSelectionTable(ImportDialog model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initColumns();
        this.initComponents();
        this.buildGUI();
    }

    JPanel buildControls() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (ImporterAgent.runAsPlugin() != 3) {
            p.add(this.addButton);
            p.add(Box.createVerticalStrut(5));
        }
        p.add(this.removeButton);
        p.add(Box.createVerticalStrut(5));
        p.add(this.removeAllButton);
        return p;
    }

    boolean hasFilesToImport() {
        return this.table.getRowCount() > 0;
    }

    List<ImportableFile> getFilesToImport() {
        ArrayList<ImportableFile> files = new ArrayList<ImportableFile>();
        int n = this.table.getRowCount();
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, this.fileIndex);
            FileObject file = element.getFile();
            DataNodeElement dne = (DataNodeElement)dtm.getValueAt(i, this.containerIndex);
            boolean isFolderDataset = (Boolean)dtm.getValueAt(i, this.folderAsDatasetIndex);
            ImportableFile importable = new ImportableFile(file, isFolderDataset);
            DatasetData dataset = dne.getLocation();
            if (isFolderDataset) {
                dataset = null;
            }
            importable.setLocation(dne.getParent(), dataset);
            importable.setRefNode(dne.getRefNode());
            importable.setGroup(element.getGroup());
            importable.setUser(element.getUser());
            files.add(importable);
        }
        return files;
    }

    void reset(boolean value) {
        this.allowAddition(value);
        this.initColumns();
        this.table.setModel(new FileTableModel());
        this.formatTableModel();
    }

    void allowAddition(boolean value) {
        this.addButton.setEnabled(value);
    }

    void removeAllFiles() {
        int n = this.table.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        dtm.getDataVector().clear();
        this.table.clearSelection();
        this.formatTableModel();
        this.table.repaint();
        this.firePropertyChange(REMOVE_PROPERTY, -1, 0);
        this.enabledControl(false);
        this.model.onSelectionChanged();
    }

    void addFiles(List<FileObject> files, ImportLocationSettings settings) {
        FileElement element;
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        boolean fad = settings.isParentFolderAsDataset();
        GroupData group = settings.getImportGroup();
        ExperimenterData user = settings.getImportUser();
        this.enabledControl(true);
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        ArrayList<FileElement> inQueue = new ArrayList<FileElement>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            element = (FileElement)dtm.getValueAt(i, this.fileIndex);
            inQueue.add(element);
        }
        Iterator<FileObject> i = files.iterator();
        DataNode node = settings.getImportLocation();
        node.setParent(settings.getParentImportLocation());
        String value = null;
        long gID = group.getId();
        while (i.hasNext()) {
            FileObject f = i.next();
            if (!this.allowAddToQueue(inQueue, f, gID, user.getId())) continue;
            element = new FileElement(f, this.model.getType(), group, user);
            element.setName(f.getName());
            inQueue.add(element);
            value = null;
            boolean v = false;
            value = f.getFolderAsContainerName();
            if (f.isDirectory()) {
                v = fad;
                if (this.model.getType() == 1) {
                    value = null;
                }
            } else if (fad) {
                v = true;
                element.setToggleContainer(v);
            }
            Vector<Object> row = new Vector<Object>();
            row.setSize(this.columnHeadings.size());
            if (this.fileIndex != null) {
                row.set(this.fileIndex, element);
            }
            if (this.groupIndex != null) {
                row.set(this.groupIndex, group.getName());
            }
            if (this.ownerIndex != null) {
                row.set(this.ownerIndex, user.getUserName());
            }
            if (this.containerIndex != null) {
                row.set(this.containerIndex, new DataNodeElement(node, value));
            }
            if (this.folderAsDatasetIndex != null) {
                row.set(this.folderAsDatasetIndex, v);
            }
            if (this.sizeIndex != null) {
                row.set(this.sizeIndex, element.getFileLengthAsString());
            }
            dtm.addRow(row);
        }
        this.model.onSelectionChanged();
    }

    long getSizeFilesInQueue() {
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        long size = 0L;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, this.fileIndex);
            size += element.getFileLength();
        }
        return size;
    }

    void markFolderAsDataset(boolean fad) {
        int n = this.table.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, this.fileIndex);
            if (!element.isDirectory()) continue;
            dtm.setValueAt(fad, i, this.folderAsDatasetIndex);
        }
    }

    void resetFilesName() {
        int n = this.table.getRowCount();
        if (n == 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)model.getValueAt(i, this.fileIndex);
            element.setName(element.getFile().getAbsolutePath());
        }
        this.table.repaint();
    }

    void applyToAll() {
        int n = this.table.getRowCount();
        DefaultTableModel dtm = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < n; ++i) {
            FileElement element = (FileElement)dtm.getValueAt(i, this.fileIndex);
            if (element.isDirectory()) continue;
            element.setName(this.model.getDisplayedFileName(element.getFile().getAbsolutePath()));
        }
        this.table.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = Integer.parseInt(evt.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(ADD_PROPERTY, false, true);
                break;
            }
            case 1: {
                this.removeSelectedFiles();
                break;
            }
            case 2: {
                this.removeAllFiles();
            }
        }
    }

    class FileTableModel
    extends DefaultTableModel {
        FileTableModel() {
            super(null, FileSelectionTable.this.columnHeadings);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean) {
                if (col == FileSelectionTable.this.folderAsDatasetIndex) {
                    DataNodeElement element = (DataNodeElement)this.getValueAt(row, FileSelectionTable.this.containerIndex);
                    FileElement f = (FileElement)this.getValueAt(row, FileSelectionTable.this.fileIndex);
                    if (f.isDirectory() || !f.isDirectory() && f.isToggleContainer()) {
                        boolean b = (Boolean)value;
                        if (b) {
                            element.setName(f.getName());
                        } else {
                            element.setName(null);
                        }
                    }
                }
                super.setValueAt(value, row, col);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

