/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

@Deprecated
public class ExportAsCsv {
    String fName;

    public ExportAsCsv(String fileName) {
        this.fName = fileName;
    }

    public void export(DefaultMutableTreeNode tree, boolean addPath, boolean addUnitToKey) throws IOException {
        if (tree == null) {
            return;
        }
        HashMap<String, List<TagData>> input = MDEHelper.getInput(tree);
        List<String[]> data = this.convertData(input, addPath, addUnitToKey);
        this.createFile(data);
    }

    public void exportAll(DefaultMutableTreeNode tree, boolean addPath, boolean addUnitToKey) throws IOException {
        if (tree == null) {
            return;
        }
        HashMap<String, List<TagData>> input = MDEHelper.getAllData(tree);
        List<String[]> data = this.convertData(input, addPath, addUnitToKey);
        this.createFile(data);
    }

    private List<String[]> convertData(HashMap<String, List<TagData>> input, boolean addPath, boolean addUnitToKey) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            if (entry.getValue() == null) continue;
            for (TagData t : entry.getValue()) {
                if (t.getTagValue() == null || t.getTagValue().trim().isEmpty()) continue;
                Object key = entry.getKey() + " | " + t.getTagName();
                String value = t.getTagWholeValue();
                if (!addPath) {
                    key = t.getTagName();
                }
                if (addUnitToKey && t.getTagUnitString() != null && !t.getTagUnitString().isEmpty()) {
                    key = (String)key + " (" + t.getTagUnitString() + ")";
                    value = t.getTagValue();
                }
                data.add(new String[]{key, value});
            }
        }
        return data;
    }

    private void createFile(List<String[]> data) throws IOException {
        if (data != null) {
            File csvOutputFile = new File(this.fName);
            try (PrintWriter pw = new PrintWriter(csvOutputFile);){
                data.stream().map(this::convertToCSVString).forEach(pw::println);
            }
        }
    }

    private String convertToCSVString(String[] data) {
        return Stream.of(data).collect(Collectors.joining(","));
    }
}

