/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.util.AnalysisResultsItem;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class AnalysisResultsFileLoader
extends EditorLoader {
    private CallHandle handle;
    private Map<FileAnnotationData, File> results;
    private AnalysisResultsItem item;
    private int total;

    public AnalysisResultsFileLoader(Editor viewer, SecurityContext ctx, AnalysisResultsItem item) {
        super(viewer, ctx);
        if (item == null) {
            throw new IllegalArgumentException("No files to load");
        }
        this.item = item;
        List<FileAnnotationData> attachments = item.getAttachments();
        if (attachments == null || attachments.size() == 0) {
            throw new IllegalArgumentException("No files to load");
        }
        this.results = new HashMap<FileAnnotationData, File>();
        this.total = attachments.size();
    }

    @Override
    public void cancel() {
        this.handle.cancel();
        this.item.notifyLoading(false);
    }

    @Override
    public void load() {
        List<FileAnnotationData> attachments = this.item.getAttachments();
        Iterator<FileAnnotationData> i = attachments.iterator();
        HashMap<FileAnnotationData, File> map = new HashMap<FileAnnotationData, File>();
        String dir = MetadataViewerAgent.getTmpDir();
        while (i.hasNext()) {
            FileAnnotationData fa = i.next();
            File f = new File(dir + File.separator + fa.getFileID() + "_" + fa.getFileName());
            f.deleteOnExit();
            map.put(fa, f);
        }
        this.handle = this.mhView.loadFiles(this.ctx, map, this);
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Map m = (Map)fe.getPartialResult();
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                FileAnnotationData fa = (FileAnnotationData)entry.getKey();
                this.results.put(fa, (File)entry.getValue());
            }
            if (this.results.size() == this.total) {
                this.item.setLoadedFiles(this.results);
                this.viewer.analysisResultsLoaded(this.item);
            }
        }
    }

    @Override
    public void handleNullResult() {
    }
}

