/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsChanged;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.TitlePanel;

class MetadataViewerUI
extends TopWindow
implements PropertyChangeListener {
    private static final String PROJECT_MSG = "Project";
    private static final String DATASET_MSG = "Dataset";
    private static final String IMAGE_MSG = "Image";
    private static final String TITLE = "Add metadata";
    private static final String DESCRIPTION = "Add comments, tags, etc., to the selected items.";
    private MetadataViewerControl controller;
    private MetadataViewerModel model;
    private JPanel uiDelegate;
    private TitlePanel titlePanel;
    private List<ViewedByItem> viewedByItems = new ArrayList<ViewedByItem>();

    private String getMessage() {
        Class<?> nodeType = this.model.getRefObject().getClass();
        if (nodeType.equals(ProjectData.class)) {
            return PROJECT_MSG;
        }
        if (nodeType.equals(DatasetData.class)) {
            return DATASET_MSG;
        }
        if (nodeType.equals(ImageData.class)) {
            return IMAGE_MSG;
        }
        return "";
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        this.titlePanel = new TitlePanel(TITLE, DESCRIPTION, icons.getIcon(43));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        JSplitPane pane = new JSplitPane();
        pane.setResizeWeight(1.0);
        pane.setOrientation(1);
        pane.setOneTouchExpandable(true);
        pane.setContinuousLayout(true);
        pane.setLeftComponent(this.model.getEditor().getUI());
        this.uiDelegate = new JPanel();
        this.uiDelegate.setLayout(new BorderLayout(0, 0));
        this.uiDelegate.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uiDelegate.add((Component)this.model.getEditor().getUI(), "Center");
        c.add((Component)((Object)this.titlePanel), "North");
        c.add((Component)this.uiDelegate, "Center");
    }

    MetadataViewerUI() {
        super("");
    }

    void initialize(MetadataViewerControl controller, MetadataViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.buildGUI();
        this.setName("metadata viewer window");
    }

    void setRootObject() {
        String message = this.getMessage();
        this.titlePanel.setTitle(message);
        this.titlePanel.setSubtitle("Edit the " + message.toLowerCase() + ": " + this.model.getRefObjectName());
        this.uiDelegate.revalidate();
        this.uiDelegate.repaint();
        this.viewedByItems.clear();
    }

    JComponent getUI() {
        return this.uiDelegate;
    }

    void onChannelColorChanged(int index) {
        this.model.getEditor().onChannelColorChanged(index);
    }

    void createViewedByItems() {
        this.viewedByItems.clear();
        Map m = this.model.getViewedBy();
        Iterator i = m.entrySet().iterator();
        long id = this.model.getSelectedViewedByDef();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ExperimenterData exp = (ExperimenterData)e.getKey();
            ImageData img = this.model.getImage();
            if (img == null) continue;
            RndProxyDef def = (RndProxyDef)e.getValue();
            boolean isOwnerSetting = img.getOwner().getId() == exp.getId();
            ViewedByItem item = new ViewedByItem(exp, def, isOwnerSetting);
            if (def.getData().getId().getValue() == id) {
                item.setSelected(true);
            }
            item.addPropertyChangeListener("viewedBy", this);
            this.viewedByItems.add(item);
        }
        Renderer rnd = this.model.getEditor().getRenderer();
        if (rnd != null) {
            rnd.loadRndSettings(true, null);
        }
    }

    void setThumbnails(Map<Long, BufferedImage> thumbnails) {
        if (this.viewedByItems.isEmpty()) {
            return;
        }
        for (ViewedByItem item : this.viewedByItems) {
            BufferedImage img = thumbnails.get(item.getExperimenterID());
            if (img == null) continue;
            item.setImage(img);
        }
        Renderer renderer = this.model.getEditor().getRenderer();
        if (renderer != null) {
            this.model.getEditor().getRenderer().loadRndSettings(false, this.viewedByItems);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("viewedBy".equals(evt.getPropertyName())) {
            this.model.applyRenderingSettings((RndProxyDef)evt.getNewValue());
            RndSettingsChanged e = new RndSettingsChanged(this.model.getImage().getId());
            MetadataViewerAgent.getRegistry().getEventBus().post(e);
        }
    }

    @Override
    public void setOnScreen() {
    }
}

