/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class DataObjectCreator
extends DataTreeViewerLoader {
    private DataObject userObject;
    private DataObject parent;
    private Collection children;
    private CallHandle handle;

    public DataObjectCreator(TreeViewer viewer, SecurityContext ctx, DataObject userObject, DataObject parent) {
        this(viewer, ctx, userObject, parent, null);
    }

    public DataObjectCreator(TreeViewer viewer, SecurityContext ctx, DataObject userObject, DataObject parent, Collection children) {
        super(viewer, ctx);
        if (userObject == null) {
            throw new IllegalArgumentException("No object to create.");
        }
        this.parent = parent;
        this.userObject = userObject;
        this.children = children;
    }

    @Override
    public void load() {
        this.handle = this.children == null || this.children.size() == 0 ? this.dmView.createDataObject(this.ctx, this.userObject, this.parent, this) : this.mhView.createDataObject(this.ctx, this.parent, this.userObject, this.children, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        List l = (List)result;
        DataObject d = null;
        if (l != null && l.size() == 1) {
            d = (DataObject)l.get(0);
        }
        this.viewer.onDataObjectSave(d, this.parent, 300);
    }
}

