/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class PlateWellsLoader
extends DataTreeViewerLoader {
    private Map<Long, TreeImageSet> nodes;
    private CallHandle handle;
    private boolean withThumbnails;
    private Map<Long, Long> ids;

    public PlateWellsLoader(TreeViewer viewer, SecurityContext ctx, List<TreeImageSet> plates, boolean withThumbnails) {
        super(viewer, ctx);
        if (plates == null || plates.size() == 0) {
            throw new IllegalArgumentException("No plates specified.");
        }
        this.withThumbnails = withThumbnails;
        this.nodes = new HashMap<Long, TreeImageSet>(plates.size());
        this.ids = new HashMap<Long, Long>(plates.size());
        for (TreeImageSet p : plates) {
            DataObject data = (DataObject)p.getUserObject();
            if (data instanceof PlateAcquisitionData) {
                PlateAcquisitionData sa = (PlateAcquisitionData)data;
                TreeImageDisplay parent = p.getParentDisplay();
                DataObject parentData = (DataObject)parent.getUserObject();
                if (!(parentData instanceof PlateData)) continue;
                this.nodes.put(parentData.getId(), p);
                this.ids.put(parentData.getId(), data.getId());
                continue;
            }
            if (!(data instanceof PlateData)) continue;
            this.nodes.put(data.getId(), p);
            this.ids.put(data.getId(), -1L);
        }
    }

    @Override
    public void load() {
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        this.handle = this.dmView.loadPlateWells(this.ctx, this.ids, exp.getId(), this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        Map m = (Map)result;
        HashMap<TreeImageSet, Collection> plates = new HashMap<TreeImageSet, Collection>();
        for (Map.Entry entry : m.entrySet()) {
            plates.put(this.nodes.get(entry.getKey()), (Collection)entry.getValue());
        }
        this.viewer.setPlates(plates, this.withThumbnails);
    }
}

