/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.GenericFileChooser;

public class ScriptUploaderDialog
extends JDialog
implements ActionListener {
    public static final String UPLOAD_SCRIPT_PROPERTY = "uploadScript";
    public static final String FILESELECTION_PROPERTY = "SelectedFileChangedProperty";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final String TITLE = "Upload Script";
    private static final String TEXT = "Select the script to upload";
    private static final int SAVE = 0;
    private static final int CANCEL = 1;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();
    private GenericFileChooser chooser;
    private JButton saveButton;
    private JButton cancelButton;
    private JTextField location;
    private JButton locationFinder;
    private List<ScriptObject> scripts;
    private List<String> folders;
    private JPopupMenu menu;
    private Registry context;

    private void initComponents() {
        this.folders = new ArrayList<String>();
        this.chooser = new GenericFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(true);
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        while (i.hasNext()) {
            this.chooser.addChoosableFileFilter(i.next());
        }
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ScriptUploaderDialog.FILESELECTION_PROPERTY.equals(evt.getPropertyName())) {
                    File f = ScriptUploaderDialog.this.chooser.getSelectedFile();
                    ScriptUploaderDialog.this.saveButton.setEnabled(f != null && f.isFile());
                }
            }
        });
        this.saveButton = new JButton("Upload");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Upload the selected script to the server."));
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(UIUtilities.formatToolTipText("Closes the dialog."));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("1");
        this.location = new JTextField();
        this.locationFinder = new JButton("Find Folder");
        this.locationFinder.setToolTipText("List the existing folders.");
        this.locationFinder.setEnabled(this.folders.size() > 0);
        this.locationFinder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ScriptUploaderDialog.this.showFolderList(e.getPoint());
            }
        });
        this.saveButton.setEnabled(false);
    }

    private JPanel buildControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        controls.add((Component)this.buildToolbar(), "Center");
        JPanel folder = new JPanel();
        folder.setLayout(new BorderLayout());
        JLabel l = new JLabel("Upload into Folder:");
        folder.add((Component)l, "West");
        folder.add((Component)this.location, "Center");
        folder.add((Component)this.locationFinder, "East");
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        p.add((Component)this.chooser, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)folder, c);
        ++c.gridy;
        p.add((Component)controls, c);
        return p;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(151));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildControls(), "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void upload() {
        File f = this.chooser.getSelectedFile();
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        boolean supported = false;
        String mimeType = null;
        while (i.hasNext()) {
            CustomizedFileFilter filter = i.next();
            if (!filter.accept(f)) continue;
            supported = true;
            mimeType = filter.getMIMEType();
            break;
        }
        if (!supported) {
            UserNotifier un = this.context.getUserNotifier();
            un.notifyInfo(TITLE, "The selected script does not seem to be supported.");
            return;
        }
        if (this.scripts != null) {
            MessageBox box;
            boolean exists = false;
            ScriptObject tmp = new ScriptObject(-1L, "", f.getName());
            String name = tmp.getDisplayedName();
            for (ScriptObject s : this.scripts) {
                String value = s.getDisplayedName();
                if (!value.equals(name)) continue;
                exists = true;
                break;
            }
            if (exists && (box = new MessageBox((JFrame)this.getOwner(), TITLE, "A script with the same name already exists in the system.\nDo you still want to upload the script?")).centerMsgBox() == 0) {
                return;
            }
        }
        ScriptObject script = new ScriptObject(-1L, f.getAbsolutePath(), f.getName());
        script.setMIMEType(mimeType);
        String value = this.location.getText();
        if (CommonsLangUtils.isNotEmpty(value)) {
            script.setFolder(value.trim());
        } else {
            script.setFolder(f.getParentFile().getName());
        }
        IconManager icons = IconManager.getInstance();
        script.setIcon(icons.getIcon(152));
        this.firePropertyChange(UPLOAD_SCRIPT_PROPERTY, null, script);
        this.close();
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void showFolderList(Point p) {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            int index = 2;
            Iterator<String> i = this.folders.iterator();
            while (i.hasNext()) {
                JMenuItem item = new JMenuItem(i.next());
                item.setActionCommand("" + index);
                item.addActionListener(this);
                ++index;
                this.menu.add(item);
            }
        }
        this.menu.show(this.locationFinder, p.x, p.y);
    }

    public ScriptUploaderDialog(JFrame owner, Registry context, SecurityContext ctx) {
        super(owner);
        this.context = context;
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.loadScripts(ctx);
        this.pack();
    }

    void setScripts(List<ScriptObject> scripts) {
        this.scripts = scripts;
        for (ScriptObject s : scripts) {
            String folder = s.getFolder();
            if (folder.startsWith("/")) {
                folder = folder.replaceFirst("/", "");
            }
            if (folder.endsWith("/")) {
                folder = folder.substring(0, folder.length() - 1);
            }
            if (this.folders.contains(folder)) continue;
            this.folders.add(folder);
        }
        this.locationFinder.setEnabled(!this.folders.isEmpty());
    }

    private void loadScripts(final SecurityContext ctx) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    OmeroImageService svc = ScriptUploaderDialog.this.context.getImageService();
                    final List<ScriptObject> scripts = svc.loadAvailableScripts(ctx, -1L);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ScriptUploaderDialog.this.setScripts(scripts);
                        }
                    });
                }
                catch (Exception e) {
                    LogMessage m = new LogMessage("Couldn't load scripts", (Throwable)e);
                    ScriptUploaderDialog.this.context.getLogger().error((Object)ScriptUploaderDialog.this, m);
                }
            }
        };
        new Thread(r).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.close();
                break;
            }
            case 0: {
                this.upload();
                break;
            }
            default: {
                if (!(e.getSource() instanceof JMenuItem)) break;
                JMenuItem item = (JMenuItem)e.getSource();
                this.location.setText(item.getText());
            }
        }
    }

    static {
        FILTERS.add(new CppFilter());
        FILTERS.add(new JavaFilter());
        FILTERS.add(new MatlabFilter());
        FILTERS.add(new PythonFilter());
    }
}

