/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import Ice.Current;
import java.util.HashMap;
import java.util.Map;
import omero.RString;
import omero.RType;
import omero.ServerError;
import omero.client;
import omero.grid.ProcessCallbackI;
import omero.grid.ProcessPrx;
import omero.grid.ScriptProcessPrx;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.model.ParamData;

public class ScriptCallback
extends ProcessCallbackI {
    private long scriptID;
    private DSCallAdapter adapter;
    private boolean finished;
    private boolean submitted;
    private Map<String, Object> results;

    public ScriptCallback(long scriptID, ProcessCallbackI pcb) throws ServerError {
        super(pcb);
        this.scriptID = scriptID;
        this.results = null;
    }

    public ScriptCallback(long scriptID, client client2, ScriptProcessPrx process) throws ServerError {
        super(client2, (ProcessPrx)process);
        this.scriptID = scriptID;
        this.results = null;
    }

    public void setAdapter(DSCallAdapter adapter) {
        this.adapter = adapter;
        if (this.finished && adapter != null && !this.submitted) {
            adapter.handleResult(this.results);
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getName() {
        String value = "";
        try {
            RString desc = ((ScriptProcessPrx)this.process).getJob().getDescription();
            if (desc != null) {
                value = desc.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void cancel() throws ProcessException {
        try {
            this.process.cancel();
            this.close();
        }
        catch (Exception e) {
            throw new ProcessException("Cannot cancel the following script:" + this.getName());
        }
    }

    public void processFinished(int value, Current current) {
        super.processFinished(value, current);
        this.finished = true;
        try {
            Map r = ((ScriptProcessPrx)this.process).getResults(0);
            if (r != null) {
                this.results = new HashMap<String, Object>();
                for (Map.Entry entry : r.entrySet()) {
                    this.results.put((String)entry.getKey(), ParamData.convertRType((RType)entry.getValue()));
                }
            }
            if (this.adapter != null) {
                this.submitted = true;
                this.adapter.handleResult(this.results);
            }
        }
        catch (Exception e) {
            this.finished = false;
        }
        if (this.finished && this.submitted) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processCancelled(boolean value, Current current) {
        super.processCancelled(value, current);
        if (this.adapter != null) {
            this.adapter.handleResult(null);
        }
    }

    public void processKilled(boolean value, Current current) {
        super.processKilled(value, current);
        if (this.adapter != null) {
            this.adapter.handleResult(null);
        }
    }
}

