/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MovieExportParam {
    public static final String MOVIE_SCRIPT = "/omero/export_scripts/Make_Movie.py";
    public static final int Z_MOVIE = 0;
    public static final int T_MOVIE = 1;
    public static final int ZT_MOVIE = 2;
    public static final int MPEG = 2;
    public static final int QT = 1;
    public static final int WMV = 0;
    public static final Map<Integer, String> FORMATS = new LinkedHashMap<Integer, String>(3);
    public static final int DEFAULT_FPS = 25;
    private static final String MPEG_EXTENSION = ".avi";
    private static final String WMV_EXTENSION = ".wmv";
    private static final String QT_EXTENSION = ".avi";
    private static final int SCALE_BAR = 1;
    private String name;
    private int fps;
    private int format;
    private int scaleBar;
    private int startT;
    private int endT;
    private int startZ;
    private int endZ;
    private int type;
    private boolean labelVisible;
    private String color;
    private List<Integer> channels;

    private void checkType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported.");
            }
        }
    }

    private String checkFormat(int value, String name) {
        switch (value) {
            case 2: {
                if (name.endsWith(".avi")) {
                    name = name.substring(0, name.length() - ".avi".length());
                }
                return name;
            }
            case 0: {
                if (name.endsWith(WMV_EXTENSION)) {
                    name = name.substring(0, name.length() - WMV_EXTENSION.length());
                }
                return name;
            }
            case 1: {
                if (name.endsWith(".avi")) {
                    name = name.substring(0, name.length() - ".avi".length());
                }
                return name;
            }
        }
        throw new IllegalArgumentException("Format not supported.");
    }

    private void initialize() {
        this.startT = -1;
        this.startZ = -1;
        this.endT = -1;
        this.endZ = -1;
    }

    public MovieExportParam(String name, int fps, int format, int scaleBar, int type) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("No name specified.");
        }
        this.checkType(type);
        this.name = this.checkFormat(format, name);
        this.type = type;
        if (fps <= 0) {
            fps = 25;
        }
        this.fps = fps;
        this.format = format;
        if (scaleBar < 0) {
            scaleBar = 1;
        }
        this.scaleBar = scaleBar;
        this.labelVisible = false;
        this.color = null;
        this.initialize();
    }

    public void setChannels(List<Integer> channels) {
        this.channels = channels;
    }

    public List<Integer> getChannels() {
        return this.channels;
    }

    public void setTimeInterval(int startT, int endT) {
        this.startT = startT;
        this.endT = endT;
    }

    public void setZsectionInterval(int startZ, int endZ) {
        this.startZ = startZ;
        this.endZ = endZ;
    }

    public boolean isZSectionSet() {
        return this.startZ != -1 || this.endZ != -1;
    }

    public boolean isTimeIntervalSet() {
        return this.startT != -1 || this.endT != -1;
    }

    public String getName() {
        return this.name;
    }

    public int getFps() {
        return this.fps;
    }

    public int getFormat() {
        return this.format;
    }

    public int getScaleBar() {
        if (this.scaleBar < 1) {
            this.scaleBar = 1;
        }
        return this.scaleBar;
    }

    public int getStartT() {
        return this.startT;
    }

    public int getEndT() {
        return this.endT;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public int getType() {
        return this.type;
    }

    public String getFormatAsString() {
        switch (this.format) {
            case 2: {
                return "MPEG";
            }
            case 1: {
                return "Quicktime";
            }
            case 0: {
                return "WMV";
            }
        }
        return "";
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    public void setColor(String color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public String getScriptName() {
        return MOVIE_SCRIPT;
    }

    static {
        FORMATS.put(0, "Windows Media Player");
        FORMATS.put(1, "Quick Time");
        FORMATS.put(2, "MPEG");
    }
}

