/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DataSourceException;
import omero.gateway.model.PixelsData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.rnd.roi.AbstractROIShapeStats;
import org.openmicroscopy.shoola.env.rnd.roi.PointIterator;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStatsSimple;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class ROIAnalyser {
    private PointIterator runner;
    private int sizeZ;
    private int sizeT;
    private int sizeC;

    private boolean checkPlane(int z, int t) {
        if (z < 0 || this.sizeZ <= z) {
            return false;
        }
        return t >= 0 && this.sizeT > t;
    }

    private boolean matchesPlane(int z, int t, Coord3D plane) {
        return !(z != plane.getZSection() && plane.getZSection() >= 0 || t != plane.getTimePoint() && plane.getTimePoint() >= 0);
    }

    private boolean checkChannel(int w) {
        return w >= 0 && this.sizeC > w;
    }

    public ROIAnalyser(Gateway gateway, PixelsData pixels) throws ExecutionException {
        this.runner = new PointIterator(gateway, pixels);
        this.sizeZ = pixels.getSizeZ();
        this.sizeT = pixels.getSizeT();
        this.sizeC = pixels.getSizeC();
    }

    public Map<ROIShape, Map<Integer, AbstractROIShapeStats>> analyze(SecurityContext ctx, ROIShape[] shapes, Collection<Integer> channels, Coord3D plane) throws DataSourceException {
        if (shapes == null) {
            throw new NullPointerException("No shapes.");
        }
        if (shapes.length == 0) {
            throw new IllegalArgumentException("No shapes defined.");
        }
        if (CollectionUtils.isEmpty(channels)) {
            throw new IllegalArgumentException("No channels defined.");
        }
        HashMap<ROIShape, Map<Integer, AbstractROIShapeStats>> r = new HashMap<ROIShape, Map<Integer, AbstractROIShapeStats>>();
        int n = channels.size();
        boolean close = false;
        for (int i = 0; i < shapes.length; ++i) {
            ROIShape shape = shapes[i];
            boolean bl = close = i == shapes.length - 1;
            if (!this.checkPlane(shape.getZ(), shape.getT())) continue;
            HashMap<Integer, ROIShapeStatsSimple> stats = new HashMap<Integer, ROIShapeStatsSimple>(n);
            if (plane == null || this.matchesPlane(shape.getZ(), shape.getT(), plane)) {
                Iterator<Integer> j = channels.iterator();
                List<Point> points = shape.getFigure().getPoints();
                int count = 0;
                boolean last = false;
                while (j.hasNext()) {
                    Integer w = j.next();
                    if (this.checkChannel(w)) {
                        ROIShapeStatsSimple computer = new ROIShapeStatsSimple();
                        this.runner.register(computer);
                        if (close) {
                            last = count == channels.size() - 1;
                        }
                        this.runner.iterate(ctx, shape, points, w, last);
                        this.runner.remove(computer);
                        stats.put(w, computer);
                    }
                    ++count;
                }
            }
            r.put(shape, stats);
        }
        return r;
    }
}

