/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import ij.IJ;
import ij.ImagePlus;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.events.HeartbeatEvent;
import org.openmicroscopy.shoola.env.data.events.LogOff;
import org.openmicroscopy.shoola.env.data.events.ReconnectedEvent;
import org.openmicroscopy.shoola.env.data.events.RemoveGroupEvent;
import org.openmicroscopy.shoola.env.data.events.SaveEventResponse;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.data.events.SwitchUserGroup;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.AbstractIconManager;
import org.openmicroscopy.shoola.env.ui.CheckoutBox;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.SoftwareUpdateDialog;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TaskBarView;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierImpl;
import org.openmicroscopy.shoola.env.ui.login.ScreenLoginDialog;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TaskBarManager
implements AgentEventListener,
PropertyChangeListener {
    static final String TITLE_ABOUT = "About";
    static final String ACTIVITIES_PROPERTY = "activities";
    private static final String CLOSE_APP_TITLE = "Exit Application";
    private static final String CLOSE_APP_TEXT = "Do you really want to close the application?";
    private static final String CLOSE_PLUGIN_TITLE = "Exit Plugin";
    private static final String CLOSE_PLUGIN_TEXT = "Do you really want to close the plugin?";
    private static final String LOGOUT_TITLE = "Log out";
    private static final String LOGOUT_TEXT = "Do you really want to disconnect from the server?";
    private TaskBarView view;
    private Container container;
    private SoftwareUpdateDialog suDialog;
    private ScreenLoginDialog login;
    private boolean success;
    private ScreenLoginDialog reconnectDialog;
    private Map<Integer, ActionListener> helpMenuActions;

    private Icon getSplashScreen(Icon splashScreen) {
        Integer v;
        if (splashScreen == null && (v = (Integer)this.container.getRegistry().lookup("/application/entryPoint")) != null) {
            switch (v) {
                case 2: {
                    splashScreen = IconManager.getImporterSplashScreen();
                    break;
                }
                default: {
                    splashScreen = IconManager.getSplashScreen();
                }
            }
        }
        return splashScreen;
    }

    private String loadAbout(String file) {
        String message;
        String version = (String)this.container.getRegistry().lookup("Version");
        try (InputStream fis = IOUtil.readConfigFile(file);
             BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
            String line;
            StringBuffer buffer = new StringBuffer();
            int number = 0;
            while ((line = in.readLine()) != null) {
                if (number != 0) {
                    line = line.replaceAll("\\@VERSION\\@", version);
                    buffer.append(line);
                }
                ++number;
            }
            message = buffer.toString();
        }
        catch (Exception e) {
            message = "Error: Cannot find the About file.";
            Logger logger = this.container.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print(message);
            msg.print((Throwable)e);
            logger.error((Object)this, msg);
        }
        return message;
    }

    private void synchConnectionButtons() {
        boolean connected = false;
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            connected = f.isConnected();
        }
        catch (DSOutOfServiceException dSOutOfServiceException) {
            // empty catch block
        }
        this.view.getButton(9).setEnabled(!connected);
        this.view.getButton(1).setEnabled(!connected);
        this.view.getButton(10).setEnabled(connected);
        this.view.getButton(2).setEnabled(connected);
    }

    private void doManageConnection() {
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            if (f.isConnected()) {
                f.shutdown(null);
                this.synchConnectionButtons();
            } else {
                EventBus bus = this.container.getRegistry().getEventBus();
                bus.post(new ServiceActivationRequest(1));
            }
        }
        catch (DSOutOfServiceException oose) {
            this.synchConnectionButtons();
        }
    }

    private void handleSaveEventResponse(SaveEventResponse e) {
        if (e == null) {
            return;
        }
    }

    private void notAvailable() {
        UserNotifier un = this.container.getRegistry().getUserNotifier();
        un.notifyInfo("Not Available", "Sorry, this functionality is not yet available.");
    }

    private void sendComment() {
        Registry reg = this.container.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        ExperimenterData exp = (ExperimenterData)reg.lookup("/current_user/details");
        String email = "";
        if (exp != null) {
            email = exp.getEmail();
        }
        un.submitMessage(email, "");
    }

    private Map<Agent, AgentSaveInfo> getInstancesToSave() {
        List agents = (List)this.container.getRegistry().lookup("/agents");
        Iterator i = agents.iterator();
        HashMap<Agent, AgentSaveInfo> l = new HashMap<Agent, AgentSaveInfo>();
        while (i.hasNext()) {
            AgentSaveInfo info;
            Agent agent;
            AgentInfo ai = (AgentInfo)i.next();
            if (!ai.isActive() || (agent = ai.getAgent()) == null || (info = agent.getDataToSave()) == null || info.getCount() <= 0) continue;
            l.put(agent, info);
        }
        return l;
    }

    private void runAsImageJ(long id, SecurityContext ctx) {
        UserCredentials lc = (UserCredentials)this.container.getRegistry().lookup("/user/credentials");
        StringBuffer buffer = new StringBuffer();
        boolean largePlane = false;
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            Collection<ImageData> images = f.getOS().getImages(ctx, ImageData.class, Arrays.asList(id), -1L);
            PixelsData pixels = null;
            if (!images.isEmpty()) {
                ImageData image = images.iterator().next();
                pixels = image.getDefaultPixels();
                long pixelsId = pixels.getId();
                Boolean b = f.getIS().isLargeImage(ctx, pixelsId);
                if (b != null) {
                    largePlane = b;
                }
            }
            buffer.append("location=[OMERO] open=[omero:server=");
            buffer.append(lc.getServer().getHost());
            buffer.append("\nuser=");
            buffer.append(lc.getUser().getUsername());
            buffer.append("\nport=");
            buffer.append(lc.getServer().getPort());
            buffer.append("\npass=");
            buffer.append(lc.getUser().getPassword());
            buffer.append("\ngroupID=");
            buffer.append(ctx.getGroupID());
            buffer.append("\niid=");
            buffer.append(id);
            buffer.append("] ");
            buffer.append("view=Hyperstack windowless=false ");
            if (largePlane) {
                buffer.append("crop=true ");
            } else {
                buffer.append("crop=false ");
            }
            IJ.runPlugIn((String)"loci.plugins.LociImporter", (String)buffer.toString());
            ImagePlus img = IJ.getImage();
            img.setTitle(img.getTitle() + "--OMERO_ID_" + id);
            img.setProperty("Omero_iid", (Object)id);
            img.setProperty("Omero_group", (Object)ctx.getGroupID());
        }
        catch (Exception e) {
            LogMessage message = new LogMessage();
            message.println("Opening in image J");
            message.print((Throwable)e);
            this.container.getRegistry().getLogger().debug((Object)this, message);
            IJ.showMessage((String)"An error occurred while loading the image.");
        }
    }

    private void handleViewInPluginEvent(ViewInPluginEvent evt) {
        if (evt == null) {
            return;
        }
        switch (evt.getPlugin()) {
            case 1: 
            case 3: {
                this.runAsImageJ(evt.getObjectID(), evt.getSecurityContext());
            }
        }
    }

    private void handleSwitchUserGroup(SwitchUserGroup evt) {
        if (evt == null) {
            return;
        }
    }

    private void handleLogOff(LogOff evt) {
        if (evt == null) {
            return;
        }
        SecurityContext ctx = evt.getSecurityContext();
        if (!evt.isAskQuestion()) {
            this.logOut(ctx);
            return;
        }
        IconManager icons = IconManager.getInstance(this.container.getRegistry());
        Map<Agent, AgentSaveInfo> instances = this.getInstancesToSave();
        CheckoutBox msg = new CheckoutBox(this.view, LOGOUT_TITLE, LOGOUT_TEXT, icons.getIcon(10), instances);
        if (msg.centerMsgBox() == 1) {
            Map<Agent, AgentSaveInfo> map = msg.getInstancesToSave();
            if (map != null && map.size() > 0) {
                ArrayList<AgentSaveInfo> nodes = new ArrayList<AgentSaveInfo>();
                for (Map.Entry<Agent, AgentSaveInfo> entry : map.entrySet()) {
                    Agent agent = entry.getKey();
                    AgentSaveInfo info = entry.getValue();
                    agent.save(info.getInstances());
                    nodes.add(info);
                }
            }
            this.logOut(ctx);
        }
    }

    private void handleRemoveGroupEvent(RemoveGroupEvent evt) {
        if (evt == null) {
            return;
        }
        SecurityContext ctx = evt.getContext();
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            f.removeGroup(ctx);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Remove group");
            msg.print((Throwable)e);
            this.container.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    private void handleHeartbeatEvent(HeartbeatEvent evt) {
        if (evt == null) {
            return;
        }
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            f.checkServicesStatus();
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("checkServicesStatus");
            msg.print((Throwable)e);
            this.container.getRegistry().getLogger().debug((Object)this, msg);
        }
    }

    private void reconnect() {
        Image img = IconManager.getOMEImageIcon();
        Object version = this.container.getRegistry().lookup("Version");
        String v = "";
        if (version != null && version instanceof String) {
            v = (String)version;
        }
        OMEROInfo omeroInfo = (OMEROInfo)this.container.getRegistry().lookup("/services/OMERODS");
        String f = this.container.getConfigFileRelative("config");
        String n = (String)this.container.getRegistry().lookup("SplashScreenLogo");
        this.reconnectDialog = new ScreenLoginDialog("Open Microscopy Environment", this.getSplashScreen(Factory.createIcon(n, f)), img, v, this.container.getRegistry());
        this.reconnectDialog.setStatusVisible(false);
        this.reconnectDialog.showConnectionSpeed(true);
        this.reconnectDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UserCredentials lc;
                String name = evt.getPropertyName();
                if ("quit".equals(name)) {
                    TaskBarManager.this.exitApplication(null);
                } else if ("login".equals(name) && (lc = (UserCredentials)evt.getNewValue()) != null) {
                    lc.addCmdLineArgs(TaskBarManager.this.container.getRegistry().getCmdLineArgs());
                    TaskBarManager.this.collectCredentials(lc, (ScreenLoginDialog)evt.getSource());
                }
            }
        });
        this.reconnectDialog.setModal(true);
        UIUtilities.centerAndShow(this.reconnectDialog);
    }

    private void logOut(SecurityContext ctx) {
        LogMessage msg;
        if (ctx != null) {
            try {
                AdminService adminService = this.container.getRegistry().getAdminService();
            }
            catch (Exception e) {
                if (this.isRunAsIJPlugin()) {
                    IJ.log((String)e.getMessage());
                }
                Logger log = this.container.getRegistry().getLogger();
                msg = new LogMessage();
                msg.print((Throwable)e);
                log.error((Object)this, msg);
            }
        }
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            f.exitApplication(false, false);
            this.reconnect();
        }
        catch (Exception e) {
            UserNotifier un = this.container.getRegistry().getUserNotifier();
            un.notifyInfo(LOGOUT_TITLE, "An error occurred while disconnecting from the server.");
            msg = new LogMessage();
            msg.print(LOGOUT_TITLE);
            msg.print((Throwable)e);
            this.container.getRegistry().getLogger().debug((Object)this, msg);
        }
    }

    private void doExit(boolean askQuestion, SecurityContext ctx) {
        if (this.reconnectDialog != null) {
            this.exitApplication(ctx);
            return;
        }
        Environment env = (Environment)this.container.getRegistry().lookup("/env");
        String title = CLOSE_APP_TITLE;
        String message = CLOSE_APP_TEXT;
        if (env != null && env.isRunAsPlugin()) {
            title = CLOSE_PLUGIN_TITLE;
            message = CLOSE_PLUGIN_TEXT;
        }
        IconManager icons = IconManager.getInstance(this.container.getRegistry());
        int option = 1;
        Map<Agent, AgentSaveInfo> instances = this.getInstancesToSave();
        CheckoutBox msg = null;
        if (env.isRunAsPlugin()) {
            askQuestion = false;
        }
        if (askQuestion) {
            msg = new CheckoutBox(this.view, title, message, icons.getIcon(10), instances);
            msg.setYesText("Quit");
            msg.setNoText("Do Not Quit");
            option = msg.centerMsgBox();
        }
        if (option == 1) {
            if (msg == null) {
                this.exitApplication(ctx);
            } else {
                Map<Agent, AgentSaveInfo> map = msg.getInstancesToSave();
                if (map == null || map.size() == 0) {
                    this.exitApplication(ctx);
                } else {
                    ArrayList<AgentSaveInfo> nodes = new ArrayList<AgentSaveInfo>();
                    for (Map.Entry<Agent, AgentSaveInfo> entry : map.entrySet()) {
                        Agent agent = entry.getKey();
                        AgentSaveInfo info = entry.getValue();
                        agent.save(info.getInstances());
                        nodes.add(info);
                    }
                    this.exitApplication(ctx);
                }
            }
        }
    }

    private boolean isRunAsIJPlugin() {
        Environment env = (Environment)this.container.getRegistry().lookup("/env");
        if (env == null) {
            return false;
        }
        return env.runAsPlugin() >= 0;
    }

    private void exitApplication(SecurityContext ctx) {
        LogMessage msg;
        Logger log;
        this.reconnectDialog = null;
        if (ctx != null) {
            try {
                AdminService adminService = this.container.getRegistry().getAdminService();
            }
            catch (Exception e) {
                if (this.isRunAsIJPlugin()) {
                    IJ.log((String)e.getMessage());
                }
                log = this.container.getRegistry().getLogger();
                msg = new LogMessage();
                msg.print((Throwable)e);
                log.error((Object)this, msg);
            }
        }
        try {
            DataServicesFactory f = DataServicesFactory.getInstance(this.container);
            f.exitApplication(false, true);
        }
        catch (Exception e) {
            if (this.isRunAsIJPlugin()) {
                IJ.log((String)e.getMessage());
            }
            log = this.container.getRegistry().getLogger();
            msg = new LogMessage();
            msg.print("Error while exiting");
            msg.print((Throwable)e);
            log.error((Object)this, msg);
        }
    }

    private void softwareAbout() {
        String aboutFile = (String)this.container.getRegistry().lookup("AboutFile");
        String refFile = this.container.getConfigFileRelative(aboutFile);
        String message = this.loadAbout(refFile);
        String title = (String)this.container.getRegistry().lookup("SoftwareName");
        this.suDialog = new SoftwareUpdateDialog(this.view, message);
        this.suDialog.setTitle("About " + title + "...");
        this.suDialog.setAlwaysOnTop(true);
        this.suDialog.addPropertyChangeListener("openURL", this);
        UIUtilities.centerAndShow(this.suDialog);
    }

    private void help() {
        String path = (String)this.container.getRegistry().lookup("HelpOnLine");
        this.openURL(path);
    }

    private void forum() {
        String path = (String)this.container.getRegistry().lookup("Forum");
        this.openURL(path);
    }

    private void logFile() {
        String logDirName = (String)this.container.getRegistry().lookup("/services/LOG/dir");
        String name = (String)this.container.getRegistry().lookup("/user/home/omero");
        String path = name + File.separator + logDirName;
        Object url = path;
        try {
            url = new File(path).toURI().toURL().toString();
            url = ((String)url).replaceAll("^file:/", "file:///");
            this.openURL((String)url);
        }
        catch (Exception e) {
            this.container.getRegistry().getLogger().error((Object)this, "Unable to open log directory.");
        }
    }

    private void createHelpMenuActionListeners() {
        this.helpMenuActions = new HashMap<Integer, ActionListener>();
        ActionListener noOp = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.notAvailable();
            }
        };
        this.helpMenuActions.put(3, noOp);
        this.helpMenuActions.put(4, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.help();
            }
        });
        this.helpMenuActions.put(5, noOp);
        this.helpMenuActions.put(6, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.softwareAbout();
            }
        });
        this.helpMenuActions.put(7, noOp);
        this.helpMenuActions.put(11, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.help();
            }
        });
        this.helpMenuActions.put(12, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.sendComment();
            }
        });
        this.helpMenuActions.put(13, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.forum();
            }
        });
        this.helpMenuActions.put(14, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((UserNotifierImpl)TaskBarManager.this.container.getRegistry().getUserNotifier()).showActivity();
            }
        });
        this.helpMenuActions.put(15, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskBarManager.this.logFile();
            }
        });
    }

    public ActionListener getHelpMenuAction(int id) {
        return this.helpMenuActions.get(id);
    }

    private void attachMIListeners() {
        this.view.getButton(3).addActionListener(this.getHelpMenuAction(3));
        this.view.getButton(4).addActionListener(this.getHelpMenuAction(4));
        this.view.getButton(5).addActionListener(this.getHelpMenuAction(5));
        this.view.getButton(6).addActionListener(this.getHelpMenuAction(6));
        this.view.getButton(7).addActionListener(this.getHelpMenuAction(7));
        this.view.getButton(11).addActionListener(this.getHelpMenuAction(11));
        this.view.getButton(12).addActionListener(this.getHelpMenuAction(12));
        this.view.getButton(13).addActionListener(this.getHelpMenuAction(13));
        this.view.getButton(14).addActionListener(this.getHelpMenuAction(14));
        this.view.getButton(15).addActionListener(this.getHelpMenuAction(15));
    }

    private void attachConnectionListeners() {
        ActionListener conx = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TaskBarManager.this.doManageConnection();
            }
        };
        this.view.getButton(9).addActionListener(conx);
        this.view.getButton(1).addActionListener(conx);
        this.view.getButton(10).addActionListener(conx);
        this.view.getButton(2).addActionListener(conx);
    }

    private void attachOpenExitListeners() {
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                TaskBarManager.this.doExit(true, null);
            }

            @Override
            public void windowOpened(WindowEvent we) {
                TaskBarManager.this.synchConnectionButtons();
            }
        });
    }

    private void attachListeners() {
        this.attachOpenExitListeners();
        this.attachConnectionListeners();
        this.attachMIListeners();
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationResponse.class);
        bus.register((AgentEventListener)this, ExitApplication.class);
        bus.register((AgentEventListener)this, SaveEventResponse.class);
        bus.register((AgentEventListener)this, SwitchUserGroup.class);
        bus.register((AgentEventListener)this, LogOff.class);
        bus.register((AgentEventListener)this, ViewInPluginEvent.class);
        bus.register((AgentEventListener)this, RemoveGroupEvent.class);
        bus.register((AgentEventListener)this, HeartbeatEvent.class);
        if (UIUtilities.isMacOS()) {
            try {
                MacOSMenuHandler handler = new MacOSMenuHandler(this.view);
                handler.initialize();
                this.view.addPropertyChangeListener(this);
            }
            catch (Throwable e) {
                Logger logger = this.container.getRegistry().getLogger();
                LogMessage message = new LogMessage();
                message.print(e);
                logger.info((Object)this, message);
            }
        }
    }

    private void collectCredentials(UserCredentials lc, ScreenLoginDialog dialog) {
        LoginService svc = (LoginService)this.container.getRegistry().lookup("/services/Login");
        this.success = false;
        switch (svc.login(lc)) {
            case 1: {
                this.container.getRegistry().bind("/user/credentials", lc);
                dialog.close();
                if (dialog == this.reconnectDialog) {
                    this.reconnectDialog = null;
                    this.container.getRegistry().getEventBus().post(new ReconnectedEvent());
                }
                this.success = true;
                break;
            }
            case 2: {
                this.success = false;
                svc.notifyLoginTimeout();
                if (dialog == null) break;
                dialog.cleanField(1);
                dialog.onLoginFailure();
                break;
            }
            case 0: {
                this.success = false;
                svc.notifyLoginFailure();
                if (dialog == null) break;
                dialog.cleanField(1);
                dialog.onLoginFailure();
            }
        }
    }

    TaskBarManager(Container c) {
        this.container = c;
        this.createHelpMenuActionListeners();
        this.view = new TaskBarView(this, IconManager.getInstance(c.getRegistry()));
        this.attachListeners();
    }

    TaskBar getView() {
        return this.view;
    }

    String getSoftwareName() {
        return (String)this.container.getRegistry().lookup("SoftwareName");
    }

    void openURL(String url) {
        BrowserLauncher launcher = new BrowserLauncher(AbstractIconManager.getOMEImageIcon());
        launcher.openURL(url);
        if (this.suDialog != null) {
            this.suDialog.close();
        }
    }

    void sessionExpired(int index) {
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            factory.sessionExpiredExit(index, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean login() {
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            if (factory.isConnected()) {
                return true;
            }
            if (this.login == null) {
                Image img = IconManager.getOMEImageIcon();
                Object version = this.container.getRegistry().lookup("Version");
                String v = "";
                if (version != null && version instanceof String) {
                    v = (String)version;
                }
                OMEROInfo info = (OMEROInfo)this.container.getRegistry().lookup("/services/OMERODS");
                String f = this.container.getConfigFileRelative(null);
                String n = (String)this.container.getRegistry().lookup("SplashScreenLogo");
                this.login = new ScreenLoginDialog("Open Microscopy Environment", this.getSplashScreen(Factory.createIcon(n, f)), img, v);
                this.login.setEncryptionConfiguration(info.isEncrypted(), info.isEncryptedConfigurable());
                this.login.setDefaultHostConfiguration(info, info.isHostNameConfigurable());
                this.login.setModal(true);
                this.login.setStatusVisible(false);
                this.login.showConnectionSpeed(true);
                this.login.addPropertyChangeListener(this);
            }
            UIUtilities.centerAndShow(this.login);
            return this.success;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print((Throwable)e);
            this.container.getRegistry().getLogger().debug((Object)this, msg);
            return this.success;
        }
    }

    String getLibFileRelative(String file) {
        if (file == null) {
            return "";
        }
        return this.container.getFileRelative("libs", file);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof ServiceActivationResponse) {
            this.synchConnectionButtons();
        } else if (e instanceof ExitApplication) {
            ExitApplication a = (ExitApplication)e;
            this.doExit(a.isAskQuestion(), a.getContext());
        } else if (e instanceof SwitchUserGroup) {
            this.handleSwitchUserGroup((SwitchUserGroup)e);
        } else if (e instanceof SaveEventResponse) {
            this.handleSaveEventResponse((SaveEventResponse)e);
        } else if (e instanceof LogOff) {
            this.handleLogOff((LogOff)e);
        } else if (e instanceof ViewInPluginEvent) {
            this.handleViewInPluginEvent((ViewInPluginEvent)e);
        } else if (e instanceof RemoveGroupEvent) {
            this.handleRemoveGroupEvent((RemoveGroupEvent)e);
        } else if (e instanceof HeartbeatEvent) {
            this.handleHeartbeatEvent((HeartbeatEvent)e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("openURL".equals(name)) {
            String url = (String)evt.getNewValue();
            if (url != null) {
                this.openURL(url);
            }
        } else if ("aboutApplication".equals(name)) {
            this.softwareAbout();
        } else if ("quitApplication".equals(name)) {
            Registry reg = this.container.getRegistry();
            Object exp = reg.lookup("/current_user/details");
            if (exp == null) {
                this.container.exit();
            }
        } else if ("login".equals(name)) {
            UserCredentials lc = (UserCredentials)evt.getNewValue();
            if (lc != null) {
                this.collectCredentials(lc, this.login);
            }
        } else if ("quit".equals(name)) {
            this.login.close();
            this.success = false;
        } else if ("Done".equals(name)) {
            SecurityContext value = (SecurityContext)evt.getNewValue();
            this.exitApplication(value);
        }
    }
}

