/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.proxy;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.proxy.AbstractProxy;
import org.openmicroscopy.shoola.svc.proxy.ImportReply;
import org.openmicroscopy.shoola.svc.proxy.ImportRequest;
import org.openmicroscopy.shoola.svc.proxy.MessengerFileRequest;
import org.openmicroscopy.shoola.svc.proxy.MessengerReply;
import org.openmicroscopy.shoola.svc.proxy.MessengerRequest;
import org.openmicroscopy.shoola.svc.transport.HttpChannel;
import org.openmicroscopy.shoola.svc.transport.TransportException;

public class CommunicatorProxy
extends AbstractProxy
implements Communicator {
    public CommunicatorProxy(HttpChannel channel) {
        super(channel);
    }

    @Override
    public void submitComment(String invoker, String email, String comment, String extra, String applicationName, String applicationVersion, StringBuilder reply) throws TransportException {
        MessengerRequest out = new MessengerRequest(email, comment, extra, null, applicationName, invoker, applicationVersion, null, null);
        MessengerReply in = new MessengerReply(reply);
        try {
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void submitError(String invoker, String email, String comment, String extra, String error, String applicationName, String applicationVersion, StringBuilder reply) throws TransportException {
        this.submitFilesError(invoker, email, comment, extra, error, applicationName, applicationVersion, null, null, reply);
    }

    @Override
    public void submitFilesError(String invoker, String email, String comment, String extra, String error, String applicationName, String applicationVersion, File mainFile, List<File> associatedFiles, StringBuilder reply) throws TransportException {
        MessengerRequest out = new MessengerRequest(email, comment, extra, error, applicationName, invoker, applicationVersion, mainFile, associatedFiles);
        MessengerReply in = new MessengerReply(reply);
        try {
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void submitFile(String token, File file, String reader, StringBuilder reply) throws TransportException {
        if (token == null) {
            throw new IllegalArgumentException("No token specified.");
        }
        if (file == null) {
            throw new IllegalArgumentException("No file to submit.");
        }
        MessengerReply in = new MessengerReply(reply);
        try {
            MessengerFileRequest out = new MessengerFileRequest(token, file, reader);
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }

    @Override
    public void enqueueImport(String json, StringBuilder reply) throws TransportException {
        ImportRequest out = new ImportRequest(json);
        ImportReply in = new ImportReply();
        try {
            this.channel.exchange(out, in);
        }
        catch (IOException ioe) {
            throw new TransportException("Couldn't communicate with server (I/O error).", ioe);
        }
    }
}

