/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ActivateAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.CancelAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.CloseAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ExitAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ImporterAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.LogOffAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.PersonalManagementAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.RetryImportAction;
import org.openmicroscopy.shoola.agents.fsimporter.actions.SubmitFilesAction;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.MapAnnotationObject;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ObjectToCreate;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImportLocationDetails;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterFactory;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUIElement;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.JComboBoxImageObject;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImporterControl
implements ActionListener,
PropertyChangeListener {
    static final Integer SEND_BUTTON = 0;
    static final Integer CLOSE_BUTTON = 1;
    static final Integer CANCEL_BUTTON = 2;
    static final Integer RETRY_BUTTON = 3;
    static final Integer GROUP_BUTTON = 4;
    static final Integer EXIT = 5;
    static final Integer LOG_OFF = 6;
    private Importer model;
    private ImporterUI view;
    private List<FileImportComponentI> markedFailed;
    private Map<Integer, ImporterAction> actionsMap;

    private void createActions() {
        this.actionsMap = new HashMap<Integer, ImporterAction>();
        this.actionsMap.put(SEND_BUTTON, new SubmitFilesAction(this.model));
        this.actionsMap.put(CLOSE_BUTTON, new CloseAction(this.model));
        this.actionsMap.put(CANCEL_BUTTON, new CancelAction(this.model));
        this.actionsMap.put(RETRY_BUTTON, new RetryImportAction(this.model));
        this.actionsMap.put(GROUP_BUTTON, new PersonalManagementAction(this.model));
        this.actionsMap.put(EXIT, new ExitAction(this.model));
        this.actionsMap.put(LOG_OFF, new LogOffAction(this.model));
    }

    private void createWindowsMenuItems(JMenu menu) {
        menu.removeAll();
        menu.add(new ActivateAction(this.model));
    }

    private void attachListeners() {
        if (UIUtilities.isMacOS() && this.model.isMaster()) {
            try {
                MacOSMenuHandler handler = new MacOSMenuHandler(this.view);
                handler.initialize();
                this.view.addPropertyChangeListener(this);
            }
            catch (Throwable handler) {
                // empty catch block
            }
        }
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImporterControl.this.model.close();
            }
        });
        JMenu menu = ImporterFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImporterControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImporterControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
    }

    ImporterControl(Importer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
    }

    void initialize(ImporterUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.attachListeners();
        ImporterFactory.attachWindowMenuToTaskBar();
    }

    ImporterAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void submitFiles(FileImportComponentI fc) {
        ImportErrorObject object;
        List<Object> list;
        if (fc != null) {
            list = new ArrayList();
            list.add(fc);
        } else {
            list = this.view.getMarkedFiles();
        }
        this.markedFailed = list;
        Iterator<Object> i = list.iterator();
        ArrayList<ImportErrorObject> toSubmit = new ArrayList<ImportErrorObject>();
        while (i.hasNext()) {
            fc = (FileImportComponentI)i.next();
            object = fc.getImportErrorObject();
            if (object == null) continue;
            toSubmit.add(object);
        }
        ExperimenterData exp = ImporterAgent.getUserDetails();
        String email = exp.getEmail();
        if (email == null) {
            email = "";
        }
        if (CollectionUtils.isEmpty(toSubmit)) {
            return;
        }
        Iterator j = toSubmit.iterator();
        boolean plate = false;
        while (j.hasNext()) {
            object = (ImportErrorObject)j.next();
            Boolean b = object.isHCS();
            if (b == null || !b.booleanValue()) continue;
            plate = true;
            break;
        }
        if (plate) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("To submit HCS data, please e-mail us directly at ");
            String address = (String)ImporterAgent.getRegistry().lookup("/services/DEBUGGER/emailAddress");
            buffer.append(address);
            buffer.append("\n");
            buffer.append("Do you still wish to report the error?");
            MessageBox box = new MessageBox(this.view, "Submit Error", buffer.toString());
            if (box.centerMsgBox() == 0) {
                return;
            }
            j = toSubmit.iterator();
            while (j.hasNext()) {
                ((ImportErrorObject)j.next()).resetFile();
            }
        }
        UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
        un.notifyError("Import Failures", "Files that failed to import", email, toSubmit, this);
    }

    List<GroupSelectionAction> getUserGroupAction() {
        ArrayList<GroupSelectionAction> l = new ArrayList<GroupSelectionAction>();
        Collection m = ImporterAgent.getAvailableUserGroups();
        if (m == null || m.size() == 0) {
            return l;
        }
        ViewerSorter sorter = new ViewerSorter();
        for (GroupData group : sorter.sort(m)) {
            l.add(new GroupSelectionAction(this.model, group));
        }
        return l;
    }

    boolean isMaster() {
        return this.view.isMaster();
    }

    private void checkDisableCancelAllButtons() {
        ImporterAction cancelAction = this.actionsMap.get(CANCEL_BUTTON);
        if (!cancelAction.isEnabled()) {
            return;
        }
        for (ImporterUIElement importerUIElement : this.view.getImportElements()) {
            if (!importerUIElement.hasImportToCancel()) continue;
            return;
        }
        cancelAction.setEnabled(false);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (EventQueue.isDispatchThread()) {
            this.handlePropertyChangedEvent(evt);
        } else {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ImporterControl.this.handlePropertyChangedEvent(evt);
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    private void handlePropertyChangedEvent(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("startImport".equals(name)) {
            this.view.startImport();
        }
        if ("import".equals(name)) {
            this.actionsMap.get(CANCEL_BUTTON).setEnabled(true);
            this.model.importData((ImportableObject)evt.getNewValue());
        } else if ("loadTags".equals(name)) {
            this.model.loadExistingTags();
        } else if ("cancelSelection".equals(name)) {
            this.model.close();
        } else if ("closeTab".equals(name)) {
            this.model.removeImportElement(evt.getNewValue());
        } else if ("submitError".equals(name)) {
            this.submitFiles((FileImportComponent)evt.getNewValue());
        } else if ("refreshLocation".equals(name)) {
            this.model.refreshContainers((ImportLocationDetails)evt.getNewValue());
        } else if ("createObject".equals(name)) {
            ObjectToCreate l = (ObjectToCreate)evt.getNewValue();
            this.model.createDataObject(l);
        } else if ("debugText".equals(name)) {
            this.view.appendDebugText((String)evt.getNewValue());
        } else if ("quitApplication".equals(name)) {
            ImporterAction a = this.getAction(EXIT);
            ActionEvent event = new ActionEvent(this, 1001, "");
            a.actionPerformed(event);
        } else if ("groupChanged".equals(name)) {
            GroupData newGroup = (GroupData)evt.getNewValue();
            this.model.setUserGroup(newGroup);
        } else if ("fileImportStarted".equals(name) || "cancelImport".equals(name)) {
            this.checkDisableCancelAllButtons();
        } else if ("importDone".equals(name)) {
            this.model.onImportComplete((FileImportComponentI)evt.getNewValue());
            this.view.deleteMapAnnotations();
        } else if ("uploadDone".equals(name)) {
            this.model.onUploadComplete((FileImportComponentI)evt.getNewValue());
        } else if ("refreshMetaList".equals(name)) {
            this.view.refreshMetaFileView((List)evt.getNewValue());
        } else if (!"addAndRefreshMetaList".equals(name)) {
            if ("showMetaDataEditor".equals(name)) {
                this.view.showMetaDataDialog();
            } else if ("addMapAnnotation".equals(name)) {
                this.view.setMapAnnotation((MapAnnotationObject)evt.getNewValue());
            } else if ("refreshDialogTitle".equals(name)) {
                this.view.setNewTitle((String)evt.getNewValue());
            }
        }
    }

    void retryUpload(FileImportComponent fc) {
        this.model.retryUpload(fc);
    }

    void cancel(FileImportComponentI fc) {
        this.model.onUploadComplete(fc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBoxImageObject o;
        JComboBox box;
        Object ho;
        int index = Integer.parseInt(e.getActionCommand());
        if (index == GROUP_BUTTON && (ho = (box = (JComboBox)e.getSource()).getSelectedItem()) instanceof JComboBoxImageObject && (o = (JComboBoxImageObject)ho).getData() instanceof GroupData) {
            this.model.setUserGroup((GroupData)o.getData());
        }
    }
}

