/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.model.XMLAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.GeneralPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.GroupProfile;
import org.openmicroscopy.shoola.agents.metadata.editor.ToolBar;
import org.openmicroscopy.shoola.agents.metadata.editor.UserUI;
import org.openmicroscopy.shoola.agents.metadata.util.AnalysisResultsItem;
import org.openmicroscopy.shoola.agents.metadata.util.DataToSave;
import org.openmicroscopy.shoola.agents.util.ui.PermissionMenu;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.util.ui.DummyPanel;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class EditorUI
extends JPanel {
    static final int TO_ADD = 0;
    static final int TO_REMOVE = 1;
    static final int TO_DELETE = 2;
    static final int GENERAL_INDEX = 0;
    static final int ACQUISITION_INDEX = 1;
    static final int RND_INDEX = 2;
    private static final String RENDERER_NAME = "Preview";
    private static final String RENDERER_DESCRIPTION = "Preview the image";
    private static final String RENDERER_NAME_SPECIFIC = "Settings";
    private static final String RENDERER_DESCRIPTION_SPECIFIC = "Adjust the rendering settings";
    private static final String BIG_IMAGE_TEXT = "Only available for non big images";
    private static final String NO_PREVIEW_TEXT = "No preview available";
    private static final String LOADING_TEXT = "Loading...";
    private EditorControl controller;
    private EditorModel model;
    private GeneralPaneUI generalPane;
    private AcquisitionDataUI acquisitionPane;
    private UserUI userUI;
    private GroupProfile groupUI;
    private ToolBar toolBar;
    private JTabbedPane tabPane;
    private JComponent userTabbedPane;
    private JComponent groupTabbedPane;
    private JComponent component;
    private JPanel defaultPane;
    private DummyPanel dummyPanel;
    private PermissionMenu tagMenu;
    private PermissionMenu docMenu;
    private PermissionMenu otherAnnotationMenu;

    private void populateTabbedPane(boolean init) {
        this.addTab("General", this.generalPane, "General Information.");
        this.addTab("Acquisition", this.acquisitionPane, "Acquisition Metadata.");
        if (init) {
            if (this.model.getRndIndex() == 1) {
                this.addTab(RENDERER_NAME_SPECIFIC, this.dummyPanel, RENDERER_DESCRIPTION_SPECIFIC);
            } else {
                this.addTab(RENDERER_NAME, this.dummyPanel, RENDERER_DESCRIPTION);
            }
        }
    }

    private void addTab(String title, Component comp, String desc) {
        JScrollPane sp = new JScrollPane(comp);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        this.tabPane.addTab(title, null, sp, desc);
    }

    private void initComponents() {
        this.dummyPanel = new DummyPanel();
        this.groupUI = new GroupProfile(this.model, this);
        this.groupUI.addPropertyChangeListener(this.controller);
        this.userUI = new UserUI(this.model, this.controller, this);
        this.toolBar = new ToolBar(this.model, this.controller);
        this.generalPane = new GeneralPaneUI(this, this.model, this.controller, this.toolBar);
        this.acquisitionPane = new AcquisitionDataUI(this, this.model, this.controller);
        this.tabPane = new JTabbedPane();
        this.tabPane.addChangeListener(this.controller);
        this.tabPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.populateTabbedPane(true);
        this.tabPane.setEnabledAt(1, false);
        this.defaultPane = new JPanel();
        this.defaultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.component = this.defaultPane;
        this.userTabbedPane = new JScrollPane(this.userUI);
        this.groupTabbedPane = new JScrollPane(this.groupUI);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.component, "Center");
    }

    EditorUI() {
    }

    void initialize(EditorModel model, EditorControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void layoutUI() {
        Object uo = this.model.getRefObject();
        this.remove(this.component);
        if (uo instanceof ExperimenterData) {
            this.toolBar.buildUI();
            this.userUI.buildUI();
            this.userUI.repaint();
            this.component = this.userTabbedPane;
        } else if (uo instanceof GroupData) {
            this.toolBar.buildUI();
            this.groupUI.buildUI();
            this.groupUI.repaint();
            this.component = this.groupTabbedPane;
        } else if (!(uo instanceof DataObject)) {
            this.toolBar.buildUI();
            this.component = this.defaultPane;
        } else {
            this.toolBar.buildUI();
            this.generalPane.layoutUI();
            this.acquisitionPane.layoutCompanionFiles();
            this.component = this.tabPane;
            if (this.model.isMultiSelection()) {
                this.tabPane.setSelectedIndex(0);
                this.tabPane.setEnabledAt(1, false);
                this.tabPane.setEnabledAt(2, false);
            }
        }
        this.add((Component)this.component, "Center");
        this.validate();
        this.repaint();
    }

    void setParentRootObject() {
        this.generalPane.setParentRootObject();
        this.userUI.setParentRootObject();
    }

    void handleImageSelection() {
        ImageData img = this.model.getImage();
        if (img == null) {
            return;
        }
        boolean multi = this.model.isMultiSelection();
        boolean preview = this.model.isPreviewAvailable();
        this.tabPane.setEnabledAt(2, preview && !multi);
        this.tabPane.setEnabledAt(1, !multi && img.getId() > 0L);
        if (!preview) {
            if (this.model.isLargeImage()) {
                this.dummyPanel.setText(BIG_IMAGE_TEXT);
                this.tabPane.setToolTipTextAt(2, BIG_IMAGE_TEXT);
            } else {
                this.dummyPanel.setText(NO_PREVIEW_TEXT);
                this.tabPane.setToolTipTextAt(2, NO_PREVIEW_TEXT);
            }
        }
        if (this.getSelectedTab() == 2) {
            this.tabPane.setComponentAt(2, this.dummyPanel);
            if (!preview && this.model.getRndIndex() != 1) {
                this.tabPane.setSelectedIndex(0);
            }
        }
    }

    void setRootObject(Object oldObject) {
        Object uo = this.model.getRefObject();
        this.dummyPanel.setText(LOADING_TEXT, true);
        this.tabPane.setComponentAt(2, this.dummyPanel);
        this.toolBar.buildUI();
        this.tabPane.setToolTipTextAt(2, RENDERER_DESCRIPTION);
        if (!(uo instanceof DataObject)) {
            this.toolBar.setStatus(false);
            this.toolBar.buildUI();
            this.remove(this.component);
            this.component = this.defaultPane;
            this.add((Component)this.component, "Center");
            this.revalidate();
            this.repaint();
        } else if (uo instanceof ExperimenterData) {
            this.userUI.clearData(oldObject);
            this.toolBar.setStatus(false);
            this.layoutUI();
        } else if (uo instanceof GroupData) {
            this.groupUI.clearData(oldObject);
            this.toolBar.setStatus(false);
            this.layoutUI();
        } else {
            boolean load = false;
            if (this.model.isMultiSelection()) {
                this.tabPane.setSelectedIndex(0);
                this.tabPane.setEnabledAt(1, false);
                this.tabPane.setEnabledAt(2, false);
            } else {
                if (uo instanceof ImageData || uo instanceof WellSampleData) {
                    this.handleImageSelection();
                } else {
                    this.dummyPanel.setText(NO_PREVIEW_TEXT);
                    this.tabPane.setToolTipTextAt(2, NO_PREVIEW_TEXT);
                    if (!(uo instanceof WellData)) {
                        this.tabPane.setSelectedIndex(0);
                    }
                    this.tabPane.setEnabledAt(1, false);
                    this.tabPane.setEnabledAt(2, false);
                }
                load = true;
            }
            this.generalPane.setRootObject(oldObject);
            this.acquisitionPane.setRootObject(load);
        }
    }

    void saveData(boolean async) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.model.getRefObject() instanceof ExperimenterData) {
            Object exp = this.userUI.getExperimenterToSave();
            this.model.fireAdminSaving(exp, async);
            return;
        }
        if (this.model.getRefObject() instanceof GroupData) {
            AdminObject o = this.groupUI.getAdminObject();
            if (o == null) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.model.fireAdminSaving(o, async);
            return;
        }
        DataToSave object = this.generalPane.prepareDataToSave();
        List<Object> metadata = null;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData) {
            metadata = this.acquisitionPane.prepareDataToSave();
        }
        this.model.fireAnnotationSaving(object, metadata, async);
        this.toolBar.setStatus(true);
    }

    void showChannelData() {
        this.generalPane.setChannelData();
        this.acquisitionPane.setChannelData();
    }

    boolean hasDataToSave() {
        Object ref = this.model.getRefObject();
        if (!(ref instanceof DataObject)) {
            return false;
        }
        if (ref instanceof ExperimenterData) {
            return this.userUI.hasDataToSave();
        }
        if (ref instanceof GroupData) {
            return this.groupUI.hasDataToSave();
        }
        boolean b = this.generalPane.hasDataToSave();
        if (b) {
            return b;
        }
        return this.acquisitionPane.hasDataToSave();
    }

    void clearData() {
        this.userUI.clearData(null);
        this.groupUI.clearData(null);
        this.generalPane.clearData(null);
        this.dummyPanel.setText("");
        this.tabPane.setComponentAt(2, this.dummyPanel);
        this.tabPane.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void passwordChanged() {
        this.userUI.passwordChanged();
    }

    void setDiskSpace(DiskQuota quota) {
        this.userUI.setDiskSpace(quota);
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        this.generalPane.handleTaskPaneCollapsed(source);
    }

    void setStatus(boolean busy) {
        this.toolBar.setStatus(busy);
    }

    Collection getExistingTags() {
        return this.model.getExistingTags();
    }

    void attachFiles(File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        this.generalPane.attachFiles(files);
        this.saveData(true);
    }

    void removeObject(DataObject data) {
        if (data == null) {
            return;
        }
        if (data instanceof TagAnnotationData || data instanceof TextualAnnotationData || data instanceof TermAnnotationData || data instanceof XMLAnnotationData || data instanceof DoubleAnnotationData || data instanceof LongAnnotationData || data instanceof BooleanAnnotationData) {
            this.generalPane.removeAnnotation((AnnotationData)data);
            if (data.getId() >= 0L) {
                this.saveData(true);
            }
        }
    }

    private void removeLinks(int level, Collection l) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Iterator i = l.iterator();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        while (i.hasNext()) {
            AnnotationData o = (AnnotationData)i.next();
            List<Object> links = this.model.getLinks(level, o);
            if (links == null) continue;
            toRemove.addAll(links);
        }
        DataToSave object = new DataToSave(new ArrayList<AnnotationData>(), toRemove);
        this.model.fireAnnotationSaving(object, null, true);
    }

    void removeTags(JComponent src, Point location) {
        List<TagAnnotationData> list;
        if (!this.generalPane.hasTagsToUnlink()) {
            return;
        }
        if (this.model.isGroupLeader() || this.model.isAdministrator()) {
            if (this.tagMenu == null) {
                this.tagMenu = new PermissionMenu("Remove", "Tags");
                this.tagMenu.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String n = evt.getPropertyName();
                        if (PermissionMenu.SELECTED_LEVEL_PROPERTY.equals(n)) {
                            EditorUI.this.removeLinks((Integer)evt.getNewValue(), EditorUI.this.model.getAllTags());
                        }
                    }
                });
            }
            this.tagMenu.show(src, location.x, location.y);
            return;
        }
        SwingUtilities.convertPointToScreen(location, src);
        MessageBox box = new MessageBox(this.model.getRefFrame(), "Remove All Your Tags", "Are you sure you want to remove all your Tags?");
        Dimension d = box.getPreferredSize();
        Point p = new Point(location.x - d.width / 2, location.y);
        if (box.showMsgBox(p) == 1 && (list = this.generalPane.removeTags()).size() > 0) {
            this.saveData(true);
        }
    }

    void removeOtherAnnotations(JComponent src, Point location) {
        List<AnnotationData> list;
        if (!this.generalPane.hasOtherAnnotationsToUnlink()) {
            return;
        }
        if (this.model.isGroupLeader() || this.model.isAdministrator()) {
            if (this.otherAnnotationMenu == null) {
                this.otherAnnotationMenu = new PermissionMenu("Remove", "Other annotations");
                this.otherAnnotationMenu.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String n = evt.getPropertyName();
                        if (PermissionMenu.SELECTED_LEVEL_PROPERTY.equals(n)) {
                            EditorUI.this.removeLinks((Integer)evt.getNewValue(), EditorUI.this.model.getAllOtherAnnotations());
                        }
                    }
                });
            }
            this.otherAnnotationMenu.show(src, location.x, location.y);
            return;
        }
        SwingUtilities.convertPointToScreen(location, src);
        MessageBox box = new MessageBox(this.model.getRefFrame(), "Remove All Your Other Annotations", "Are you sure you want to remove all your other annotations?");
        Dimension d = box.getPreferredSize();
        Point p = new Point(location.x - d.width / 2, location.y);
        if (box.showMsgBox(p) == 1 && (list = this.generalPane.removeOtherAnnotations()).size() > 0) {
            this.saveData(true);
        }
    }

    void handleObjectsSelection(Class<?> type, Collection objects) {
        Collection<FileAnnotationData> l;
        if (objects == null) {
            return;
        }
        ArrayList<AnnotationData> selection = new ArrayList<AnnotationData>();
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            selection.addAll(objects);
        }
        if (TagAnnotationData.class.equals(type)) {
            Collection<TagAnnotationData> l2 = this.model.getCommonTags();
            if (CollectionUtils.isNotEmpty(l2)) {
                for (AnnotationData annotationData : l2) {
                    if (this.model.isAnnotationUsedByUser(annotationData)) continue;
                    selection.add(annotationData);
                }
            }
        } else if (FileAnnotationData.class.equals(type) && CollectionUtils.isNotEmpty(l = this.model.getCommonAttachments())) {
            for (AnnotationData annotationData : l) {
                if (this.model.isAnnotationUsedByUser(annotationData)) continue;
                selection.add(annotationData);
            }
        }
        this.generalPane.handleObjectsSelection(type, selection);
        this.saveData(true);
    }

    void unlinkAttachedFile(Object file) {
        FileAnnotationData fa;
        if (file == null) {
            return;
        }
        this.generalPane.removeAttachedFile(file);
        if (file instanceof FileAnnotationData && (fa = (FileAnnotationData)file).getId() >= 0L) {
            this.saveData(true);
        }
    }

    void removeAttachedFiles(Component src, Point location) {
        List<FileAnnotationData> list;
        if (!this.generalPane.hasAttachmentsToUnlink()) {
            return;
        }
        if (this.model.isAdministrator() || this.model.isGroupLeader()) {
            if (this.docMenu == null) {
                this.docMenu = new PermissionMenu("Remove", "Files");
                this.docMenu.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        String n = evt.getPropertyName();
                        if (PermissionMenu.SELECTED_LEVEL_PROPERTY.equals(n)) {
                            List<FileAnnotationData> toRemove = EditorUI.this.model.getFileAnnotatationsByLevel((Integer)evt.getNewValue());
                            EditorUI.this.model.fireFileAnnotationRemoveCheck(toRemove);
                        }
                    }
                });
            }
            this.docMenu.show(src, location.x, location.y);
            return;
        }
        SwingUtilities.convertPointToScreen(location, src);
        MessageBox box = new MessageBox(this.model.getRefFrame(), "Remove all files", "Are you sure you want to remove all files?");
        Dimension d = box.getPreferredSize();
        Point p = new Point(location.x - d.width / 2, location.y);
        if (box.showMsgBox(p) == 1 && (list = this.generalPane.removeAttachedFiles()).size() > 0) {
            this.model.fireFileAnnotationRemoveCheck(list);
        }
    }

    void deleteAnnotation(AnnotationData annotation) {
        this.model.deleteAnnotation(annotation);
    }

    void fireAnnotationsDeletion(List<FileAnnotationData> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        l.addAll(annotations);
        this.model.fireAnnotationsDeletion(l);
    }

    void setImageAcquisitionData() {
        this.acquisitionPane.setImageAcquisitionData();
    }

    void setChannelAcquisitionData(int index) {
        this.acquisitionPane.setChannelAcquisitionData(index);
    }

    void setPlaneInfo(int index) {
        this.acquisitionPane.setPlaneInfo(index);
    }

    boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    void makeMovie(int scaleBar, Color overlayColor) {
        this.model.makeMovie(scaleBar, overlayColor);
    }

    void setRenderer() {
        this.tabPane.removeAll();
        this.populateTabbedPane(false);
        if (this.model.getRndIndex() == 1) {
            this.addTab(RENDERER_NAME_SPECIFIC, this.model.getRenderer().getUI(), RENDERER_DESCRIPTION_SPECIFIC);
        } else {
            this.addTab(RENDERER_NAME, this.model.getRenderer().getUI(), RENDERER_DESCRIPTION);
        }
        this.setSelectedTab(2);
        this.model.getRenderer().renderPreview();
    }

    int getRndIndex() {
        return this.model.getRndIndex();
    }

    void setSelectedTab(int index) {
        this.tabPane.removeChangeListener(this.controller);
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.tabPane.setSelectedIndex(index);
            }
        }
        this.tabPane.addChangeListener(this.controller);
    }

    void setInstrumentData() {
        this.acquisitionPane.setInstrumentData();
    }

    int getSelectedTab() {
        return this.tabPane.getSelectedIndex();
    }

    void onChannelColorChanged(int index) {
        this.acquisitionPane.onChannelColorChanged(index);
    }

    String getRefObjectName() {
        return this.model.getRefObjectName();
    }

    Object getRefObject() {
        return this.model.getRefObject();
    }

    void onSettingsApplied(boolean cleanup) {
        if (cleanup) {
            this.dummyPanel.setText("");
            this.tabPane.setComponentAt(2, this.dummyPanel);
        } else {
            this.tabPane.setComponentAt(2, this.model.getRenderer().getUI());
        }
    }

    void activityOptions(Component source, Point p, int index) {
        this.toolBar.launchOptions(source, p, index);
    }

    void createFigure(Object value) {
        this.model.createFigure(value);
    }

    void manageScript(ScriptObject script, int index) {
        this.model.manageScript(script, index);
    }

    void discardRenderer(Object ref) {
        if (ref != this.model.getRefObject()) {
            return;
        }
        this.model.discardRenderer();
        this.clearData();
    }

    void refreshAcquisition() {
    }

    void setScripts() {
        this.toolBar.setScripts();
    }

    void setUserPhoto(BufferedImage photo) {
        if (this.userUI != null) {
            this.userUI.setUserPhoto(photo);
        }
    }

    void uploadScript() {
        this.model.uploadScript();
    }

    void reloadScript() {
        this.model.setScripts(null);
        this.model.loadScripts();
        this.toolBar.setStatus(true);
    }

    boolean isNumerousChannel() {
        return this.model.isNumerousChannel();
    }

    void cancelAnalysisResultsLoading(AnalysisResultsItem item) {
    }

    boolean checkIfTabEnabled(int index) {
        if (index == -1) {
            return false;
        }
        if (this.tabPane.isEnabledAt(index)) {
            return true;
        }
        this.tabPane.setSelectedIndex(0);
        return false;
    }

    void onRelatedNodesSet() {
        this.generalPane.onRelatedNodesSet();
    }

    void onSizeLoaded() {
        this.toolBar.onSizeLoaded();
    }

    void displayFileset() {
        this.toolBar.displayFileset();
    }

    void displayLocation() {
        this.toolBar.displayLocation();
    }

    Collection<FilesetData> getFileset() {
        return this.model.getFileset();
    }

    ImageData getImage() {
        return this.model.getImage();
    }

    List<DataObject> getSelectedObjects() {
        return this.model.getSelectedObjects();
    }

    FileAnnotationData getOriginalMetadata() {
        return this.model.getOriginalMetadata();
    }

    void setLDAPDetails(String result) {
        this.userUI.setLDAPDetails(result);
    }

    public Collection<FileAnnotationData> getSelectedFileAnnotations() {
        return this.generalPane.getSelectedFileAnnotations();
    }

    public void reloadROICount() {
        if (this.model.getRefObject() instanceof ImageData) {
            this.generalPane.getPropertiesUI().loadROICount((ImageData)this.model.getRefObject());
        }
    }
}

