/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon IMAGE_ICON;
    private static final Icon DATASET_ICON;
    private static final Icon PROJECT_ICON;
    private static final Icon SCREEN_ICON;
    private static final Icon PLATE_ICON;
    private static final Icon TAG_ICON;
    private static final Icon TAG_SET_ICON;
    private long currentUserID;
    private Font defaultFont;

    private void setIcon(Object usrObject) {
        Icon icon = null;
        if (usrObject instanceof ProjectData) {
            icon = PROJECT_ICON;
        } else if (usrObject instanceof DatasetData) {
            icon = DATASET_ICON;
        } else if (usrObject instanceof ImageData) {
            icon = IMAGE_ICON;
        } else if (usrObject instanceof ScreenData) {
            icon = SCREEN_ICON;
        } else if (usrObject instanceof PlateData) {
            icon = PLATE_ICON;
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            icon = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? TAG_SET_ICON : TAG_ICON;
        } else if (usrObject instanceof String) {
            icon = null;
        }
        this.setIcon(icon);
    }

    public TreeCellRenderer() {
        ExperimenterData exp = (ExperimenterData)MetadataViewerAgent.getRegistry().lookup("/current_user/details");
        this.currentUserID = exp.getId();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!(value instanceof TreeBrowserDisplay)) {
            return this;
        }
        if (this.defaultFont == null) {
            this.defaultFont = this.getFont();
        }
        TreeBrowserDisplay node = (TreeBrowserDisplay)value;
        Object object = node.getUserObject();
        Icon icon = node.getDefaultIcon();
        if (object instanceof String) {
            this.setIcon(null);
        }
        this.setFont(this.defaultFont);
        if (icon != null) {
            this.setIcon(icon);
            if (object instanceof String) {
                this.setFont(this.defaultFont.deriveFont(2, 10.0f));
            }
        } else {
            this.setIcon(object);
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        IMAGE_ICON = icons.getIcon(7);
        DATASET_ICON = icons.getIcon(9);
        PROJECT_ICON = icons.getIcon(8);
        SCREEN_ICON = icons.getIcon(47);
        PLATE_ICON = icons.getIcon(48);
        TAG_ICON = icons.getIcon(3);
        TAG_SET_ICON = icons.getIcon(58);
    }
}

