/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.model.ImageData;
import omero.gateway.model.TableResult;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class WellImageSet
extends ImageSet {
    private String rowDisplay;
    private String columnDisplay;
    private ImageNode selectedWellSample;
    private List<WellSampleNode> samples;
    private String description;
    private Map<String[], Object[]> tabularData;
    private List<String> text;
    private int indentRow;
    private int indentColumn;

    private void setDefault() {
        if (this.rowDisplay == null) {
            this.setRowDisplay("" + this.getRow());
        }
        if (this.columnDisplay == null) {
            this.setColumnDisplay("" + this.getColumn());
        }
    }

    private void formatDisplay() {
        int size = this.tabularData.size() - 1;
        int index = 0;
        Iterator<Map.Entry<String[], Object[]>> i = this.tabularData.entrySet().iterator();
        this.text = new ArrayList<String>();
        while (i.hasNext()) {
            Map.Entry<String[], Object[]> entry = i.next();
            String[] headers = entry.getKey();
            Object[] values = entry.getValue();
            for (int j = 0; j < headers.length; ++j) {
                this.text.add(" " + headers[j] + ":" + values[j]);
            }
            if (index < size) {
                this.text.add("--------------");
            }
            ++index;
        }
        String txt = UIUtilities.formatToolTipText(this.text);
        for (WellSampleNode n : this.samples) {
            n.setToolTipText(txt);
            n.setCanvasToolTip(txt);
        }
    }

    private void setWellColor() {
        WellData well = (WellData)this.getHierarchyObject();
        int r = well.getRed();
        int g = well.getGreen();
        int b = well.getBlue();
        int a = well.getAlpha();
        if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255 && a >= 0 && a <= 255) {
            super.setHighlight(new Color(r, g, b, a));
        }
    }

    public WellImageSet(WellData well) {
        super("", well);
        if (well == null) {
            throw new IllegalArgumentException("Well cannot be null.");
        }
        this.description = well.getWellType();
        this.setWellColor();
        this.samples = new ArrayList<WellSampleNode>();
        this.setDefault();
        this.rowDisplay = null;
        this.columnDisplay = null;
        this.indentRow = 0;
        this.indentColumn = 0;
    }

    public void setIndentRow(int indentRow) {
        this.indentRow = indentRow;
    }

    public void setIndentColumn(int indentColumn) {
        this.indentColumn = indentColumn;
    }

    public int getIndentRow() {
        return this.indentRow;
    }

    public int getIndentColumn() {
        return this.indentColumn;
    }

    public String getWellLocation() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.rowDisplay + "-" + this.columnDisplay);
        return buf.toString();
    }

    public void addWellSample(WellSampleNode node) {
        if (node != null) {
            this.samples.add(node);
        }
        this.setSelectedWellSample(0);
    }

    public void setSelectedWellSample(int index) {
        for (WellSampleNode node : this.samples) {
            if (node.getIndex() != index) continue;
            this.selectedWellSample = node;
        }
    }

    public ImageNode getSelectedWellSample() {
        return this.selectedWellSample;
    }

    public List<WellSampleNode> getWellSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public void formatWellSampleTitle() {
        if (this.samples == null || this.samples.size() == 0) {
            return;
        }
        for (WellSampleNode wsn : this.samples) {
            wsn.setTitle(this.getCellLabel());
            wsn.setTitleBarType(5);
        }
    }

    public ImageData getSelectedImage() {
        if (this.selectedWellSample == null) {
            return null;
        }
        WellSampleData wsd = (WellSampleData)this.selectedWellSample.getHierarchyObject();
        if (wsd == null) {
            return null;
        }
        return wsd.getImage();
    }

    public int getNumberOfSamples() {
        return this.samples.size();
    }

    public int getRow() {
        if (this.getHierarchyObject() == null) {
            return -1;
        }
        Integer i = ((WellData)this.getHierarchyObject()).getRow();
        if (i == null) {
            return -1;
        }
        return i;
    }

    public int getColumn() {
        if (this.getHierarchyObject() == null) {
            return -1;
        }
        Integer i = ((WellData)this.getHierarchyObject()).getColumn();
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setRowDisplay(String rowDisplay) {
        this.rowDisplay = rowDisplay;
        this.setDefault();
    }

    public void setColumnDisplay(String columnDisplay) {
        this.columnDisplay = columnDisplay;
        this.setDefault();
    }

    public void setCellDisplay(String columnDisplay, String rowDisplay) {
        this.rowDisplay = rowDisplay;
        this.columnDisplay = columnDisplay;
        this.setDefault();
    }

    public String getCellLabel() {
        return this.rowDisplay + " " + this.columnDisplay;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setDefault();
    }

    public void setTabularData(List<TableResult> tables) {
        Iterator<TableResult> i = tables.iterator();
        long wellID = ((WellData)this.getHierarchyObject()).getId();
        this.tabularData = new HashMap<String[], Object[]>();
        while (i.hasNext()) {
            TableResult table = i.next();
            int index = table.getColumnIndex(TableResult.WELL_COLUMN_INDEX);
            if (index < 0) continue;
            Object[][] data = table.getData();
            String[] headers = table.getHeaders();
            Object[] values = new Object[headers.length];
            for (int j = 0; j < data.length; ++j) {
                long id = (Long)data[j][index];
                if (id != wellID) continue;
                for (int k = 0; k < values.length; ++k) {
                    values[k] = data[j][k];
                }
            }
            this.tabularData.put(headers, values);
        }
        this.formatDisplay();
    }

    public List<String> getText() {
        return this.text;
    }

    public boolean isSampleValid() {
        ImageData img = this.getSelectedImage();
        if (img == null) {
            return false;
        }
        return img.getId() >= 0L;
    }

    @Override
    public void setHighlight(Color highlight) {
        super.setHighlight(highlight);
        Iterator<WellSampleNode> i = this.samples.iterator();
        while (i.hasNext()) {
            i.next().setHighlight(highlight);
        }
    }

    @Override
    public String getTitle() {
        if (this.selectedWellSample == null) {
            return "";
        }
        return this.selectedWellSample.getTitle();
    }
}

