/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserStatusBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserToolBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserWellToolBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.PlateGridUI;
import org.openmicroscopy.shoola.agents.dataBrowser.view.PopupMenu;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SlideShowView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellFieldsView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.MagnificationVisitor;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.ScrollablePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;

class DataBrowserUI
extends ScrollablePanel {
    static final int THUMB_VIEW = 0;
    static final int COLUMNS_VIEW = 1;
    static final int SEARCH_VIEW = 3;
    static final int SORT_BY_NAME = 2;
    static final int SORT_BY_DATE = 3;
    private DataBrowserToolBar toolBar;
    private DataBrowserWellToolBar wellToolBar;
    private DataBrowserStatusBar statusBar;
    private PlateGridUI plateGridUI;
    private DataBrowserModel model;
    private DataBrowserControl controller;
    private SlideShowView slideShowView;
    private int selectedView;
    private PopupMenu popupMenu;
    private WellFieldsView fieldsView;
    private double factor;
    private GridBagConstraints c;

    DataBrowserUI() {
        super(true);
    }

    void initialize(DataBrowserModel model, DataBrowserControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.wellToolBar = new DataBrowserWellToolBar(this, controller);
        this.toolBar = new DataBrowserToolBar(model, this, controller);
        if (model.getType() == 5) {
            this.plateGridUI = new PlateGridUI((WellsModel)model, controller);
        }
        this.statusBar = new DataBrowserStatusBar(this);
        this.selectedView = model.getType() == 3 ? 3 : 0;
        this.factor = DataBrowserFactory.getThumbnailScaleFactor();
        this.setNumberOfImages(-1);
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.buildGUI(true);
    }

    boolean wells() {
        return this.model.getType() == 5;
    }

    void buildGUI(boolean full) {
        this.removeAll();
        if (full) {
            if (this.model.getType() == 5) {
                this.add((Component)this.wellToolBar, this.c);
                ++this.c.gridy;
            } else {
                this.add((Component)this.toolBar, this.c);
                ++this.c.gridy;
            }
            this.c.fill = 1;
            this.c.weighty = 1.0;
            this.add((Component)this.statusBar, this.c);
            ++this.c.gridy;
            this.statusBar.setVisible(this.model.getType() != 3);
        }
        this.c.fill = 1;
        this.c.weighty = 1.0;
        this.add((Component)this.model.getBrowser().getUI(), this.c);
        ++this.c.gridy;
    }

    PlateGridUI getGridUI() {
        return this.plateGridUI;
    }

    SearchObject getSelectedFilter() {
        return this.toolBar.getSelectedFilter();
    }

    Collection getExistingTags() {
        return this.model.getExistingTags();
    }

    void setTags(Collection tags) {
        this.toolBar.setTags(tags);
    }

    void slideShowView(boolean create) {
        List<ImageNode> nodes;
        this.toolBar.enableSlideShow(!create);
        if (!create) {
            if (this.slideShowView != null) {
                this.model.cancelSlideShow();
                this.slideShowView.close();
            }
            return;
        }
        Browser browser = this.model.getBrowser();
        Collection<ImageDisplay> selected = browser.getSelectedDisplays();
        if (selected != null && selected.size() > 0) {
            nodes = new ArrayList<ImageNode>();
            for (ImageDisplay n : selected) {
                if (!(n instanceof ImageNode)) continue;
                nodes.add((ImageNode)n);
            }
        } else {
            nodes = browser.getVisibleImageNodes();
        }
        if (nodes == null || nodes.size() == 0) {
            this.toolBar.enableSlideShow(true);
            return;
        }
        ArrayList<ImageNode> selection = new ArrayList<ImageNode>(nodes.size());
        for (ImageNode n : nodes) {
            selection.add(n.copy());
        }
        Registry reg = DataBrowserAgent.getRegistry();
        this.slideShowView = new SlideShowView(reg.getTaskBar().getFrame(), selection);
        this.slideShowView.addPropertyChangeListener(this.controller);
        this.model.fireFullSizeLoading(selection);
        UIUtilities.centerAndShow(this.slideShowView);
        if (this.model.getState() != 6) {
            this.setSlideViewStatus(true, -1);
        }
    }

    void setSlideViewStatus(boolean hideProgressBar, int progressPerc) {
        if (this.slideShowView != null) {
            this.slideShowView.setProgress(hideProgressBar, progressPerc);
        }
    }

    boolean isRollOver() {
        return this.model.isRollOver();
    }

    void layoutUI() {
        switch (this.selectedView) {
            case 0: {
                Browser b = this.model.getBrowser();
                this.model.layoutBrowser();
                b.getUI().repaint();
                break;
            }
            case 1: {
                ImageTableView v = this.model.getTableView();
                if (v == null) break;
                v.refreshTable();
                break;
            }
            case 3: {
                SearchResultView sv = this.model.getSearchView();
                if (sv == null) break;
                sv.refreshTable();
            }
        }
    }

    void setSelectedView(int index) {
        this.selectedView = index;
        this.removeAll();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        double f = DataBrowserFactory.getThumbnailScaleFactor();
        switch (index) {
            case 0: {
                if (this.model.getType() == 5) {
                    this.add((Component)this.wellToolBar, this.c);
                    ++this.c.gridy;
                    this.wellToolBar.displayFieldsOptions(true);
                    this.c.fill = 1;
                    this.c.weighty = 1.0;
                    JSplitPane split = new JSplitPane(0);
                    split.setTopComponent(this.model.getBrowser().getUI());
                    this.fieldsView = new WellFieldsView((WellsModel)this.model, this.controller, 2.5);
                    this.fieldsView.setMagnificationFactor(this.factor);
                    split.setBottomComponent(this.fieldsView);
                    split.setResizeWeight(0.66);
                    this.add((Component)split, this.c);
                    ++this.c.gridy;
                } else {
                    this.add((Component)this.toolBar, this.c);
                    ++this.c.gridy;
                    this.layoutUI();
                    this.c.fill = 1;
                    this.c.weighty = 1.0;
                    this.add((Component)this.model.getBrowser().getUI(), this.c);
                    ++this.c.gridy;
                }
                f = this.factor;
                break;
            }
            case 1: {
                Collection<ImageDisplay> nodes;
                this.selectedView = index;
                this.add((Component)this.toolBar, this.c);
                ++this.c.gridy;
                ImageTableView existed = this.model.getTableView();
                ImageTableView v = this.model.createImageTableView();
                if (existed != null && v != null) {
                    v.refreshTable();
                }
                if ((nodes = this.model.getBrowser().getSelectedDisplays()) != null) {
                    Iterator<ImageDisplay> i = nodes.iterator();
                    ArrayList<DataObject> objects = new ArrayList<DataObject>();
                    while (i.hasNext()) {
                        ImageDisplay display = i.next();
                        Object ho = display.getHierarchyObject();
                        if (!(ho instanceof DataObject)) continue;
                        objects.add((DataObject)ho);
                    }
                    v.setSelectedNodes(objects);
                }
                if (existed == null) {
                    v.addPropertyChangeListener(this.controller);
                }
                v.validate();
                v.repaint();
                this.c.fill = 1;
                this.c.weighty = 1.0;
                this.add((Component)v, this.c);
                ++this.c.gridy;
                break;
            }
            case 3: {
                this.selectedView = index;
                SearchResultView sv = this.model.createSearchResultView();
                sv.addPropertyChangeListener(this.controller);
                this.c.fill = 1;
                this.c.weighty = 1.0;
                this.add((Component)sv, this.c);
                ++this.c.gridy;
                sv.refreshTable();
            }
        }
        this.c.fill = 2;
        this.c.weighty = 0.0;
        this.add((Component)this.statusBar, this.c);
        ++this.c.gridy;
        this.toolBar.setSelectedViewIndex(this.selectedView);
        this.statusBar.setSelectedViewIndex(this.selectedView, f);
        this.revalidate();
        this.repaint();
    }

    int getSelectedView() {
        return this.selectedView;
    }

    void setRollOver(boolean rollOver) {
        this.model.getBrowser().setRollOver(rollOver);
    }

    void setItemsPerRow(int number) {
        Browser browser = this.model.getBrowser();
        Layout layout = browser.getSelectedLayout();
        if (layout != null) {
            layout.setImagesPerRow(number);
            browser.accept(layout, 1);
        }
    }

    void setNumberOfImages(int value) {
        if (value < 0) {
            value = this.model.getNumberOfImages();
        }
        this.toolBar.setNumberOfImages(value, this.model.getNumberOfImages());
    }

    void sortBy(int index) {
        ImageTableView v;
        this.model.getSorter().setByDate(3 == index);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getBrowser();
        Layout layout = browser.getSelectedLayout();
        if (layout != null) {
            browser.accept(layout, 1);
        }
        if ((v = this.model.getTableView()) != null) {
            v.refreshTable();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void setMagnificationFactor(double factor) {
        switch (this.selectedView) {
            case 0: {
                MagnificationVisitor visitor = new MagnificationVisitor(factor);
                Browser browser = this.model.getBrowser();
                browser.accept(visitor, 0);
                browser.accept(browser.getSelectedLayout(), 1);
                break;
            }
            case 1: {
                MagnificationVisitor visitor = new MagnificationVisitor(factor);
                Browser browser = this.model.getBrowser();
                browser.accept(visitor, 0);
                ImageTableView v = this.model.getTableView();
                if (v == null) break;
                v.setMagnification(factor);
                v.refreshTable();
            }
        }
    }

    double getMagnificationFactor() {
        return this.factor;
    }

    void setFieldMagnificationFactor(double factor) {
        this.fieldsView.setMagnificationFactor(factor);
    }

    void showPopup(Point p) {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu(this.controller, this.model);
        }
        JComponent comp = null;
        switch (this.selectedView) {
            case 0: {
                if (this.model.getBrowser() == null) break;
                comp = this.model.getBrowser().getUI();
                break;
            }
            case 1: {
                comp = this.model.getTableView();
                break;
            }
            case 3: {
                comp = this.model.getSearchView();
            }
        }
        if (comp != null) {
            this.popupMenu.populateOpenWith();
            this.popupMenu.show(comp, p.x, p.y);
        }
    }

    List<ApplicationData> getApplications() {
        return this.model.getApplications();
    }

    void viewSelectedNode() {
        ImageDisplay node = this.model.getBrowser().getLastSelectedDisplay();
        if (!(node instanceof ImageNode)) {
            return;
        }
        ImageData data = (ImageData)node.getHierarchyObject();
        EventBus bus = DataBrowserAgent.getRegistry().getEventBus();
        ViewImage evt = new ViewImage(this.model.getSecurityContext(), new ViewImageObject(data), null);
        evt.setPlugin(DataBrowserAgent.runAsPlugin());
        bus.post(evt);
    }

    void setStatus(String status, boolean hideProgressBar, int progressPerc) {
        this.statusBar.setStatus(status);
        this.statusBar.setProgress(hideProgressBar, progressPerc);
    }

    void filterByContext(FilterContext context) {
        if (context == null) {
            return;
        }
        this.toolBar.filterByContext(context);
    }

    void setFilterStatus(boolean busy) {
        this.toolBar.setFilterStatus(busy);
    }

    void setFilterLabel(String value) {
        this.toolBar.setFilterLabel(value);
    }

    int getFieldsNumber() {
        if (this.model instanceof WellsModel) {
            return ((WellsModel)this.model).getFieldsNumber();
        }
        return -1;
    }

    int getSelectedField() {
        if (this.model instanceof WellsModel) {
            return ((WellsModel)this.model).getDefaultFieldIndex();
        }
        return 0;
    }

    void viewField() {
        this.setMagnificationFactor(this.statusBar.getMagnificationFactor());
    }

    void setFieldsStatus(boolean status) {
        this.wellToolBar.setStatus(status);
    }

    void updateFieldThumb(WellSampleNode node, boolean complete) {
        this.fieldsView.updateFieldThumb(node, complete);
    }

    void clearWellThumbs(Collection ids) {
        if (!(this.model instanceof WellsModel)) {
            return;
        }
        ((WellsModel)this.model).clearThumbnails(ids);
    }

    void onSelectedWell() {
        if (!(this.model instanceof WellsModel)) {
            return;
        }
        this.plateGridUI.onSelectedWell();
        WellsModel wm = (WellsModel)this.model;
        this.fieldsView.loadFields(wm.getSelectedWells());
    }

    void onExperimenterSet() {
        this.toolBar.onExperimenterSet();
    }

    Object getParentOfNodes() {
        return this.model.getParent();
    }

    Object getGrandParentOfNodes() {
        return this.model.getGrandParent();
    }
}

