/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.util.LinkedHashMap;
import ome.model.units.Unit;
import ome.units.quantity.Length;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.Medium;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ObjectiveConverter
extends DataConverter {
    public ObjectiveConverter() {
        this.tagMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, TagData> convertData(Objective objective, ObjectiveSettings settings) {
        if (objective != null) {
            try {
                this.tagMap.put("ID", this.convertID(objective.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(objective.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(objective.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
            try {
                this.tagMap.put("Nominal Magnification", this.convertNomMagnification(objective.getNominalMagnification(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Nominal Magnification", this.convertNomMagnification(null, true));
            }
            try {
                this.tagMap.put("Calibration Magnification", this.convertCalMagnification(objective.getCalibratedMagnification(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Calibration Magnification", this.convertCalMagnification(null, true));
            }
            try {
                this.tagMap.put("Lens NA", this.convertLensNA(objective.getLensNA(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Lens NA", this.convertLensNA(null, true));
            }
            try {
                this.tagMap.put("Immersion", this.convertImmersion(objective.getImmersion(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Immersion", this.convertImmersion(null, true));
            }
            try {
                this.tagMap.put("Correction", this.convertCorrection(objective.getCorrection(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Correction", this.convertCorrection(null, true));
            }
            try {
                this.tagMap.put("Working Distance", this.convertWorkingDist(objective.getWorkingDistance(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Working Distance", this.convertWorkingDist(null, true));
            }
            try {
                this.tagMap.put("Iris", this.convertIris(objective.getIris(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Iris", this.convertIris(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            this.tagMap.put("Nominal Magnification", this.convertNomMagnification(null, true));
            this.tagMap.put("Calibration Magnification", this.convertCalMagnification(null, true));
            this.tagMap.put("Lens NA", this.convertLensNA(null, true));
            this.tagMap.put("Immersion", this.convertImmersion(null, true));
            this.tagMap.put("Correction", this.convertCorrection(null, true));
            this.tagMap.put("Working Distance", this.convertWorkingDist(null, true));
            this.tagMap.put("Iris", this.convertIris(null, true));
        }
        if (settings != null) {
            try {
                this.tagMap.put("User::Refraction Index", this.convertRefractIndex(settings.getRefractiveIndex(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Refraction Index", this.convertRefractIndex(null, true));
            }
            try {
                this.tagMap.put("User::Medium", this.convertMedium(settings.getMedium(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Medium", this.convertMedium(null, true));
            }
            try {
                this.tagMap.put("User::Correction Collar", this.convertCorCollar(settings.getCorrectionCollar(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Correction Collar", this.convertCorCollar(null, true));
            }
        } else {
            this.tagMap.put("User::Refraction Index", this.convertRefractIndex(null, true));
            this.tagMap.put("User::Medium", this.convertMedium(null, true));
            this.tagMap.put("User::Correction Collar", this.convertCorCollar(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Objective", "ID", value, prop, "TextField");
    }

    private TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Objective", "Model", value, prop, "TextField");
    }

    private TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Objective", "Manufacturer", value, prop, "TextField");
    }

    private TagData convertNomMagnification(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Objective", "Nominal Magnification", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    private TagData convertCalMagnification(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Objective", "Calibration Magnification", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    private TagData convertLensNA(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Objective", "Lens NA", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    private TagData convertImmersion(Immersion value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Objective", "Immersion", val, prop, "ComboBox", OMEValueConverter.getNames(Immersion.class));
    }

    private TagData convertCorrection(Correction value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Objective", "Correction", val, prop, "ComboBox", OMEValueConverter.getNames(Correction.class));
    }

    private TagData convertWorkingDist(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Objective", "Working Distance", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    private TagData convertIris(Boolean value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Objective", "Iris", val, prop, "TextField");
    }

    private TagData convertCorCollar(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Objective", "User::Correction Collar", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    private TagData convertMedium(Medium value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Objective", "User::Medium", val, prop, "ComboBox", OMEValueConverter.getNames(Medium.class));
    }

    private TagData convertRefractIndex(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        TagData t = new TagData("OME:Objective", "User::Refraction Index", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }
}

