/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ModuleTreeParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportFromTemplateFile {
    private HashMap<String, List<Element>> xmlObjectPreList;
    private DefaultMutableTreeNode tempObjTree;
    private String fName;

    public ImportFromTemplateFile(String fName) {
        this.fName = fName;
    }

    public List<String> createTypeList() {
        List<String> objectTypes = new ArrayList<String>();
        try {
            File tempFile = new File(this.fName);
            if (tempFile.exists()) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(tempFile);
                doc.getDocumentElement().normalize();
                NodeList conf = doc.getElementsByTagName("MDETemplate");
                if (conf != null && conf.getLength() > 0) {
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ModuleTreeElement(null, null));
                    objectTypes = this.getTypes(((Element)conf.item(0)).getElementsByTagName("ObjectPre"), objectTypes);
                } else {
                    ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] no object defined in mde template file");
                }
            }
        }
        catch (Exception e) {
            String s = "[MDE] An error occurred when parsing file: ";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        return objectTypes;
    }

    public void parseTemplateFile(List<String> filter) {
        try {
            File tempFile = new File(this.fName);
            if (tempFile.exists()) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(tempFile);
                doc.getDocumentElement().normalize();
                NodeList conf = doc.getElementsByTagName("MDETemplate");
                if (conf != null && conf.getLength() > 0) {
                    this.generateXMLObjectList(((Element)conf.item(0)).getElementsByTagName("ObjectPre"));
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ModuleTreeElement(null, null));
                    this.tempObjTree = this.elementsToObjTree(((Element)conf.item(0)).getElementsByTagName("ObjectTreeRoot"), root, filter);
                } else {
                    ImporterAgent.getRegistry().getLogger().info((Object)this, "[MDE] no object defined in mde template file");
                }
            }
        }
        catch (Exception e) {
            String s = "[MDE] An error occurred when parsing TemplateFile: ";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    private void generateXMLObjectList(NodeList nodeList) {
        this.xmlObjectPreList = new HashMap();
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element eElement;
            String type;
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectPre") || n.getNodeType() != 1 || (type = (eElement = (Element)n).getAttribute("Type")) == null || type.isEmpty()) continue;
            if (this.xmlObjectPreList.containsKey(type)) {
                List<Element> elemList = this.xmlObjectPreList.get(type);
                elemList.add(eElement);
                this.xmlObjectPreList.replace(type, elemList);
                continue;
            }
            ArrayList<Element> elemlist = new ArrayList<Element>();
            elemlist.add(eElement);
            this.xmlObjectPreList.put(type, elemlist);
        }
    }

    public DefaultMutableTreeNode getTempObjTree() {
        return this.tempObjTree;
    }

    private List<String> getTypes(NodeList nodeList, List<String> objectTypes) {
        if (nodeList == null) {
            return objectTypes;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectPre") || n.getNodeType() != 1) continue;
            Element eElement = (Element)n;
            String type = eElement.getAttribute("Type");
            Boolean tagdataDef = eElement.getElementsByTagName("TagData") != null && eElement.getElementsByTagName("TagData").getLength() > 0;
            if (type != null && !type.isEmpty() && !objectTypes.contains(type) && tagdataDef.booleanValue()) {
                objectTypes.add(type);
            }
            objectTypes = this.getTypes(eElement.getElementsByTagName("ObjectPre"), objectTypes);
        }
        return objectTypes;
    }

    private DefaultMutableTreeNode elementsToObjTree(NodeList nodeList, DefaultMutableTreeNode root, List<String> filter) {
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element eElement;
            Element objPre;
            DefaultMutableTreeNode subTree;
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals("ObjectTreeRoot") || n.getNodeType() != 1 || (subTree = this.createObjectSubTree(objPre = this.getObject((eElement = (Element)n).getAttribute("Type"), eElement.getAttribute("UUID")), root, filter)) == null) continue;
            root.add(subTree);
        }
        return root;
    }

    private DefaultMutableTreeNode createObjectSubTree(Element eElement, DefaultMutableTreeNode parent, List<String> filter) {
        if (eElement == null) {
            return null;
        }
        DefaultMutableTreeNode thisNode = null;
        if (eElement.getNodeName().equals("ObjectPre") && eElement.getNodeType() == 1) {
            String type = eElement.getAttribute("Type");
            ModuleTreeElement mte = new ModuleTreeParser().getModuleTreeElementData(eElement, parent, filter.contains(type));
            thisNode = new DefaultMutableTreeNode(mte);
            NodeList childs = eElement.getElementsByTagName("ObjectChild");
            if (childs != null) {
                for (int i = 0; i < childs.getLength(); ++i) {
                    Element child = (Element)childs.item(i);
                    Element childObjPre = this.getObject(child.getAttribute("Type"), child.getAttribute("UUID"));
                    DefaultMutableTreeNode subTree = this.createObjectSubTree(childObjPre, thisNode, filter);
                    if (subTree == null) continue;
                    thisNode.add(subTree);
                }
            }
        }
        return thisNode;
    }

    private Element getObject(String type, String uuid) {
        if (this.xmlObjectPreList == null) {
            return null;
        }
        List<Element> elemList = this.xmlObjectPreList.get(type);
        if (elemList != null) {
            for (Element elem : elemList) {
                if (!elem.getAttribute("UUID").equals(uuid)) continue;
                return elem;
            }
        }
        return null;
    }
}

