/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import omero.gateway.SecurityContext;
import omero.gateway.exception.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class RenderingControlLoader
extends BatchCallTree {
    public static final int LOAD = 0;
    public static final int RELOAD = 1;
    public static final int RESET = 2;
    public static final int SHUTDOWN = 3;
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall makeBatchCall(final long pixelsID, final int index) {
        return new BatchCall("Loading rendering control: "){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = RenderingControlLoader.this.context.getImageService();
                switch (index) {
                    default: {
                        RenderingControlLoader.this.result = rds.loadRenderingControl(RenderingControlLoader.this.ctx, pixelsID);
                        if (RenderingControlLoader.this.result != null) break;
                        throw new DSOutOfServiceException("Cannot start the rendering engine for pixelsID " + pixelsID);
                    }
                    case 1: {
                        RenderingControlLoader.this.result = rds.reloadRenderingService(RenderingControlLoader.this.ctx, pixelsID);
                        if (RenderingControlLoader.this.result != null) break;
                        throw new DSOutOfServiceException("Cannot start the rendering engine for pixelsID " + pixelsID);
                    }
                    case 2: {
                        RenderingControlLoader.this.result = rds.resetRenderingService(RenderingControlLoader.this.ctx, pixelsID);
                        break;
                    }
                    case 3: {
                        rds.shutDown(RenderingControlLoader.this.ctx, pixelsID);
                    }
                }
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public RenderingControlLoader(SecurityContext ctx, long pixelsID, int index) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("ID not valid.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(pixelsID, index);
    }
}

