/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;

class EventBusImpl
implements EventBus {
    private static final int IDLE = 0;
    private static final int DISPATCHING = 1;
    private LinkedList<AgentEvent> eventQueue = new LinkedList();
    private Map<Class<?>, LinkedList<AgentEventListener>> deMultiplexTable = new HashMap();
    private int state = 0;

    private void dispatch() {
        AgentEvent e = this.eventQueue.removeLast();
        Class<?> eventType = e.getClass();
        LinkedList<AgentEventListener> evNotifList = this.deMultiplexTable.get(eventType);
        if (evNotifList != null) {
            for (AgentEventListener listener : evNotifList) {
                if (listener.equals(e.getSource())) continue;
                listener.eventFired(e);
            }
        }
    }

    private boolean verifyInheritance(Class<?> eventClass) {
        Class<AgentEvent> agtEvent = AgentEvent.class;
        boolean b = false;
        while (eventClass != null) {
            if (eventClass == agtEvent) {
                b = true;
                break;
            }
            eventClass = eventClass.getSuperclass();
        }
        return b;
    }

    EventBusImpl() {
    }

    @Override
    public void register(AgentEventListener subscriber, Class<?>[] eventTypes) {
        if (eventTypes == null) {
            throw new NullPointerException("No event types.");
        }
        for (int i = 0; i < eventTypes.length; ++i) {
            this.register(subscriber, eventTypes[i]);
        }
    }

    @Override
    public void register(AgentEventListener subscriber, Class<?> eventType) {
        if (subscriber == null) {
            throw new NullPointerException("No subscriber.");
        }
        if (eventType == null) {
            throw new NullPointerException("No event type.");
        }
        if (this.verifyInheritance(eventType)) {
            LinkedList<AgentEventListener> evNotifList = this.deMultiplexTable.get(eventType);
            if (evNotifList == null) {
                evNotifList = new LinkedList();
                this.deMultiplexTable.put(eventType, evNotifList);
            }
            if (!evNotifList.contains(subscriber)) {
                evNotifList.add(subscriber);
            }
        }
    }

    @Override
    public void remove(AgentEventListener subscriber, Class<?> eventType) {
        if (subscriber == null) {
            throw new NullPointerException("No subscriber.");
        }
        if (eventType == null) {
            throw new NullPointerException("No event type.");
        }
        LinkedList<AgentEventListener> evNotifList = this.deMultiplexTable.get(eventType);
        if (evNotifList != null) {
            evNotifList.remove(subscriber);
            if (evNotifList.isEmpty()) {
                this.deMultiplexTable.remove(eventType);
            }
        }
    }

    @Override
    public void remove(AgentEventListener subscriber, Class<?>[] eventTypes) {
        if (eventTypes == null) {
            throw new NullPointerException("No event types.");
        }
        for (int i = 0; i < eventTypes.length; ++i) {
            this.remove(subscriber, eventTypes[i]);
        }
    }

    @Override
    public void remove(AgentEventListener subscriber) {
        Iterator<Class<?>> e = this.deMultiplexTable.keySet().iterator();
        while (e.hasNext()) {
            this.remove(subscriber, e.next());
        }
    }

    @Override
    public boolean hasListenerFor(Class<?> eventType) {
        return this.deMultiplexTable.get(eventType) != null;
    }

    @Override
    public void post(AgentEvent e) {
        if (e == null) {
            throw new NullPointerException("No event.");
        }
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.eventQueue.addFirst(e);
                while (!this.eventQueue.isEmpty()) {
                    this.dispatch();
                }
                this.state = 0;
                break;
            }
            case 1: {
                this.eventQueue.addFirst(e);
            }
        }
    }
}

