/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPaneUI;

class TinyPaneModel {
    private Container contentPane;
    private Color highlight;
    private Color highlightHistory;
    private boolean collapsed;
    private boolean closed;
    private Dimension restoreSize;
    private int titleBarType;
    private JLayeredPane desktopPane;
    private boolean singleViewMode;
    private JLayeredPane singleViewDesktop;
    private Rectangle childViewBounds;
    private int childViewTitleBarType;
    private boolean childViewCollapsed;
    private String title;
    private String note;
    private boolean resizable;
    private boolean listenToBorder;
    private Icon frameIcon;
    private List decoration;

    private boolean isChild(Component c) {
        if (c != null) {
            Component[] children = this.desktopPane.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (c != children[i]) continue;
                return true;
            }
            if (c == this.getChildView()) {
                return true;
            }
        }
        return false;
    }

    private Component getFirstChild(Container c) {
        Component[] comp;
        Component child = null;
        if (c != null && 0 < (comp = c.getComponents()).length) {
            child = comp[0];
        }
        return child;
    }

    private void setParentSizeForSingleView(Container parent) {
        if (parent instanceof TinyPane) {
            Dimension d = ((TinyPane)parent).getTitleBar().getPreferredSize();
            Dimension dDesktop = this.singleViewDesktop.getPreferredSize();
            parent.setSize(d.width + dDesktop.width, d.height + dDesktop.height + 4);
            parent.validate();
        } else {
            this.setParentSizeForSingleView(parent.getParent());
        }
    }

    private void setParentSizeForMultiView(Container parent) {
        if (parent == null) {
            return;
        }
        if (parent instanceof TinyPane) {
            parent.setSize(parent.getPreferredSize());
            parent.validate();
        } else {
            this.setParentSizeForMultiView(parent.getParent());
        }
    }

    TinyPaneModel(Container contentPane, String title, Dimension restoreSize) {
        if (contentPane == null) {
            throw new NullPointerException("No content pane.");
        }
        this.contentPane = contentPane;
        this.title = title;
        this.setRestoreSize(restoreSize);
        this.desktopPane = new JLayeredPane();
        this.setTitleBarType(3);
        this.resizable = true;
        this.listenToBorder = true;
        this.note = "";
        this.decoration = new ArrayList();
    }

    void restoreDisplay(TinyPaneUI uiDelegate) {
        this.contentPane.removeAll();
        if (this.singleViewMode) {
            if (this.singleViewDesktop != null) {
                this.contentPane.add((Component)uiDelegate.decorateDesktopPane(this.singleViewDesktop), "Center");
            }
        } else {
            this.contentPane.add((Component)uiDelegate.decorateDesktopPane(this.desktopPane), "Center");
        }
        this.contentPane.validate();
        this.contentPane.repaint();
    }

    boolean isSingleViewMode() {
        return this.singleViewMode;
    }

    void setSingleViewMode(boolean singleViewMode, TinyPaneUI uiDelegate) {
        if (uiDelegate == null) {
            throw new NullPointerException("No UI delegate.");
        }
        this.singleViewMode = singleViewMode;
        if (singleViewMode) {
            this.singleViewDesktop = new JLayeredPane();
            this.contentPane.removeAll();
            this.contentPane.add((Component)uiDelegate.decorateDesktopPane(this.singleViewDesktop), "Center");
            this.setChildView(this.getFirstChild(this.desktopPane));
        } else {
            this.contentPane.removeAll();
            this.contentPane.add((Component)uiDelegate.decorateDesktopPane(this.desktopPane), "Center");
            this.setChildView(null);
            this.singleViewDesktop = null;
        }
    }

    void setChildView(Component child) {
        TinyPane tf;
        Component oldChild = this.getChildView();
        if (oldChild != null) {
            this.singleViewDesktop.remove(oldChild);
            this.desktopPane.add(oldChild);
            oldChild.setBounds(this.childViewBounds);
            if (oldChild instanceof TinyPane) {
                tf = (TinyPane)oldChild;
                tf.setTitleBarType(this.childViewTitleBarType);
                tf.setCollapsed(this.childViewCollapsed);
                if (child == null) {
                    this.setParentSizeForMultiView(tf.getParent());
                }
            }
        }
        if (this.isChild(child)) {
            this.desktopPane.remove(child);
            this.singleViewDesktop.add(child);
            this.childViewBounds = child.getBounds();
            this.singleViewDesktop.setPreferredSize(child.getPreferredSize());
            if (child instanceof TinyPane) {
                tf = (TinyPane)child;
                this.childViewTitleBarType = tf.getTitleBarType();
                this.childViewCollapsed = tf.isCollapsed();
                tf.setTitleBarType(2);
                tf.setCollapsed(false);
                this.setParentSizeForSingleView(tf.getParent());
            }
            Dimension d = child.getPreferredSize();
            child.setBounds(2, 2, d.width, d.height);
        }
    }

    Component getChildView() {
        return this.getFirstChild(this.singleViewDesktop);
    }

    String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        this.title = title;
    }

    String getNote() {
        return this.note;
    }

    void setNote(String note) {
        this.note = note;
    }

    int getTitleBarType() {
        return this.titleBarType;
    }

    boolean setTitleBarType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleBarType = type;
                return true;
            }
        }
        return false;
    }

    Rectangle getContentsBounds() {
        Component[] comp = this.desktopPane.getComponents();
        int x = 0;
        int y = 0;
        int br_x = 0;
        int br_y = 0;
        for (int i = 0; i < comp.length; ++i) {
            Rectangle bounds = comp[i].getBounds();
            x = Math.min(x, bounds.x);
            y = Math.min(y, bounds.y);
            br_x = Math.max(br_x, bounds.x + bounds.width);
            br_y = Math.max(br_y, bounds.y + bounds.height);
        }
        return new Rectangle(x, y, br_x - x, br_y - y);
    }

    Dimension getRestoreSize() {
        return this.restoreSize;
    }

    void setRestoreSize(Dimension rs) {
        if (rs == null) {
            throw new NullPointerException("No restore size.");
        }
        this.restoreSize = rs;
    }

    JComponent getDesktopPane() {
        return this.desktopPane;
    }

    Color getHighlight() {
        return this.highlight;
    }

    Color getPreviousHighlight() {
        return this.highlightHistory;
    }

    void setHighlight(Color highlight) {
        this.highlightHistory = this.getHighlight();
        this.highlight = highlight;
    }

    boolean isCollapsed() {
        return this.collapsed;
    }

    void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    boolean isResizable() {
        return this.resizable;
    }

    void setFrameIcon(Icon frameIcon) {
        this.frameIcon = frameIcon;
    }

    Icon getFrameIcon() {
        return this.frameIcon;
    }

    void setListenToBorder(boolean listenToBorder) {
        this.listenToBorder = listenToBorder;
    }

    boolean isListenToBorder() {
        return this.listenToBorder;
    }

    Container getContentPane() {
        return this.contentPane;
    }

    List getDecoration() {
        return this.decoration;
    }

    void setDecoration(List decoration) {
        this.decoration = decoration;
    }

    boolean isClosed() {
        return this.closed;
    }

    void setClosed(boolean closed) {
        this.closed = closed;
    }
}

