/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import org.hibernate.Session;

public abstract class BaseGraphPolicyAdjuster
extends GraphPolicy {
    private final GraphPolicy graphPolicy;

    public BaseGraphPolicyAdjuster(GraphPolicy graphPolicy) {
        this.graphPolicy = graphPolicy;
    }

    protected boolean isAdjustedBeforeReview(GraphPolicy.Details object) {
        return false;
    }

    protected boolean isAdjustedAfterReview(GraphPolicy.Details object) {
        return false;
    }

    @Override
    public void registerPredicate(GraphPolicyRulePredicate predicate) {
        this.graphPolicy.registerPredicate(predicate);
    }

    @Override
    public GraphPolicy getCleanInstance() {
        return this.graphPolicy.getCleanInstance();
    }

    @Override
    public void setCondition(String name) {
        this.graphPolicy.setCondition(name);
    }

    @Override
    public boolean isCondition(String name) {
        return this.graphPolicy.isCondition(name);
    }

    @Override
    public void noteDetails(Session session, IObject object, String realClass, long id) {
        this.graphPolicy.noteDetails(session, object, realClass, id);
    }

    @Override
    public final Set<GraphPolicy.Details> review(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, boolean isErrorRules) throws GraphException {
        Set<GraphPolicy.Details> allTerms = GraphPolicy.allObjects(linkedFrom.values(), rootObject, linkedTo.values());
        HashSet<GraphPolicy.Details> changedTerms = new HashSet<GraphPolicy.Details>();
        for (GraphPolicy.Details object : allTerms) {
            if (!this.isAdjustedBeforeReview(object)) continue;
            changedTerms.add(object);
        }
        changedTerms.addAll(this.graphPolicy.review(linkedFrom, rootObject, linkedTo, notNullable, isErrorRules));
        for (GraphPolicy.Details object : allTerms) {
            if (!this.isAdjustedAfterReview(object)) continue;
            changedTerms.add(object);
        }
        return changedTerms;
    }
}

