/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.stats;

import ome.services.sessions.stats.MethodCounter;
import ome.services.sessions.stats.ObjectsReadCounter;
import ome.services.sessions.stats.ObjectsWrittenCounter;
import ome.services.sessions.stats.SessionStats;
import ome.services.sessions.stats.SimpleSessionStats;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class CounterFactory
implements ApplicationEventPublisherAware {
    protected ApplicationEventPublisher publisher;
    protected int objectsReadHardLimit = Integer.MAX_VALUE;
    protected int objectsWrittenHardLimit = Integer.MAX_VALUE;
    protected int methodHardLimit = Integer.MAX_VALUE;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void setObjectsReadHardLimit(int objectsReadHardLimit) {
        this.objectsReadHardLimit = objectsReadHardLimit;
    }

    public void setObjectsWrittenHardLimit(int objectsWrittenHardLimit) {
        this.objectsWrittenHardLimit = objectsWrittenHardLimit;
    }

    public void setMethodHardLimit(int methodHardLimit) {
        this.methodHardLimit = methodHardLimit;
    }

    public SessionStats createStats() {
        ObjectsReadCounter read = new ObjectsReadCounter(this.objectsReadHardLimit);
        read.setApplicationEventPublisher(this.publisher);
        ObjectsWrittenCounter written = new ObjectsWrittenCounter(this.objectsWrittenHardLimit);
        written.setApplicationEventPublisher(this.publisher);
        MethodCounter methods = new MethodCounter(this.methodHardLimit);
        methods.setApplicationEventPublisher(this.publisher);
        return new SimpleSessionStats(read, written, methods);
    }
}

