/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitAction
extends UngroupAction {
    public static final String ID = "selectionSplit";

    public SplitAction(DrawingEditor editor) {
        super(editor, new SVGPathFigure());
        this.labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels", Locale.getDefault());
        this.labels.configureAction(this, ID);
    }

    @Override
    protected boolean canUngroup() {
        if (super.canUngroup()) {
            return ((CompositeFigure)this.getView().getSelectedFigures().iterator().next()).getChildCount() > 1;
        }
        return false;
    }

    @Override
    public Collection<Figure> ungroupFigures(DrawingView view, CompositeFigure group) {
        LinkedList<Figure> figures = new LinkedList<Figure>(group.getChildren());
        view.clearSelection();
        group.basicRemoveAllChildren();
        LinkedList<Figure> paths = new LinkedList<Figure>();
        for (Figure f : figures) {
            SVGPathFigure path = new SVGPathFigure();
            path.removeAllChildren();
            for (Map.Entry<AttributeKey, Object> entry : group.getAttributes().entrySet()) {
                path.setAttribute(entry.getKey(), entry.getValue());
            }
            path.add(f);
            view.getDrawing().basicAdd(path);
            paths.add(path);
        }
        view.getDrawing().remove(group);
        view.addToSelection(paths);
        return figures;
    }

    @Override
    public void groupFigures(DrawingView view, CompositeFigure group, Collection<Figure> figures) {
        List<Figure> sorted = view.getDrawing().sort(figures);
        view.getDrawing().basicRemoveAll(figures);
        view.clearSelection();
        view.getDrawing().add(group);
        group.willChange();
        ((SVGPathFigure)group).removeAllChildren();
        for (Map.Entry<AttributeKey, Object> entry : figures.iterator().next().getAttributes().entrySet()) {
            group.setAttribute(entry.getKey(), entry.getValue());
        }
        for (Figure f : sorted) {
            SVGPathFigure path = (SVGPathFigure)f;
            for (Figure child : path.getChildren()) {
                group.basicAdd(child);
            }
        }
        group.changed();
        view.addToSelection(group);
    }
}

