/*
 * Decompiled with CFR 0.152.
 */
package ome.util.search;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ome.util.search.InvalidQueryException;
import ome.util.search.LuceneQueryBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LuceneQueryBuilderTest {
    SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");

    @Test
    public void test_buildLuceneQuery() throws InvalidQueryException, ParseException {
        ArrayList<String> fields = new ArrayList<String>();
        String raw = "%";
        Object expected = "";
        this.checkQuery(fields, raw, (String)expected);
        raw = "dv";
        expected = "dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test dv";
        expected = "test dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test dv";
        expected = "*test dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test *dv";
        expected = "test *dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "?test dv";
        expected = "?test dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test ?dv";
        expected = "test ?dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test * dv";
        expected = "test dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test *.dv";
        expected = "test dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test \"*dv\"";
        expected = "test \"*dv\"";
        this.checkQuery(fields, raw, (String)expected);
        raw = "\"?test *dv\"";
        expected = "\"?test *dv\"";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test-dv";
        expected = "test-dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test_dv";
        expected = "*test_dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test-dv";
        expected = "*test-dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test AND dv";
        expected = "((test) AND (dv))";
        this.checkQuery(fields, raw, (String)expected);
        raw = "has_key:foo";
        expected = "has_key:foo";
        this.checkQuery(fields, raw, (String)expected);
        raw = "foo:bar";
        expected = "foo:bar";
        this.checkQuery(fields, raw, (String)expected);
        fields.add("name");
        raw = "dv";
        expected = "name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test dv";
        expected = "name:test name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test dv";
        expected = "name:*test name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test *dv";
        expected = "name:test name:*dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "?test dv";
        expected = "name:?test name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test ?dv";
        expected = "name:test name:?dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test * dv";
        expected = "name:test name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test *.dv";
        expected = "name:test name:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test \"*dv\"";
        expected = "name:test name:\"*dv\"";
        this.checkQuery(fields, raw, (String)expected);
        raw = "\"?test *.dv\"";
        expected = "name:\"?test *.dv\"";
        this.checkQuery(fields, raw, (String)expected);
        raw = "(test-dv}";
        expected = "name:test-dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test_dv";
        expected = "name:*test_dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test AND dv";
        expected = "((name:test) AND (name:dv))";
        this.checkQuery(fields, raw, (String)expected);
        raw = "has_key:foo";
        expected = "has_key:foo";
        this.checkQuery(fields, raw, (String)expected);
        raw = "foo:bar";
        expected = "foo:bar";
        this.checkQuery(fields, raw, (String)expected);
        fields.add("description");
        raw = "dv";
        expected = "name:dv description:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test dv";
        expected = "name:test description:test name:dv description:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "*test dv";
        expected = "name:*test description:*test name:dv description:dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "test *dv";
        expected = "name:test description:test name:*dv description:*dv";
        this.checkQuery(fields, raw, (String)expected);
        raw = "a b AND c AND d f";
        expected = "name:a description:a name:f description:f ((name:b description:b) AND (name:c description:c) AND (name:d description:d))";
        this.checkQuery(fields, raw, (String)expected);
        raw = "has_key:foo";
        expected = "has_key:foo";
        this.checkQuery(fields, raw, (String)expected);
        raw = "foo:bar";
        expected = "foo:bar";
        this.checkQuery(fields, raw, (String)expected);
        Date from = this.df.parse("20140701");
        Date to = this.df.parse("20140702");
        String dateType = "acquisitionDate";
        raw = "a b";
        expected = "(name:a description:a name:b description:b) AND acquisitionDate:[20140701 TO 20140703]";
        this.checkQuery(fields, from, to, dateType, raw, (String)expected);
        to = null;
        dateType = "details.creationEvent.time";
        raw = "a b";
        expected = "(name:a description:a name:b description:b) AND details.creationEvent.time:[20140701 TO " + this.getTomorrowDateString() + "]";
        this.checkQuery(fields, from, to, dateType, raw, (String)expected);
        from = null;
        to = this.df.parse("20140702");
        dateType = "details.creationEvent.time";
        raw = "a b";
        expected = "(name:a description:a name:b description:b) AND details.creationEvent.time:[19700101 TO 20140703]";
        this.checkQuery(fields, from, to, dateType, raw, (String)expected);
        from = this.df.parse("20110701");
        to = this.df.parse("20110704");
        raw = "";
        expected = "details.creationEvent.time:[20110701 TO 20110705]";
        this.checkQuery(new ArrayList<String>(), from, to, dateType, raw, (String)expected);
    }

    private String getTomorrowDateString() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return this.df.format(cal.getTime());
    }

    private void checkQuery(List<String> fields, String raw, String expected) throws InvalidQueryException {
        String processed = LuceneQueryBuilder.buildLuceneQuery(fields, raw);
        Assert.assertEquals((String)expected, (String)processed, (String)("Failed on query: " + raw));
    }

    private void checkQuery(List<String> fields, Date from, Date to, String dateType, String raw, String expected) throws InvalidQueryException {
        String processed = LuceneQueryBuilder.buildLuceneQuery(fields, from, to, dateType, raw);
        Assert.assertEquals((String)expected, (String)processed, (String)("Failed on query: " + raw));
    }
}

