/*
 * Decompiled with CFR 0.152.
 */
package ome.model.fs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.FilesetAnnotationLink;
import ome.model.core.Image;
import ome.model.fs.FilesetEntry;
import ome.model.fs.FilesetJobLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.jobs.Job;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="fileset_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="fileset_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="fileset_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="fileset_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="fileset_owner_filter_USEDFILES", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="fileset_group_filter_USEDFILES", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="fileset_event_filter_USEDFILES", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="fileset_perms_filter_USEDFILES", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="fileset_owner_filter_IMAGES", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="fileset_group_filter_IMAGES", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="fileset_event_filter_IMAGES", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="fileset_perms_filter_IMAGES", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="fileset_owner_filter_JOBLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="fileset_group_filter_JOBLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="fileset_event_filter_JOBLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="fileset_perms_filter_JOBLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="fileset_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="fileset_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="fileset_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="fileset_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="fileset_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="fileset_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="fileset_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="fileset_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)")})
@Entity
@Table(name="fileset", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_fileset", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_fileset"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Fileset
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "fileset_owner_filter";
    public static final String GROUP_FILTER = "fileset_group_filter";
    public static final String EVENT_FILTER = "fileset_event_filter";
    public static final String PERMS_FILTER = "fileset_perms_filter";
    public static final String ID = "ome.model.fs.Fileset_id";
    protected Long id;
    public static final String VERSION = "ome.model.fs.Fileset_version";
    protected Integer version = 0;
    protected List<FilesetEntry> usedFiles = new ArrayList<FilesetEntry>();
    public static final String OWNER_FILTER_USEDFILES = "fileset_owner_filter_USEDFILES";
    public static final String GROUP_FILTER_USEDFILES = "fileset_group_filter_USEDFILES";
    public static final String EVENT_FILTER_USEDFILES = "fileset_event_filter_USEDFILES";
    public static final String PERMS_FILTER_USEDFILES = "fileset_perms_filter_USEDFILES";
    protected Set<Image> images = new HashSet<Image>();
    public static final String OWNER_FILTER_IMAGES = "fileset_owner_filter_IMAGES";
    public static final String GROUP_FILTER_IMAGES = "fileset_group_filter_IMAGES";
    public static final String EVENT_FILTER_IMAGES = "fileset_event_filter_IMAGES";
    public static final String PERMS_FILTER_IMAGES = "fileset_perms_filter_IMAGES";
    protected List<FilesetJobLink> jobLinks = new ArrayList<FilesetJobLink>();
    public static final String OWNER_FILTER_JOBLINKS = "fileset_owner_filter_JOBLINKS";
    public static final String GROUP_FILTER_JOBLINKS = "fileset_group_filter_JOBLINKS";
    public static final String EVENT_FILTER_JOBLINKS = "fileset_event_filter_JOBLINKS";
    public static final String PERMS_FILTER_JOBLINKS = "fileset_perms_filter_JOBLINKS";
    private Map<Long, Long> jobLinksCountPerOwner = null;
    protected String templatePrefix = null;
    protected Set<FilesetAnnotationLink> annotationLinks = new HashSet<FilesetAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "fileset_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "fileset_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "fileset_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "fileset_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String USEDFILES = "ome.model.fs.Fileset_usedFiles";
    public static final String IMAGES = "ome.model.fs.Fileset_images";
    public static final String JOBLINKSCOUNTPEROWNER = "ome.model.fs.Fileset_jobLinksCountPerOwner";
    public static final String JOBLINKS = "ome.model.fs.Fileset_jobLinks";
    public static final String TEMPLATEPREFIX = "ome.model.fs.Fileset_templatePrefix";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.fs.Fileset_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.fs.Fileset_annotationLinks";
    public static final String DETAILS = "ome.model.fs.Fileset_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Fileset() {
        this(null, true);
    }

    protected Fileset(Long id) {
        this(id, true);
    }

    public Fileset(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Fileset(String _templatePrefix) {
        this(null, true);
        this.setTemplatePrefix(_templatePrefix);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_fileset")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @JoinColumn(name="fileset", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="fileset_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="fileset_owner_filter_USEDFILES", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="fileset_group_filter_USEDFILES", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="fileset_event_filter_USEDFILES", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="fileset_perms_filter_USEDFILES", condition=":permsStr = permissions")})
    protected List<FilesetEntry> getUsedFiles() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.usedFiles;
    }

    protected void setUsedFiles(List<FilesetEntry> usedFiles) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.usedFiles = usedFiles;
    }

    public int sizeOfUsedFiles() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.usedFiles == null ? -1 : this.usedFiles.size();
    }

    public Iterator<FilesetEntry> iterateUsedFiles() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            return new EmptyIterator<FilesetEntry>();
        }
        return this.getUsedFiles().iterator();
    }

    public Collection<FilesetEntry> unmodifiableUsedFiles() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getUsedFiles());
    }

    public <E> List<E> collectUsedFiles(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilesetEntry> it = this.iterateUsedFiles();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilesetEntry(FilesetEntry target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        this.getUsedFiles().add(target);
        if (target != null && target.isLoaded()) {
            target.setFileset(this);
        }
    }

    public void addFilesetEntrySet(Collection<FilesetEntry> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        this.getUsedFiles().addAll(targets);
        for (FilesetEntry target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setFileset(this);
        }
    }

    public void removeFilesetEntry(FilesetEntry target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        this.getUsedFiles().remove(target);
        if (target.isLoaded()) {
            target.setFileset(null);
        }
    }

    public void removeFilesetEntrySet(Collection<FilesetEntry> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        this.getUsedFiles().removeAll(targets);
        for (FilesetEntry target : targets) {
            if (!target.isLoaded()) continue;
            target.setFileset(null);
        }
    }

    public void clearUsedFiles() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        this.getUsedFiles().clear();
        Iterator<FilesetEntry> it = this.iterateUsedFiles();
        while (it.hasNext()) {
            FilesetEntry target = it.next();
            target.setFileset(null);
        }
    }

    public FilesetEntry getFilesetEntry(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        return this.getUsedFiles().get(index);
    }

    public FilesetEntry setFilesetEntry(int index, FilesetEntry element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        FilesetEntry old = this.getUsedFiles().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setFileset(this);
        }
        return old;
    }

    @Transient
    public FilesetEntry getPrimaryFilesetEntry() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        return this.getUsedFiles().get(0);
    }

    public FilesetEntry setPrimaryFilesetEntry(FilesetEntry element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getUsedFiles() == null) {
            this.throwNullCollectionException("UsedFiles");
        }
        List<FilesetEntry> list = this.getUsedFiles();
        int index = list.indexOf(element);
        FilesetEntry old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    @OneToMany(mappedBy="fileset", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (:images))"), @org.hibernate.annotations.Filter(name="fileset_owner_filter_IMAGES", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="fileset_group_filter_IMAGES", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="fileset_event_filter_IMAGES", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="fileset_perms_filter_IMAGES", condition=":permsStr = permissions")})
    protected Set<Image> getImages() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.images;
    }

    protected void setImages(Set<Image> images) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.images = images;
    }

    public int sizeOfImages() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.images == null ? -1 : this.images.size();
    }

    public Iterator<Image> iterateImages() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            return new EmptyIterator<Image>();
        }
        return this.getImages().iterator();
    }

    public Collection<Image> unmodifiableImages() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getImages());
    }

    public <E> List<E> collectImages(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Image> it = this.iterateImages();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addImage(Image target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            this.throwNullCollectionException("Images");
        }
        this.getImages().add(target);
        if (target != null) {
            target.setFileset(this);
        }
    }

    public void addImageSet(Collection<Image> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            this.throwNullCollectionException("Images");
        }
        this.getImages().addAll(targets);
        for (Image target : targets) {
            if (target == null) continue;
            target.setFileset(this);
        }
    }

    public void removeImage(Image target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            this.throwNullCollectionException("Images");
        }
        this.getImages().remove(target);
        target.setFileset(null);
    }

    public void removeImageSet(Collection<Image> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            this.throwNullCollectionException("Images");
        }
        this.getImages().removeAll(targets);
        for (Image target : targets) {
            target.setFileset(null);
        }
    }

    public void clearImages() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getImages() == null) {
            this.throwNullCollectionException("Images");
        }
        this.getImages().clear();
        Iterator<Image> it = this.iterateImages();
        while (it.hasNext()) {
            Image target = it.next();
            target.setFileset(null);
        }
    }

    @JoinColumn(name="parent", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="parent_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="fileset_owner_filter_JOBLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="fileset_group_filter_JOBLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="fileset_event_filter_JOBLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="fileset_perms_filter_JOBLINKS", condition=":permsStr = permissions")})
    protected List<FilesetJobLink> getJobLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.jobLinks;
    }

    protected void setJobLinks(List<FilesetJobLink> jobLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.jobLinks = jobLinks;
    }

    public int sizeOfJobLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.jobLinks == null ? -1 : this.jobLinks.size();
    }

    public Iterator<FilesetJobLink> iterateJobLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            return new EmptyIterator<FilesetJobLink>();
        }
        return this.getJobLinks().iterator();
    }

    public Collection<FilesetJobLink> unmodifiableJobLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getJobLinks());
    }

    public <E> List<E> collectJobLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilesetJobLink> it = this.iterateJobLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilesetJobLink(FilesetJobLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().add(target);
        if (target != null && target.isLoaded()) {
            target.setParent(this);
        }
    }

    public void addFilesetJobLinkSet(Collection<FilesetJobLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().addAll(targets);
        for (FilesetJobLink target : targets) {
            if (target == null || !target.isLoaded()) continue;
            target.setParent(this);
        }
    }

    public void removeFilesetJobLink(FilesetJobLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().remove(target);
        if (target.isLoaded()) {
            target.setParent(null);
        }
    }

    public void removeFilesetJobLinkSet(Collection<FilesetJobLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().removeAll(targets);
        for (FilesetJobLink target : targets) {
            if (!target.isLoaded()) continue;
            target.setParent(null);
        }
    }

    public FilesetJobLink getFilesetJobLink(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        return this.getJobLinks().get(index);
    }

    public FilesetJobLink setFilesetJobLink(int index, FilesetJobLink element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        FilesetJobLink old = this.getJobLinks().set(index, element);
        if (element != null && element.isLoaded()) {
            element.setParent(this);
        }
        return old;
    }

    @Transient
    public FilesetJobLink getPrimaryFilesetJobLink() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        return this.getJobLinks().get(0);
    }

    public FilesetJobLink setPrimaryFilesetJobLink(FilesetJobLink element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        List<FilesetJobLink> list = this.getJobLinks();
        int index = list.indexOf(element);
        FilesetJobLink old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    public FilesetJobLink linkJob(Job addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilesetJobLink link = new FilesetJobLink();
        link.link(this, addition);
        this.addFilesetJobLink(link, true);
        return link;
    }

    public void addFilesetJobLink(FilesetJobLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().add(link);
    }

    public Iterator<Job> linkedJobIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            return new EmptyIterator<Job>();
        }
        final Iterator<FilesetJobLink> it = this.getJobLinks().iterator();
        return new Iterator<Job>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Job next() {
                if (it == null) {
                    throw new NoSuchElementException("jobLinks is null; no elements.");
                }
                FilesetJobLink link = (FilesetJobLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilesetJobLink> findFilesetJobLink(Job target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilesetJobLink> it = this.iterateJobLinks();
        HashSet<FilesetJobLink> result = new HashSet<FilesetJobLink>();
        while (it.hasNext()) {
            FilesetJobLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Job> linkedJobList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Job> it = this.linkedJobIterator();
        ArrayList<Job> list = new ArrayList<Job>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedJob(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Job> it = this.linkedJobIterator();
        while (it.hasNext()) {
            Job obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkJob(Job removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilesetJobLink> toRemove = this.findFilesetJobLink(removal);
        Iterator<FilesetJobLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilesetJobLink(it.next(), true);
        }
    }

    public void removeFilesetJobLink(FilesetJobLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getJobLinks() == null) {
            this.throwNullCollectionException("JobLinks");
        }
        this.getJobLinks().remove(link);
    }

    public void clearJobLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilesetJobLink> list = new ArrayList<FilesetJobLink>(this.getJobLinks());
        for (FilesetJobLink link : list) {
            this.removeFilesetJobLink(link, true);
        }
    }

    protected void setJobLinksCountPerOwner(Map<Long, Long> map) {
        this.jobLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Fileset_jobLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Fileset_jobLinks_by_owner", joinColumns={@JoinColumn(name="Fileset_id")})
    public Map<Long, Long> getJobLinksCountPerOwner() {
        return this.jobLinksCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="templatePrefix", updatable=true)
    public String getTemplatePrefix() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.templatePrefix;
    }

    public void setTemplatePrefix(String templatePrefix) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.templatePrefix = templatePrefix;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="fileset_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="fileset_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="fileset_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="fileset_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<FilesetAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<FilesetAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<FilesetAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<FilesetAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<FilesetAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilesetAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilesetAnnotationLink(FilesetAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFilesetAnnotationLinkSet(Collection<FilesetAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (FilesetAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFilesetAnnotationLink(FilesetAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeFilesetAnnotationLinkSet(Collection<FilesetAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (FilesetAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public FilesetAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilesetAnnotationLink link = new FilesetAnnotationLink();
        link.link(this, addition);
        this.addFilesetAnnotationLink(link, true);
        return link;
    }

    public void addFilesetAnnotationLink(FilesetAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<FilesetAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                FilesetAnnotationLink link = (FilesetAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilesetAnnotationLink> findFilesetAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilesetAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<FilesetAnnotationLink> result = new HashSet<FilesetAnnotationLink>();
        while (it.hasNext()) {
            FilesetAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilesetAnnotationLink> toRemove = this.findFilesetAnnotationLink(removal);
        Iterator<FilesetAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilesetAnnotationLink(it.next(), true);
        }
    }

    public void removeFilesetAnnotationLink(FilesetAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilesetAnnotationLink> list = new ArrayList<FilesetAnnotationLink>(this.getAnnotationLinks());
        for (FilesetAnnotationLink link : list) {
            this.removeFilesetAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Fileset_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Fileset_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Fileset_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Fileset newInstance() {
        return new Fileset();
    }

    public Fileset proxy() {
        return new Fileset(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.usedFiles = (List)__filter.filter(USEDFILES, this.usedFiles);
            this.images = (Set)__filter.filter(IMAGES, this.images);
            this.jobLinksCountPerOwner = __filter.filter(JOBLINKSCOUNTPEROWNER, this.jobLinksCountPerOwner);
            this.jobLinks = (List)__filter.filter(JOBLINKS, this.jobLinks);
            this.templatePrefix = (String)__filter.filter(TEMPLATEPREFIX, this.templatePrefix);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(USEDFILES)) {
            return this.getUsedFiles();
        }
        if (field.equals(IMAGES)) {
            return this.getImages();
        }
        if (field.equals(JOBLINKSCOUNTPEROWNER)) {
            return this.getJobLinksCountPerOwner();
        }
        if (field.equals(JOBLINKS)) {
            return this.getJobLinks();
        }
        if (field.equals(TEMPLATEPREFIX)) {
            return this.getTemplatePrefix();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(USEDFILES)) {
            this.setUsedFiles((List)value);
        } else if (field.equals(IMAGES)) {
            this.setImages((Set)value);
        } else if (field.equals(JOBLINKSCOUNTPEROWNER)) {
            this.setJobLinksCountPerOwner((Map)value);
        } else if (field.equals(JOBLINKS)) {
            this.setJobLinks((List)value);
        } else if (field.equals(TEMPLATEPREFIX)) {
            this.setTemplatePrefix((String)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.usedFiles = null;
        this.images = null;
        this.jobLinksCountPerOwner = null;
        this.jobLinks = null;
        this.templatePrefix = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(USEDFILES);
        raw.add(IMAGES);
        raw.add(JOBLINKSCOUNTPEROWNER);
        raw.add(JOBLINKS);
        raw.add(TEMPLATEPREFIX);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKfileset_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfileset_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKfileset_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfileset_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfileset_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

