/*
 * Decompiled with CFR 0.152.
 */
package ome.model.internal;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ome.util.Counter;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BooleanArrayCache {
    private static Logger logger = LoggerFactory.getLogger(BooleanArrayCache.class);
    private SoftReference<? extends Map<Long, boolean[]>> cacheRef = new SoftReference(new HashMap());
    private final Counter hits = new Counter();
    private long misses = 0L;
    private long resets = 0L;
    private final DelayTracker logWhen = new DelayTracker(3000);

    BooleanArrayCache() {
    }

    private static long numberForArray(boolean[] array) {
        if (array.length > 64) {
            throw new IllegalArgumentException("array may have no more elements than 64");
        }
        long number = 0L;
        long nextBit = 1L;
        for (boolean bit : array) {
            if (bit) {
                number |= nextBit;
            }
            nextBit <<= 1;
        }
        return number;
    }

    boolean[] getArrayFor(boolean[] array) {
        boolean[] cached;
        if (this.logWhen.isNow()) {
            logger.debug("cache stats: hits={}, misses={}, resets={}", new Object[]{this.hits.asBigInteger(), this.misses, this.resets});
        }
        if (array == null) {
            array = ArrayUtils.EMPTY_BOOLEAN_ARRAY;
        }
        long number = BooleanArrayCache.numberForArray(array);
        Map<Long, boolean[]> cache = this.cacheRef.get();
        if (cache == null) {
            logger.debug("resetting cache");
            cache = new HashMap<Long, boolean[]>();
            this.cacheRef = new SoftReference<Map<Long, boolean[]>>(cache);
            this.hits.reset();
            this.misses = 0L;
            ++this.resets;
        }
        if ((cached = cache.get(number)) == null) {
            cache.put(number, array);
            ++this.misses;
            return array;
        }
        if (BooleanArrayCache.numberForArray(cached) != number) {
            throw new IllegalStateException("cache violation");
        }
        this.hits.increment();
        return cached;
    }

    public boolean[] transform(Transformer transformer, boolean[] array) {
        if (array == null) {
            array = ArrayUtils.EMPTY_BOOLEAN_ARRAY;
        } else if (array.length > 0) {
            array = Arrays.copyOf(array, array.length);
        }
        return this.getArrayFor(transformer.transform(array));
    }

    private static class DelayTracker {
        private final long intervalMs;
        private long delayUntil;

        DelayTracker(int delaySeconds) {
            this.intervalMs = (long)delaySeconds * 1000L;
            this.setNextDelay();
        }

        private void setNextDelay() {
            this.delayUntil = System.currentTimeMillis() + this.intervalMs;
        }

        boolean isNow() {
            boolean isNow;
            boolean bl = isNow = this.delayUntil <= System.currentTimeMillis();
            if (isNow) {
                this.setNextDelay();
            }
            return isNow;
        }
    }

    static interface Transformer {
        public boolean[] transform(boolean[] var1);
    }
}

