/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.security.NodeProvider;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.SqlAction;

public class NodeProviderInMemory
implements NodeProvider,
ReadOnlyStatus.IsAware {
    public final String uuid;
    private final Principal principal;
    private final Map<String, Node> currentNodes = new ConcurrentHashMap<String, Node>();
    private final AtomicLong currentNodeId = new AtomicLong(-1L);

    public NodeProviderInMemory(String uuid) {
        this.uuid = uuid;
        this.principal = new Principal(uuid, "system", "Internal");
    }

    @Override
    public Principal principal() {
        return this.principal;
    }

    @Override
    public long getManagerIdByUuid(String managerUuid, SqlAction sql) {
        Node manager = this.getManagerByUuid(managerUuid, null);
        return manager == null ? 0L : manager.getId();
    }

    @Override
    public Node getManagerByUuid(String managerUuid, ServiceFactory sf) {
        return this.currentNodes.get(managerUuid);
    }

    @Override
    public Set<String> getManagerList(boolean onlyActive) {
        HashSet<String> nodeIds = new HashSet<String>();
        for (Node node : this.currentNodes.values()) {
            if (onlyActive && node.getDown() != null) continue;
            nodeIds.add(node.getUuid());
        }
        return nodeIds;
    }

    @Override
    public int closeSessionsForManager(String managerUuid) {
        Node node = this.currentNodes.get(managerUuid);
        int modificationCount = 0;
        if (node != null) {
            Iterator i = node.iterateSessions();
            while (i.hasNext()) {
                Session session = (Session)i.next();
                if (session.getClosed() != null) continue;
                session.setClosed(new Timestamp(System.currentTimeMillis()));
                ++modificationCount;
            }
        }
        return modificationCount;
    }

    @Override
    public void setManagerDown(String managerUuid) {
        Node node = this.currentNodes.get(managerUuid);
        if (node != null) {
            node.setDown(new Timestamp(System.currentTimeMillis()));
        }
    }

    @Override
    public Node addManager(String managerUuid, String proxyString) {
        Node node = new Node();
        node.setId(Long.valueOf(this.currentNodeId.getAndDecrement()));
        node.setConn(proxyString);
        node.setUuid(managerUuid);
        node.setUp(new Timestamp(System.currentTimeMillis()));
        this.currentNodes.put(managerUuid, node);
        return node;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return false;
    }
}

