/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectDatasetLinkI;
import omero.model.ProjectI;
import omero.rtypes;

public class ProjectData
extends DataObject {
    public static final String NAME = "ome.model.containers.Project_name";
    public static final String DESCRIPTION = "ome.model.containers.Project_description";
    public static final String DATASET_LINKS = "ome.model.containers.Project_datasetLinks";
    private Set<DatasetData> datasets;

    public ProjectData() {
        this.setDirty(true);
        this.setValue(new ProjectI());
    }

    public ProjectData(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(project);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asProject().setName(rtypes.rstring(name));
    }

    public String getName() {
        RString n = this.asProject().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asProject().setDescription(rtypes.rstring(description));
    }

    public String getDescription() {
        RString d = this.asProject().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asProject().getAnnotationLinksCountPerOwner();
    }

    public Set<DatasetData> getDatasets() {
        if (this.datasets == null && this.asProject().sizeOfDatasetLinks() >= 0) {
            this.datasets = new HashSet<DatasetData>();
            List<ProjectDatasetLink> links = this.asProject().copyDatasetLinks();
            for (ProjectDatasetLink link : links) {
                this.datasets.add(new DatasetData(link.getChild()));
            }
        }
        return this.datasets == null ? null : new HashSet<DatasetData>(this.datasets);
    }

    public void setDatasets(Set<DatasetData> newValue) {
        this.asProject().clearDatasetLinks();
        if (newValue == null) {
            return;
        }
        Iterator<DatasetData> i = newValue.iterator();
        Project p = this.asProject();
        while (i.hasNext()) {
            ProjectDatasetLinkI link = new ProjectDatasetLinkI();
            link.link((Project)p.proxy(), i.next().asDataset());
            p.addProjectDatasetLink(link);
        }
        this.datasets = null;
        this.datasets = this.getDatasets();
    }
}

