/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RDouble;
import omero.RDoubleHolder;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.RStringHolder;
import omero.model.Annotation;
import omero.model.AnnotationHolder;
import omero.model.Details;
import omero.model.DetectorAnnotationLink;
import omero.model.DetectorAnnotationLinkHolder;
import omero.model.DetectorAnnotationLinksSeqHelper;
import omero.model.DetectorHolder;
import omero.model.DetectorLinkedAnnotationSeqHelper;
import omero.model.DetectorType;
import omero.model.DetectorTypeHolder;
import omero.model.ElectricPotential;
import omero.model.ElectricPotentialHolder;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.InstrumentHolder;
import omero.model._DetectorOperations;
import omero.model._DetectorOperationsNC;
import omero.sys.CountMapHelper;

public abstract class Detector
extends IObject
implements _DetectorOperations,
_DetectorOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::Detector", "::omero::model::IObject"};
    private static final String[] __all = new String[]{"addAllDetectorAnnotationLinkSet", "addDetectorAnnotationLink", "addDetectorAnnotationLinkToBoth", "clearAnnotationLinks", "copyAnnotationLinks", "findDetectorAnnotationLink", "getAmplificationGain", "getAnnotationLinksCountPerOwner", "getDetails", "getGain", "getId", "getInstrument", "getLotNumber", "getManufacturer", "getModel", "getOffsetValue", "getSerialNumber", "getType", "getVersion", "getVoltage", "getZoom", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkedAnnotationList", "proxy", "reloadAnnotationLinks", "removeAllDetectorAnnotationLinkSet", "removeDetectorAnnotationLink", "removeDetectorAnnotationLinkFromBoth", "setAmplificationGain", "setGain", "setId", "setInstrument", "setLotNumber", "setManufacturer", "setModel", "setOffsetValue", "setSerialNumber", "setType", "setVersion", "setVoltage", "setZoom", "shallowCopy", "sizeOfAnnotationLinks", "unlinkAnnotation", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails"};
    protected RInt version;
    protected RString manufacturer;
    protected RString model;
    protected RString lotNumber;
    protected RString serialNumber;
    protected ElectricPotential voltage;
    protected RDouble gain;
    protected RDouble offsetValue;
    protected RDouble zoom;
    protected RDouble amplificationGain;
    protected DetectorType type;
    protected Instrument instrument;
    protected List<DetectorAnnotationLink> annotationLinksSeq;
    protected boolean annotationLinksLoaded;
    protected Map<Long, Long> annotationLinksCountPerOwner;
    public static final long serialVersionUID = 5790511166543290818L;

    public Detector() {
    }

    public Detector(RLong id, Details details, boolean loaded, RInt version, RString manufacturer, RString model, RString lotNumber, RString serialNumber, ElectricPotential voltage, RDouble gain, RDouble offsetValue, RDouble zoom, RDouble amplificationGain, DetectorType type, Instrument instrument, List<DetectorAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner) {
        super(id, details, loaded);
        this.version = version;
        this.manufacturer = manufacturer;
        this.model = model;
        this.lotNumber = lotNumber;
        this.serialNumber = serialNumber;
        this.voltage = voltage;
        this.gain = gain;
        this.offsetValue = offsetValue;
        this.zoom = zoom;
        this.amplificationGain = amplificationGain;
        this.type = type;
        this.instrument = instrument;
        this.annotationLinksSeq = annotationLinksSeq;
        this.annotationLinksLoaded = annotationLinksLoaded;
        this.annotationLinksCountPerOwner = annotationLinksCountPerOwner;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[1];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[1];
    }

    public static String ice_staticId() {
        return __ids[1];
    }

    @Override
    public final void addAllDetectorAnnotationLinkSet(List<DetectorAnnotationLink> targets) {
        this.addAllDetectorAnnotationLinkSet(targets, null);
    }

    @Override
    public final void addDetectorAnnotationLink(DetectorAnnotationLink target) {
        this.addDetectorAnnotationLink(target, null);
    }

    @Override
    public final void addDetectorAnnotationLinkToBoth(DetectorAnnotationLink link, boolean bothSides) {
        this.addDetectorAnnotationLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void clearAnnotationLinks() {
        this.clearAnnotationLinks(null);
    }

    @Override
    public final List<DetectorAnnotationLink> copyAnnotationLinks() {
        return this.copyAnnotationLinks(null);
    }

    @Override
    public final List<DetectorAnnotationLink> findDetectorAnnotationLink(Annotation removal) {
        return this.findDetectorAnnotationLink(removal, null);
    }

    @Override
    public final RDouble getAmplificationGain() {
        return this.getAmplificationGain(null);
    }

    @Override
    public final Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.getAnnotationLinksCountPerOwner(null);
    }

    @Override
    public final RDouble getGain() {
        return this.getGain(null);
    }

    @Override
    public final Instrument getInstrument() {
        return this.getInstrument(null);
    }

    @Override
    public final RString getLotNumber() {
        return this.getLotNumber(null);
    }

    @Override
    public final RString getManufacturer() {
        return this.getManufacturer(null);
    }

    @Override
    public final RString getModel() {
        return this.getModel(null);
    }

    @Override
    public final RDouble getOffsetValue() {
        return this.getOffsetValue(null);
    }

    @Override
    public final RString getSerialNumber() {
        return this.getSerialNumber(null);
    }

    @Override
    public final DetectorType getType() {
        return this.getType(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final ElectricPotential getVoltage() {
        return this.getVoltage(null);
    }

    @Override
    public final RDouble getZoom() {
        return this.getZoom(null);
    }

    @Override
    public final DetectorAnnotationLink linkAnnotation(Annotation addition) {
        return this.linkAnnotation(addition, null);
    }

    @Override
    public final List<Annotation> linkedAnnotationList() {
        return this.linkedAnnotationList(null);
    }

    @Override
    public final void reloadAnnotationLinks(Detector toCopy) {
        this.reloadAnnotationLinks(toCopy, null);
    }

    @Override
    public final void removeAllDetectorAnnotationLinkSet(List<DetectorAnnotationLink> targets) {
        this.removeAllDetectorAnnotationLinkSet(targets, null);
    }

    @Override
    public final void removeDetectorAnnotationLink(DetectorAnnotationLink theTarget) {
        this.removeDetectorAnnotationLink(theTarget, null);
    }

    @Override
    public final void removeDetectorAnnotationLinkFromBoth(DetectorAnnotationLink link, boolean bothSides) {
        this.removeDetectorAnnotationLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void setAmplificationGain(RDouble theAmplificationGain) {
        this.setAmplificationGain(theAmplificationGain, null);
    }

    @Override
    public final void setGain(RDouble theGain) {
        this.setGain(theGain, null);
    }

    @Override
    public final void setInstrument(Instrument theInstrument) {
        this.setInstrument(theInstrument, null);
    }

    @Override
    public final void setLotNumber(RString theLotNumber) {
        this.setLotNumber(theLotNumber, null);
    }

    @Override
    public final void setManufacturer(RString theManufacturer) {
        this.setManufacturer(theManufacturer, null);
    }

    @Override
    public final void setModel(RString theModel) {
        this.setModel(theModel, null);
    }

    @Override
    public final void setOffsetValue(RDouble theOffsetValue) {
        this.setOffsetValue(theOffsetValue, null);
    }

    @Override
    public final void setSerialNumber(RString theSerialNumber) {
        this.setSerialNumber(theSerialNumber, null);
    }

    @Override
    public final void setType(DetectorType theType) {
        this.setType(theType, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final void setVoltage(ElectricPotential theVoltage) {
        this.setVoltage(theVoltage, null);
    }

    @Override
    public final void setZoom(RDouble theZoom) {
        this.setZoom(theZoom, null);
    }

    @Override
    public final int sizeOfAnnotationLinks() {
        return this.sizeOfAnnotationLinks(null);
    }

    @Override
    public final void unlinkAnnotation(Annotation removal) {
        this.unlinkAnnotation(removal, null);
    }

    @Override
    public final void unloadAnnotationLinks() {
        this.unloadAnnotationLinks(null);
    }

    public static DispatchStatus ___getVersion(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getVersion(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theVersion);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVersion((RInt)theVersion.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getManufacturer(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getManufacturer(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setManufacturer(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theManufacturer = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theManufacturer);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setManufacturer((RString)theManufacturer.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getModel(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getModel(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setModel(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theModel = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theModel);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setModel((RString)theModel.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLotNumber(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getLotNumber(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLotNumber(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theLotNumber = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theLotNumber);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setLotNumber((RString)theLotNumber.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getSerialNumber(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RString __ret = __obj.getSerialNumber(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setSerialNumber(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RStringHolder theSerialNumber = new RStringHolder();
        __is.readObject((IceInternal.Patcher)theSerialNumber);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setSerialNumber((RString)theSerialNumber.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getVoltage(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        ElectricPotential __ret = __obj.getVoltage(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVoltage(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        ElectricPotentialHolder theVoltage = new ElectricPotentialHolder();
        __is.readObject((IceInternal.Patcher)theVoltage);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVoltage((ElectricPotential)theVoltage.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getGain(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RDouble __ret = __obj.getGain(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setGain(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RDoubleHolder theGain = new RDoubleHolder();
        __is.readObject((IceInternal.Patcher)theGain);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setGain((RDouble)theGain.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getOffsetValue(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RDouble __ret = __obj.getOffsetValue(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setOffsetValue(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RDoubleHolder theOffsetValue = new RDoubleHolder();
        __is.readObject((IceInternal.Patcher)theOffsetValue);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setOffsetValue((RDouble)theOffsetValue.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getZoom(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RDouble __ret = __obj.getZoom(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setZoom(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RDoubleHolder theZoom = new RDoubleHolder();
        __is.readObject((IceInternal.Patcher)theZoom);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setZoom((RDouble)theZoom.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAmplificationGain(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RDouble __ret = __obj.getAmplificationGain(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setAmplificationGain(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RDoubleHolder theAmplificationGain = new RDoubleHolder();
        __is.readObject((IceInternal.Patcher)theAmplificationGain);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setAmplificationGain((RDouble)theAmplificationGain.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getType(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        DetectorType __ret = __obj.getType(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setType(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorTypeHolder theType = new DetectorTypeHolder();
        __is.readObject((IceInternal.Patcher)theType);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setType((DetectorType)theType.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getInstrument(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Instrument __ret = __obj.getInstrument(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setInstrument(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder theInstrument = new InstrumentHolder();
        __is.readObject((IceInternal.Patcher)theInstrument);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setInstrument((Instrument)theInstrument.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadAnnotationLinks(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.unloadAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfAnnotationLinks(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyAnnotationLinks(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.copyAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        DetectorAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDetectorAnnotationLink(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorAnnotationLinkHolder target = new DetectorAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addDetectorAnnotationLink((DetectorAnnotationLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllDetectorAnnotationLinkSet(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<DetectorAnnotationLink> targets = DetectorAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllDetectorAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDetectorAnnotationLink(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorAnnotationLinkHolder theTarget = new DetectorAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeDetectorAnnotationLink((DetectorAnnotationLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllDetectorAnnotationLinkSet(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        List<DetectorAnnotationLink> targets = DetectorAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllDetectorAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearAnnotationLinks(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        __obj.clearAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadAnnotationLinks(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorHolder toCopy = new DetectorHolder();
        __is.readObject((IceInternal.Patcher)toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadAnnotationLinks((Detector)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAnnotationLinksCountPerOwner(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Map __ret = __obj.getAnnotationLinksCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkAnnotation(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder addition = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        DetectorAnnotationLink __ret = __obj.linkAnnotation((Annotation)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDetectorAnnotationLinkToBoth(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorAnnotationLinkHolder link = new DetectorAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addDetectorAnnotationLinkToBoth((DetectorAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findDetectorAnnotationLink(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List __ret = __obj.findDetectorAnnotationLink((Annotation)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        DetectorAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkAnnotation(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject((IceInternal.Patcher)removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkAnnotation((Annotation)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDetectorAnnotationLinkFromBoth(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorAnnotationLinkHolder link = new DetectorAnnotationLinkHolder();
        __is.readObject((IceInternal.Patcher)link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeDetectorAnnotationLinkFromBoth((DetectorAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedAnnotationList(Detector __obj, Incoming __inS, Current __current) {
        Detector.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        List __ret = __obj.linkedAnnotationList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        DetectorLinkedAnnotationSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return Detector.___addAllDetectorAnnotationLinkSet(this, in, __current);
            }
            case 1: {
                return Detector.___addDetectorAnnotationLink(this, in, __current);
            }
            case 2: {
                return Detector.___addDetectorAnnotationLinkToBoth(this, in, __current);
            }
            case 3: {
                return Detector.___clearAnnotationLinks(this, in, __current);
            }
            case 4: {
                return Detector.___copyAnnotationLinks(this, in, __current);
            }
            case 5: {
                return Detector.___findDetectorAnnotationLink(this, in, __current);
            }
            case 6: {
                return Detector.___getAmplificationGain(this, in, __current);
            }
            case 7: {
                return Detector.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 8: {
                return IObject.___getDetails(this, in, __current);
            }
            case 9: {
                return Detector.___getGain(this, in, __current);
            }
            case 10: {
                return IObject.___getId(this, in, __current);
            }
            case 11: {
                return Detector.___getInstrument(this, in, __current);
            }
            case 12: {
                return Detector.___getLotNumber(this, in, __current);
            }
            case 13: {
                return Detector.___getManufacturer(this, in, __current);
            }
            case 14: {
                return Detector.___getModel(this, in, __current);
            }
            case 15: {
                return Detector.___getOffsetValue(this, in, __current);
            }
            case 16: {
                return Detector.___getSerialNumber(this, in, __current);
            }
            case 17: {
                return Detector.___getType(this, in, __current);
            }
            case 18: {
                return Detector.___getVersion(this, in, __current);
            }
            case 19: {
                return Detector.___getVoltage(this, in, __current);
            }
            case 20: {
                return Detector.___getZoom(this, in, __current);
            }
            case 21: {
                return Detector.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 22: {
                return Detector.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 23: {
                return Detector.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 24: {
                return Detector.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 25: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 26: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 27: {
                return IObject.___isLink(this, in, __current);
            }
            case 28: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 29: {
                return IObject.___isMutable(this, in, __current);
            }
            case 30: {
                return Detector.___linkAnnotation(this, in, __current);
            }
            case 31: {
                return Detector.___linkedAnnotationList(this, in, __current);
            }
            case 32: {
                return IObject.___proxy(this, in, __current);
            }
            case 33: {
                return Detector.___reloadAnnotationLinks(this, in, __current);
            }
            case 34: {
                return Detector.___removeAllDetectorAnnotationLinkSet(this, in, __current);
            }
            case 35: {
                return Detector.___removeDetectorAnnotationLink(this, in, __current);
            }
            case 36: {
                return Detector.___removeDetectorAnnotationLinkFromBoth(this, in, __current);
            }
            case 37: {
                return Detector.___setAmplificationGain(this, in, __current);
            }
            case 38: {
                return Detector.___setGain(this, in, __current);
            }
            case 39: {
                return IObject.___setId(this, in, __current);
            }
            case 40: {
                return Detector.___setInstrument(this, in, __current);
            }
            case 41: {
                return Detector.___setLotNumber(this, in, __current);
            }
            case 42: {
                return Detector.___setManufacturer(this, in, __current);
            }
            case 43: {
                return Detector.___setModel(this, in, __current);
            }
            case 44: {
                return Detector.___setOffsetValue(this, in, __current);
            }
            case 45: {
                return Detector.___setSerialNumber(this, in, __current);
            }
            case 46: {
                return Detector.___setType(this, in, __current);
            }
            case 47: {
                return Detector.___setVersion(this, in, __current);
            }
            case 48: {
                return Detector.___setVoltage(this, in, __current);
            }
            case 49: {
                return Detector.___setZoom(this, in, __current);
            }
            case 50: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 51: {
                return Detector.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 52: {
                return Detector.___unlinkAnnotation(this, in, __current);
            }
            case 53: {
                return IObject.___unload(this, in, __current);
            }
            case 54: {
                return Detector.___unloadAnnotationLinks(this, in, __current);
            }
            case 55: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 56: {
                return IObject.___unloadDetails(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(Detector.ice_staticId(), -1, false);
        __os.writeObject((Ice.Object)this.version);
        __os.writeObject((Ice.Object)this.manufacturer);
        __os.writeObject((Ice.Object)this.model);
        __os.writeObject((Ice.Object)this.lotNumber);
        __os.writeObject((Ice.Object)this.serialNumber);
        __os.writeObject((Ice.Object)this.voltage);
        __os.writeObject((Ice.Object)this.gain);
        __os.writeObject((Ice.Object)this.offsetValue);
        __os.writeObject((Ice.Object)this.zoom);
        __os.writeObject((Ice.Object)this.amplificationGain);
        __os.writeObject((Ice.Object)this.type);
        __os.writeObject((Ice.Object)this.instrument);
        DetectorAnnotationLinksSeqHelper.write(__os, this.annotationLinksSeq);
        __os.writeBool(this.annotationLinksLoaded);
        CountMapHelper.write(__os, this.annotationLinksCountPerOwner);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(0));
        __is.readObject((IceInternal.Patcher)new Patcher(1));
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.readObject((IceInternal.Patcher)new Patcher(5));
        __is.readObject((IceInternal.Patcher)new Patcher(6));
        __is.readObject((IceInternal.Patcher)new Patcher(7));
        __is.readObject((IceInternal.Patcher)new Patcher(8));
        __is.readObject((IceInternal.Patcher)new Patcher(9));
        __is.readObject((IceInternal.Patcher)new Patcher(10));
        __is.readObject((IceInternal.Patcher)new Patcher(11));
        this.annotationLinksSeq = DetectorAnnotationLinksSeqHelper.read(__is);
        this.annotationLinksLoaded = __is.readBool();
        this.annotationLinksCountPerOwner = CountMapHelper.read(__is);
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public Detector clone() {
        return (Detector)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        Detector.this.version = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Detector.this.manufacturer = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 2: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Detector.this.model = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 3: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Detector.this.lotNumber = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 4: {
                    this.__typeId = "::omero::RString";
                    if (v == null || v instanceof RString) {
                        Detector.this.serialNumber = (RString)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 5: {
                    this.__typeId = "::omero::model::ElectricPotential";
                    if (v == null || v instanceof ElectricPotential) {
                        Detector.this.voltage = (ElectricPotential)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 6: {
                    this.__typeId = "::omero::RDouble";
                    if (v == null || v instanceof RDouble) {
                        Detector.this.gain = (RDouble)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 7: {
                    this.__typeId = "::omero::RDouble";
                    if (v == null || v instanceof RDouble) {
                        Detector.this.offsetValue = (RDouble)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 8: {
                    this.__typeId = "::omero::RDouble";
                    if (v == null || v instanceof RDouble) {
                        Detector.this.zoom = (RDouble)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 9: {
                    this.__typeId = "::omero::RDouble";
                    if (v == null || v instanceof RDouble) {
                        Detector.this.amplificationGain = (RDouble)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 10: {
                    this.__typeId = "::omero::model::DetectorType";
                    if (v == null || v instanceof DetectorType) {
                        Detector.this.type = (DetectorType)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 11: {
                    this.__typeId = "::omero::model::Instrument";
                    if (v == null || v instanceof Instrument) {
                        Detector.this.instrument = (Instrument)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                }
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

