/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5BooleanReader;
import ch.systemsx.cisd.hdf5.HDF5ByteReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundReader;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.HDF5DoubleReader;
import ch.systemsx.cisd.hdf5.HDF5EnumReader;
import ch.systemsx.cisd.hdf5.HDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.HDF5FloatReader;
import ch.systemsx.cisd.hdf5.HDF5IntReader;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.HDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.HDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.HDF5ShortReader;
import ch.systemsx.cisd.hdf5.HDF5StringReader;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedByteReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedIntReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedLongReader;
import ch.systemsx.cisd.hdf5.HDF5UnsignedShortReader;
import ch.systemsx.cisd.hdf5.IHDF5BooleanReader;
import ch.systemsx.cisd.hdf5.IHDF5ByteReader;
import ch.systemsx.cisd.hdf5.IHDF5CompoundReader;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.IHDF5DoubleReader;
import ch.systemsx.cisd.hdf5.IHDF5EnumReader;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadOnlyHandler;
import ch.systemsx.cisd.hdf5.IHDF5FloatReader;
import ch.systemsx.cisd.hdf5.IHDF5IntReader;
import ch.systemsx.cisd.hdf5.IHDF5LongReader;
import ch.systemsx.cisd.hdf5.IHDF5ObjectReadOnlyInfoProviderHandler;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.IHDF5ShortReader;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationReader;
import hdf.hdf5lib.exceptions.HDF5DatatypeInterfaceException;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.BitSet;
import java.util.Date;
import java.util.List;

class HDF5Reader
implements IHDF5Reader {
    private final HDF5BaseReader baseReader;
    private final IHDF5FileLevelReadOnlyHandler fileHandler;
    private final IHDF5ObjectReadOnlyInfoProviderHandler objectHandler;
    private final IHDF5ByteReader byteReader;
    private final IHDF5ByteReader ubyteReader;
    private final IHDF5ShortReader shortReader;
    private final IHDF5ShortReader ushortReader;
    private final IHDF5IntReader intReader;
    private final IHDF5IntReader uintReader;
    protected final IHDF5LongReader longReader;
    private final IHDF5LongReader ulongReader;
    private final IHDF5FloatReader floatReader;
    private final IHDF5DoubleReader doubleReader;
    private final IHDF5BooleanReader booleanReader;
    private final IHDF5StringReader stringReader;
    private final IHDF5EnumReader enumReader;
    private final IHDF5CompoundReader compoundReader;
    private final IHDF5DateTimeReader dateTimeReader;
    private final HDF5TimeDurationReader timeDurationReader;
    private final IHDF5ReferenceReader referenceReader;
    private final IHDF5OpaqueReader opaqueReader;

    HDF5Reader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
        baseReader.setMyReader(this);
        this.fileHandler = new HDF5FileLevelReadOnlyHandler(baseReader);
        this.objectHandler = new HDF5ObjectReadOnlyInfoProviderHandler(baseReader);
        this.byteReader = new HDF5ByteReader(baseReader);
        this.ubyteReader = new HDF5UnsignedByteReader(baseReader);
        this.shortReader = new HDF5ShortReader(baseReader);
        this.ushortReader = new HDF5UnsignedShortReader(baseReader);
        this.intReader = new HDF5IntReader(baseReader);
        this.uintReader = new HDF5UnsignedIntReader(baseReader);
        this.longReader = new HDF5LongReader(baseReader);
        this.ulongReader = new HDF5UnsignedLongReader(baseReader);
        this.floatReader = new HDF5FloatReader(baseReader);
        this.doubleReader = new HDF5DoubleReader(baseReader);
        this.booleanReader = new HDF5BooleanReader(baseReader);
        this.stringReader = new HDF5StringReader(baseReader);
        this.enumReader = new HDF5EnumReader(baseReader);
        this.compoundReader = new HDF5CompoundReader(baseReader, this.enumReader);
        this.dateTimeReader = new HDF5DateTimeReader(baseReader, (HDF5LongReader)this.longReader);
        this.timeDurationReader = new HDF5TimeDurationReader(baseReader, (HDF5LongReader)this.longReader);
        this.referenceReader = new HDF5ReferenceReader(baseReader);
        this.opaqueReader = new HDF5OpaqueReader(baseReader);
    }

    void checkOpen() {
        this.baseReader.checkOpen();
    }

    long getFileId() {
        return this.baseReader.fileId;
    }

    @Override
    public IHDF5FileLevelReadOnlyHandler file() {
        return this.fileHandler;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() {
        this.baseReader.close();
    }

    @Override
    public IHDF5ObjectReadOnlyInfoProviderHandler object() {
        return this.objectHandler;
    }

    @Override
    public boolean exists(String objectPath) {
        return this.objectHandler.exists(objectPath);
    }

    @Override
    public boolean isGroup(String objectPath) {
        return this.objectHandler.isGroup(objectPath);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.objectHandler.getDataSetInformation(dataSetPath);
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        return this.objectHandler.getGroupMembers(groupPath);
    }

    @Override
    public IHDF5OpaqueReader opaque() {
        return this.opaqueReader;
    }

    @Override
    public byte[] readAsByteArray(String objectPath) {
        return this.opaqueReader.readArray(objectPath);
    }

    @Override
    public IHDF5BooleanReader bool() {
        return this.booleanReader;
    }

    @Override
    public BitSet readBitField(String objectPath) throws HDF5DatatypeInterfaceException {
        return this.booleanReader.readBitField(objectPath);
    }

    @Override
    public boolean readBoolean(String objectPath) throws HDF5JavaException {
        return this.booleanReader.read(objectPath);
    }

    @Override
    public IHDF5DateTimeReader time() {
        return this.dateTimeReader;
    }

    @Override
    public IHDF5TimeDurationReader duration() {
        return this.timeDurationReader;
    }

    @Override
    public Date readDate(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDate(objectPath);
    }

    @Override
    public Date[] readDateArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDateArray(objectPath);
    }

    @Override
    public HDF5TimeDuration readTimeDuration(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.read(objectPath);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArray(String objectPath) throws HDF5JavaException {
        return this.timeDurationReader.readArray(objectPath);
    }

    @Override
    public IHDF5ReferenceReader reference() {
        return this.referenceReader;
    }

    @Override
    public IHDF5StringReader string() {
        return this.stringReader;
    }

    @Override
    public String readString(String objectPath) throws HDF5JavaException {
        return this.stringReader.read(objectPath);
    }

    @Override
    public String[] readStringArray(String objectPath) throws HDF5JavaException {
        return this.stringReader.readArray(objectPath);
    }

    @Override
    public IHDF5EnumReader enumeration() {
        return this.enumReader;
    }

    @Override
    public <T extends Enum<T>> T readEnum(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.read(objectPath, enumClass);
    }

    @Override
    public <T extends Enum<T>> T[] readEnumArray(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath).toEnumArray(enumClass);
    }

    @Override
    public String[] readEnumArrayAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath).toStringArray();
    }

    @Override
    public String readEnumAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readAsString(objectPath);
    }

    @Override
    public IHDF5CompoundReader compound() {
        return this.compoundReader;
    }

    @Override
    public <T> T readCompound(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, pojoClass);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, pojoClass);
    }

    @Override
    public double readDouble(String objectPath) {
        return this.doubleReader.read(objectPath);
    }

    @Override
    public double[] readDoubleArray(String objectPath) {
        return this.doubleReader.readArray(objectPath);
    }

    @Override
    public double[][] readDoubleMatrix(String objectPath) throws HDF5JavaException {
        return this.doubleReader.readMatrix(objectPath);
    }

    @Override
    public float readFloat(String objectPath) {
        return this.floatReader.read(objectPath);
    }

    @Override
    public float[] readFloatArray(String objectPath) {
        return this.floatReader.readArray(objectPath);
    }

    @Override
    public float[][] readFloatMatrix(String objectPath) throws HDF5JavaException {
        return this.floatReader.readMatrix(objectPath);
    }

    @Override
    public int readInt(String objectPath) {
        return this.intReader.read(objectPath);
    }

    @Override
    public int[] readIntArray(String objectPath) {
        return this.intReader.readArray(objectPath);
    }

    @Override
    public int[][] readIntMatrix(String objectPath) throws HDF5JavaException {
        return this.intReader.readMatrix(objectPath);
    }

    @Override
    public long readLong(String objectPath) {
        return this.longReader.read(objectPath);
    }

    @Override
    public long[] readLongArray(String objectPath) {
        return this.longReader.readArray(objectPath);
    }

    @Override
    public long[][] readLongMatrix(String objectPath) throws HDF5JavaException {
        return this.longReader.readMatrix(objectPath);
    }

    @Override
    public IHDF5ByteReader int8() {
        return this.byteReader;
    }

    @Override
    public IHDF5ByteReader uint8() {
        return this.ubyteReader;
    }

    @Override
    public IHDF5ShortReader int16() {
        return this.shortReader;
    }

    @Override
    public IHDF5ShortReader uint16() {
        return this.ushortReader;
    }

    @Override
    public IHDF5IntReader int32() {
        return this.intReader;
    }

    @Override
    public IHDF5IntReader uint32() {
        return this.uintReader;
    }

    @Override
    public IHDF5LongReader int64() {
        return this.longReader;
    }

    @Override
    public IHDF5LongReader uint64() {
        return this.ulongReader;
    }

    @Override
    public IHDF5FloatReader float32() {
        return this.floatReader;
    }

    @Override
    public IHDF5DoubleReader float64() {
        return this.doubleReader;
    }
}

