/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.base.Joiner;
import com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.AuthenticationException;
import ome.conditions.InternalException;
import ome.conditions.RemovedSessionException;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionException;
import ome.conditions.SessionTimeoutException;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.CommentAnnotation;
import ome.model.annotations.TextAnnotation;
import ome.model.enums.AdminPrivilege;
import ome.model.enums.EventType;
import ome.model.internal.Details;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.Session;
import ome.model.meta.Share;
import ome.parameters.Parameters;
import ome.security.basic.LightAdminPrivileges;
import ome.security.basic.PrincipalHolder;
import ome.services.messages.CreateSessionMessage;
import ome.services.messages.DestroySessionMessage;
import ome.services.sessions.InternalSessionContext;
import ome.services.sessions.SessionCallback;
import ome.services.sessions.SessionContext;
import ome.services.sessions.SessionContextImpl;
import ome.services.sessions.SessionManager;
import ome.services.sessions.SessionProvider;
import ome.services.sessions.events.ChangeSecurityContextEvent;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.services.sessions.state.SessionCache;
import ome.services.sessions.stats.CounterFactory;
import ome.services.sessions.stats.SessionStats;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.messages.InternalMessage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.transaction.annotation.Transactional;

public class SessionManagerImpl
implements SessionManager,
SessionCache.StaleCacheListener,
ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    public static final String GROUP_SUDO_NS = "openmicroscopy.org/security/group-sudo";
    private static final Logger log = LoggerFactory.getLogger(SessionManagerImpl.class);
    private String internal_uuid = UUID.randomUUID().toString();
    protected OmeroContext context;
    protected Roles roles;
    protected LightAdminPrivileges adminPrivileges;
    protected SessionCache cache;
    protected Executor executor;
    protected long defaultTimeToIdle;
    protected long maxUserTimeToIdle;
    protected long defaultTimeToLive;
    protected long maxUserTimeToLive;
    protected PrincipalHolder principalHolder;
    protected CounterFactory factory;
    protected boolean readOnly = false;
    protected SessionProvider sessionProvider;
    protected Principal asroot;
    protected SessionContext internalSession;
    static String INPUT_ENVIRONMENT = "InputEnvironment";
    static String OUTPUT_ENVIRONMENT = "OutputEnvironment";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (OmeroContext)applicationContext;
    }

    public void setUuid(String uuid) {
        this.internal_uuid = uuid;
    }

    public void setSessionCache(SessionCache sessionCache) {
        this.cache = sessionCache;
        this.cache.setStaleCacheListener(this);
    }

    public void setRoles(Roles securityRoles) {
        this.roles = securityRoles;
    }

    public void setAdminPrivileges(LightAdminPrivileges adminPrivileges) {
        this.adminPrivileges = adminPrivileges;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDefaultTimeToIdle(long defaultTimeToIdle) {
        this.defaultTimeToIdle = defaultTimeToIdle;
    }

    public void setMaxUserTimeToIdle(long maxUserTimeToIdle) {
        this.maxUserTimeToIdle = maxUserTimeToIdle;
    }

    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public void setMaxUserTimeToLive(long maxUserTimeToLive) {
        this.maxUserTimeToLive = maxUserTimeToLive;
    }

    public void setPrincipalHolder(PrincipalHolder principal) {
        this.principalHolder = principal;
    }

    public void setCounterFactory(CounterFactory factory) {
        this.factory = factory;
    }

    public void setReadOnly(ReadOnlyStatus readOnly) {
        this.readOnly = readOnly.isReadOnlyDb();
    }

    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void init() {
        try {
            this.asroot = new Principal(this.internal_uuid, "system", "Sessions");
            Session session = new Session();
            this.define(session, this.internal_uuid, "Session Manager internal", System.currentTimeMillis(), Long.MAX_VALUE, 0L, "Sessions", "Internal", null);
            session = this.sessionProvider.executeInternalSession(this.internal_uuid, session);
            this.internalSession = new InternalSessionContext(session, LightAdminPrivileges.getAllPrivileges(), this.roles);
            this.cache.putSession(this.internal_uuid, this.internalSession);
        }
        catch (UncategorizedSQLException uncat) {
            log.warn("Assuming that this is read-only");
        }
        catch (DataAccessException dataAccess) {
            throw new RuntimeException("          =====================================================\nData access exception: Did you create your database? \n=====================================================\n", dataAccess);
        }
    }

    protected void define(Session s, String uuid, String message, long started, SessionManager.CreationRequest req) {
        Long idle = req.timeToIdle == null ? this.defaultTimeToIdle : req.timeToIdle;
        Long live = req.timeToLive == null ? this.defaultTimeToLive : req.timeToLive;
        if (req.groupsLed != null) {
            CommentAnnotation ca = new CommentAnnotation();
            ca.setNs(GROUP_SUDO_NS);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < req.groupsLed.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(req.groupsLed.get(i));
            }
            ca.setTextValue(sb.toString());
            s.linkAnnotation((Annotation)ca);
        }
        this.define(s, uuid, message, started, idle, live, req.principal.getEventType(), req.agent, req.ip);
    }

    protected void define(Session s, String uuid, String message, long started, long idle, long live, String eventType, String agent, String ip) {
        s.getDetails().setPermissions(Permissions.PRIVATE);
        s.setUuid(uuid);
        s.setMessage(message);
        s.setStarted(new Timestamp(started));
        s.setTimeToIdle(Long.valueOf(idle));
        s.setTimeToLive(Long.valueOf(live));
        s.setDefaultEventType(eventType);
        s.setUserAgent(agent);
        s.setUserIP(ip);
    }

    @Override
    public Session createFromRequest(SessionManager.CreationRequest request) {
        if (request.credentials != null) {
            boolean ok;
            try {
                SessionContext context = this.cache.getSessionContext(request.credentials);
                if (context != null) {
                    context.count().increment();
                    return context.getSession();
                }
            }
            catch (SessionException context) {
                // empty catch block
            }
            boolean bl = ok = request.principal == null ? false : this.executeCheckPassword(request.principal, request.credentials);
            if (!ok) {
                log.warn("Failed to authenticate: " + request.principal);
                throw new AuthenticationException("Authentication exception.");
            }
        }
        Session session = new Session();
        this.define(session, UUID.randomUUID().toString(), "Initial message.", System.currentTimeMillis(), request);
        return this.createSession(request, session);
    }

    @Override
    public Session createWithAgent(Principal _principal, String credentials, String agent, String ip) {
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = _principal;
        req.credentials = credentials;
        req.agent = agent;
        req.ip = ip;
        return this.createFromRequest(req);
    }

    @Override
    public Session createWithAgent(Principal principal, String agent, String ip) {
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = principal;
        req.agent = agent;
        req.ip = ip;
        return this.createFromRequest(req);
    }

    @Override
    public Share createShare(Principal principal, boolean enabled, long timeToLive, String eventType, String description, long groupId) {
        Share share = this.newShare();
        this.define((Session)share, UUID.randomUUID().toString(), description, System.currentTimeMillis(), this.defaultTimeToIdle, timeToLive, eventType, "Share", null);
        share.setGroup(new ExperimenterGroup(Long.valueOf(groupId), false));
        share.setActive(Boolean.valueOf(enabled));
        share.setData(new byte[0]);
        share.setItemCount(Long.valueOf(0L));
        SessionManager.CreationRequest req = new SessionManager.CreationRequest();
        req.principal = principal;
        return (Share)this.createSession(req, (Session)share);
    }

    private Session createSession(final SessionManager.CreationRequest req, final Session oldsession) {
        Principal principal = req.principal;
        if (this.internal_uuid != null && this.internal_uuid.equals(principal.getName())) {
            throw new AuthenticationException("to create a session one may not use the internal UUID as the principal's user name");
        }
        try {
            SessionContext context = this.cache.getSessionContext(principal.getName());
            if (context != null) {
                context.count().increment();
                return context.getSession();
            }
        }
        catch (SessionException context) {
            // empty catch block
        }
        HashMap<String, String> sysContext = new HashMap<String, String>();
        sysContext.put("omero.group", Long.toString(this.roles.getSystemGroupId()));
        List rv = this.readOnly ? (List)this.executor.execute(sysContext, this.asroot, new Executor.SimpleWork(this, "read-only createSession", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                Principal p = SessionManagerImpl.this.validateSessionInputs(sf, req);
                oldsession.setDefaultEventType(p.getEventType());
                long userId = SessionManagerImpl.this.executeLookupUser(sf, p);
                Session s = SessionManagerImpl.this.sessionProvider.executeUpdate(sf, oldsession, SessionManagerImpl.this.internal_uuid, userId, req.sudoer);
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, s);
            }
        }) : (List)this.executor.execute(sysContext, this.asroot, new Executor.SimpleWork(this, "createSession", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                Principal p = SessionManagerImpl.this.validateSessionInputs(sf, req);
                oldsession.setDefaultEventType(p.getEventType());
                long userId = SessionManagerImpl.this.executeLookupUser(sf, p);
                Session s = SessionManagerImpl.this.sessionProvider.executeUpdate(sf, oldsession, SessionManagerImpl.this.internal_uuid, userId, req.sudoer);
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, s);
            }
        });
        if (rv == null) {
            throw new RemovedSessionException("No info in database for " + principal);
        }
        SessionContext newctx = this.createSessionContext(rv, null);
        String uuid = newctx.getCurrentSessionUuid();
        this.cache.putSession(uuid, newctx);
        try {
            this.context.publishEvent((ApplicationEvent)new CreateSessionMessage(this, uuid));
        }
        catch (RuntimeException re) {
            log.warn("Session creation cancelled by event listener", (Throwable)re);
            this.cache.removeSession(uuid);
            throw re;
        }
        newctx.count().increment();
        return newctx.getSession();
    }

    @Override
    public Session update(Session session) {
        return this.update(session, false);
    }

    @Override
    public Session update(final Session session, final boolean trusted) {
        if (session == null || !session.isLoaded() || session.getUuid() == null) {
            throw new RemovedSessionException("Cannot update; No uuid.");
        }
        String uuid = session.getUuid();
        final Details details = session.getDetails();
        final SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("Can't update; No session with uuid:" + uuid);
        }
        final Session orig = ctx.getSession();
        List list = (List)this.executor.execute(this.asroot, new Executor.SimpleWork(this, "load_for_update", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session __s, ServiceFactory sf) {
                ExperimenterGroup group;
                String defaultGroup = null;
                if (details != null && (group = details.getGroup()) != null) {
                    try {
                        Long groupId = group.getId();
                        if (groupId != null && (group = ((LocalAdmin)sf.getAdminService()).groupProxy(groupId)) != null) {
                            defaultGroup = group.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new ApiUsageException("Cannot change default group to " + group + "\n" + e.getMessage());
                    }
                }
                if (defaultGroup == null) {
                    defaultGroup = ctx.getCurrentGroupName();
                }
                Principal principal = new Principal(ctx.getCurrentUserName(), defaultGroup, ctx.getCurrentEventType());
                SessionManager.CreationRequest req = new SessionManager.CreationRequest();
                req.principal = principal;
                principal = SessionManagerImpl.this.validateSessionInputs(sf, req);
                SessionManagerImpl.this.parseAndSetDefaultType(session.getDefaultEventType(), orig);
                SessionManagerImpl.this.parseAndSetUserAgent(session.getUserAgent(), orig);
                SessionManagerImpl.this.parseAndSetTimeouts(session.getTimeToLive(), session.getTimeToIdle(), orig, trusted);
                return SessionManagerImpl.this.executeSessionContextLookup(sf, principal, orig);
            }
        });
        if (list == null) {
            log.info("removeSession on update: " + uuid);
            this.cache.removeSession(uuid);
            throw new RemovedSessionException("Database contains no info for " + uuid);
        }
        final SessionContext newctx = this.createSessionContext(list, ctx);
        final Session copy = this.copy(orig);
        this.executor.execute(this.asroot, new Executor.SimpleWork<Session>((Object)this, "update", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Session doWork(org.hibernate.Session __s, ServiceFactory sf) {
                Long sudoerId = orig.getSudoer() == null ? null : orig.getSudoer().getId();
                return SessionManagerImpl.this.sessionProvider.executeUpdate(sf, copy, SessionManagerImpl.this.internal_uuid, newctx.getCurrentUserId(), sudoerId);
            }
        });
        this.cache.putSession(uuid, newctx);
        return this.copy(orig);
    }

    protected SessionContext createSessionContext(List<?> list, SessionContext previous) {
        Experimenter exp = (Experimenter)list.get(0);
        ExperimenterGroup grp = (ExperimenterGroup)list.get(1);
        Set adminPrivileges = (Set)list.get(2);
        List memberOfGroupsIds = (List)list.get(3);
        List leaderOfGroupsIds = (List)list.get(4);
        List userRoles = (List)list.get(5);
        Principal principal = (Principal)list.get(6);
        Session session = (Session)list.get(7);
        this.parseAndSetDefaultType(principal.getEventType(), session);
        session.getDetails().setOwner(exp);
        session.getDetails().setGroup(grp);
        SessionContextImpl sessionContext = new SessionContextImpl(session, adminPrivileges, leaderOfGroupsIds, memberOfGroupsIds, userRoles, this.factory.createStats(), this.roles, previous);
        return sessionContext;
    }

    @Override
    public Session find(String uuid) {
        SessionContext sessionContext = this.cache.getSessionContext(uuid);
        this.checkIfShare(sessionContext);
        return sessionContext == null ? null : sessionContext.getSession();
    }

    @Override
    public Session findQuietly(String uuid) {
        SessionContext sessionContext = this.cache.getSessionContext(uuid, true);
        this.checkIfShare(sessionContext);
        return sessionContext == null ? null : sessionContext.getSession();
    }

    private void checkIfShare(SessionContext sessionContext) {
        if (sessionContext.getSession() instanceof Share) {
            Long id = sessionContext.getSession().getId();
            String uuid = sessionContext.getSession().getUuid();
            String prefix = String.format("Share:%s (%s)", id, uuid);
            List<Object[]> rv = this.executeProjection("select s.active, s.timeToLive, s.started from Share s where s.id = :id", new Parameters().addId(sessionContext.getSession().getId()));
            if (rv.size() != 1) {
                throw new RuntimeException(prefix + " could not be found!");
            }
            Object[] items = rv.get(0);
            Boolean active = (Boolean)items[0];
            Long timeToLive = (Long)items[1];
            Timestamp started = (Timestamp)items[2];
            if (Boolean.FALSE.equals(active)) {
                throw new SecurityViolation(prefix + " is inactive");
            }
            if (System.currentTimeMillis() - started.getTime() > timeToLive) {
                String msg = String.format("%s has expired: %s, timeToLive=%s", prefix, started, timeToLive);
                throw new SecurityViolation(msg);
            }
        }
    }

    private List<Session> findByQuery(String query, Parameters p) {
        List<Object[]> ids_uuids = this.executeProjection(query, p);
        ArrayList<Session> rv = new ArrayList<Session>();
        for (Object[] arr : ids_uuids) {
            String uuid = (String)arr[1];
            try {
                SessionContext sc = this.cache.getSessionContext(uuid);
                rv.add(sc.getSession());
            }
            catch (Exception exception) {}
        }
        return rv;
    }

    @Override
    public List<Session> findSameUser(String uuid, String ... agents) {
        Session session = this.find(uuid);
        String membershipQuery = "SELECT id FROM GroupExperimenterMap WHERE parent.id = :group AND child.id = :user";
        boolean hasAdminPrivileges = CollectionUtils.isNotEmpty(this.executeProjection("SELECT id FROM GroupExperimenterMap WHERE parent.id = :group AND child.id = :user", new Parameters().addLong("group", Long.valueOf(this.roles.getSystemGroupId())).addLong("user", session.getOwner().getId())));
        if (session.getSudoer() != null) {
            hasAdminPrivileges = hasAdminPrivileges && CollectionUtils.isNotEmpty(this.executeProjection("SELECT id FROM GroupExperimenterMap WHERE parent.id = :group AND child.id = :user", new Parameters().addLong("group", Long.valueOf(this.roles.getSystemGroupId())).addLong("user", session.getSudoer().getId())));
        }
        Set<Object> privileges = hasAdminPrivileges ? this.adminPrivileges.getSessionPrivileges(session) : Collections.emptySet();
        HashSet<String> agentSet = new HashSet<String>();
        boolean nullAgent = false;
        for (String agent : agents) {
            if (agent == null) {
                nullAgent = true;
                continue;
            }
            agentSet.add(agent);
        }
        StringBuilder sessionQuery = new StringBuilder();
        Parameters params = new Parameters();
        sessionQuery.append("SELECT id, uuid FROM Session WHERE closed IS NULL");
        sessionQuery.append(" AND owner.id = :owner");
        params.addLong("owner", session.getOwner().getId());
        if (!privileges.contains(this.adminPrivileges.getPrivilege("ReadSession"))) {
            if (session.getSudoer() == null) {
                sessionQuery.append(" AND sudoer IS NULL");
            } else {
                sessionQuery.append(" AND sudoer.id = :sudoer");
                params.addLong("sudoer", session.getSudoer().getId());
            }
        }
        ArrayList<String> agentClauses = new ArrayList<String>();
        if (!agentSet.isEmpty()) {
            agentClauses.add("userAgent IN (:agents)");
            params.addSet("agents", agentSet);
        }
        if (nullAgent) {
            agentClauses.add("userAgent IS NULL");
        }
        if (!agentClauses.isEmpty()) {
            sessionQuery.append(" AND (" + Joiner.on((String)" OR ").join(agentClauses) + ")");
        }
        sessionQuery.append(" ORDER BY started DESC");
        return this.findByQuery(sessionQuery.toString(), params);
    }

    @Override
    public int getReferenceCount(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.count().get();
    }

    @Override
    public int detach(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.count().decrement();
    }

    @Override
    public SessionStats getSessionStats(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        return ctx.stats();
    }

    @Override
    public int close(String uuid) {
        SessionContext ctx;
        try {
            ctx = this.cache.getSessionContext(uuid);
        }
        catch (SessionException se) {
            log.info("closeSession called but doesn't exist: " + uuid);
            return -1;
        }
        int refCount = ctx.count().decrement();
        if (refCount < 1) {
            log.info("closeSession called and no more references: " + uuid);
            this.cache.removeSession(uuid);
            return -2;
        }
        log.info("closeSession called but " + refCount + " more references: " + uuid);
        return refCount;
    }

    @Override
    public Map<String, Map<String, Object>> getSessionData() {
        Set<String> ids = this.cache.getIds();
        HashMap<String, Map<String, Object>> rv = new HashMap<String, Map<String, Object>>();
        for (String id : ids) {
            if (this.asroot.getName().equals(id)) continue;
            try {
                rv.put(id, this.cache.getSessionData(id, true));
            }
            catch (RemovedSessionException removedSessionException) {
            }
            catch (SessionTimeoutException sessionTimeoutException) {
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown on getAll: %s:%s", e.getClass().getName(), e.getMessage()));
            }
        }
        return rv;
    }

    @Override
    public int closeAll() {
        Set<String> ids = this.cache.getIds();
        for (String id : ids) {
            if (this.asroot.getName().equals(id)) continue;
            try {
                log.info("closeAll called for " + id);
                this.cache.removeSession(id);
            }
            catch (RemovedSessionException removedSessionException) {
            }
            catch (SessionTimeoutException sessionTimeoutException) {
            }
            catch (Exception e) {
                log.warn(String.format("Exception thrown on closeAll: %s:%s", e.getClass().getName(), e.getMessage()));
            }
        }
        return ids.size();
    }

    @Override
    public List<String> getUserRoles(String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid: " + uuid);
        }
        return ctx.getUserRoles();
    }

    @Override
    public Ehcache inMemoryCache(String uuid) {
        return this.cache.inMemoryCache(uuid);
    }

    @Override
    public Ehcache onDiskCache(String uuid) {
        return this.cache.onDiskCache(uuid);
    }

    @Override
    public Object getInput(String session, String key) throws RemovedSessionException {
        return this.getEnvironmentVariable(session, key, INPUT_ENVIRONMENT);
    }

    @Override
    public Object getOutput(String session, String key) throws RemovedSessionException {
        return this.getEnvironmentVariable(session, key, OUTPUT_ENVIRONMENT);
    }

    @Override
    public Map<String, Object> inputEnvironment(String session) {
        return this.environment(session, INPUT_ENVIRONMENT);
    }

    @Override
    public Map<String, Object> outputEnvironment(String session) {
        return this.environment(session, OUTPUT_ENVIRONMENT);
    }

    protected Map<String, Object> environment(String session, String env) {
        this.getReferenceCount(session);
        HashMap<String, Object> rv = new HashMap<String, Object>();
        Element elt = this.inMemoryCache(session).get((Serializable)((Object)env));
        if (elt == null) {
            return rv;
        }
        Map cv = (Map)elt.getObjectValue();
        if (cv == null) {
            return rv;
        }
        rv.putAll(cv);
        return rv;
    }

    @Override
    public void setInput(String session, String key, Object object) throws RemovedSessionException {
        this.setEnvironmentVariable(session, key, object, INPUT_ENVIRONMENT);
    }

    @Override
    public void setOutput(String session, String key, Object object) throws RemovedSessionException {
        this.setEnvironmentVariable(session, key, object, OUTPUT_ENVIRONMENT);
    }

    private Object getEnvironmentVariable(String session, String key, String env) {
        Ehcache cache = this.inMemoryCache(session);
        Element elt = cache.get((Serializable)((Object)env));
        if (elt == null) {
            return null;
        }
        Map map = (Map)elt.getObjectValue();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    private void setEnvironmentVariable(String session, String key, Object object, String env) {
        Map map;
        Ehcache cache = this.inMemoryCache(session);
        Element elt = cache.get((Serializable)((Object)env));
        if (elt == null) {
            map = new MapMaker().makeMap();
            elt = new Element((Object)env, (Object)map);
            cache.put(elt);
        } else {
            map = (Map)elt.getObjectValue();
        }
        if (object == null) {
            map.remove(key);
        } else {
            map.put(key, object);
        }
    }

    @Override
    public EventContext getEventContext(Principal principal) {
        SessionContext ctx = this.cache.getSessionContext(principal.getName());
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid:" + principal.getName());
        }
        return ctx;
    }

    @Override
    public EventContext reload(final String uuid) {
        SessionContext ctx = this.cache.getSessionContext(uuid);
        if (ctx == null) {
            throw new RemovedSessionException("No session with uuid:" + uuid);
        }
        Future<Object> future = this.executor.submit(Executor.Priority.SYSTEM, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SessionManagerImpl.this.cache.reload(uuid);
                return null;
            }
        });
        this.executor.get(future);
        return this.cache.getSessionContext(uuid);
    }

    public String[] notifications(String sessionId) {
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof UserGroupUpdateEvent) {
            this.cache.updateEvent((UserGroupUpdateEvent)event);
        } else if (event instanceof DestroySessionMessage) {
            this.sessionProvider.executeCloseSession(((DestroySessionMessage)event).getSessionId());
        }
    }

    public void addCallback(String sessionId, SessionCallback cb) {
    }

    public Object getCallbackObject(String sessionId, String name) {
        return null;
    }

    private Principal validateSessionInputs(ServiceFactory sf, SessionManager.CreationRequest req) {
        long gid;
        String group;
        Principal p = req.principal;
        if (p == null || p.getName() == null) {
            throw new ApiUsageException("Null principal name.");
        }
        String type = p.getEventType();
        if (StringUtils.isEmpty((String)type)) {
            type = "User";
        }
        if (StringUtils.isEmpty((String)(group = p.getGroup()))) {
            group = "user";
        }
        if (this.roles.getUserGroupName().equals(group)) {
            ExperimenterGroup g = this._getDefaultGroup(sf, p.getName());
            if (g == null) {
                throw new ApiUsageException("Can't find default group for " + p.getName());
            }
            group = g.getName();
        }
        if (req.groupsLed != null && !req.groupsLed.contains(gid = sf.getAdminService().lookupGroup(group).getId().longValue())) {
            throw new SecurityViolation(String.format("Group sudo is not permitted for group %s (gid=%s)", group, gid));
        }
        type = ((EventType)sf.getTypesService().getEnumeration(EventType.class, type)).getValue();
        return new Principal(p.getName(), group, type);
    }

    private void parseAndSetDefaultType(String type, Session session) {
        String _type = type == null ? "User" : type;
        session.setDefaultEventType(_type);
    }

    private void parseAndSetUserAgent(String userAgent, Session session) {
        session.setUserAgent(userAgent);
    }

    private void parseAndSetTimeouts(Long timeToLive, Long timeToIdle, Session session, boolean trusted) {
        if (timeToLive != null) {
            if (trusted) {
                session.setTimeToLive(timeToLive);
            } else {
                if (this.maxUserTimeToLive != 0L && (timeToLive > this.maxUserTimeToLive || timeToLive == 0L)) {
                    throw new SecurityViolation("Cannot modify timeToLive beyond maximum: " + this.maxUserTimeToLive);
                }
                session.setTimeToLive(timeToLive);
            }
        }
        if (timeToIdle != null) {
            if (trusted) {
                session.setTimeToIdle(timeToIdle);
            } else {
                if (this.maxUserTimeToLive != 0L && (timeToIdle > this.maxUserTimeToIdle || timeToIdle == 0L)) {
                    throw new SecurityViolation("Cannot modify timeToIdle beyond maximum: " + this.maxUserTimeToIdle);
                }
                session.setTimeToIdle(timeToIdle);
            }
        }
    }

    public Session copy(Session source) {
        if (source == null) {
            throw new ApiUsageException("Source may not be null.");
        }
        Object target = source instanceof Share ? this.newShare() : new Session();
        target.setId(source.getId());
        target.setClosed(source.getClosed());
        target.setDefaultEventType(source.getDefaultEventType());
        target.getDetails().shallowCopy(source.getDetails());
        target.setMessage(source.getMessage());
        target.setNode(source.getNode());
        target.setStarted(source.getStarted());
        target.setTimeToIdle(source.getTimeToIdle());
        target.setTimeToLive(source.getTimeToLive());
        target.setUserAgent(source.getUserAgent());
        target.setUuid(source.getUuid());
        if (target instanceof Share) {
            Share to = target;
            Share from = (Share)source;
            to.setItemCount(from.getItemCount());
            to.setActive(from.getActive());
            to.setGroup(from.getGroup());
            to.setData(from.getData());
        }
        return target;
    }

    public void prepareReload() {
    }

    @Override
    public SessionContext reload(final SessionContext ctx) {
        List<Object> list = this.executor.execute(this.asroot, new Executor.SimpleWork<List<Object>>((Object)this, "reload", new Object[]{ctx.getSession().getUuid()}){

            @Override
            @Transactional(readOnly=true)
            public List<Object> doWork(org.hibernate.Session session, ServiceFactory sf) {
                LocalAdmin admin = (LocalAdmin)sf.getAdminService();
                Experimenter exp = admin.userProxy(ctx.getCurrentUserId());
                ExperimenterGroup grp = admin.groupProxy(ctx.getCurrentGroupId());
                Principal p = new Principal(exp.getOmeName(), grp.getName(), ctx.getCurrentEventType());
                return SessionManagerImpl.this.executeSessionContextLookup(sf, p, exp, grp, ctx.getSession());
            }
        });
        if (list == null) {
            return null;
        }
        return this.createSessionContext(list, ctx);
    }

    private List<Object[]> executeProjection(final String projection, final Parameters parameters) {
        return this.executor.execute(this.asroot, new Executor.SimpleWork<List<Object[]>>((Object)this, "executeProjection", new Object[]{projection}){

            @Override
            @Transactional(readOnly=true)
            public List<Object[]> doWork(org.hibernate.Session session, ServiceFactory sf) {
                return sf.getQueryService().projection(projection, parameters);
            }
        });
    }

    @Override
    public boolean executePasswordCheck(String name, String credentials) {
        if (this.cache.getIds().contains(credentials)) {
            return true;
        }
        return this.executeCheckPassword(new Principal(name), credentials);
    }

    private boolean executeCheckPassword(Principal _principal, String credentials) {
        Boolean ok = this.executeCheckPasswordRO(_principal, credentials);
        if (ok == null) {
            ok = this.executeCheckPasswordRW(_principal, credentials);
        }
        return ok;
    }

    private Boolean executeCheckPasswordRO(final Principal _principal, final String credentials) {
        return this.executor.execute(this.asroot, new Executor.SimpleWork<Boolean>((Object)this, "executeCheckPasswordRO", new Object[]{_principal}){

            @Override
            @Transactional(readOnly=true)
            public Boolean doWork(org.hibernate.Session session, ServiceFactory sf) {
                try {
                    return ((LocalAdmin)sf.getAdminService()).checkPassword(_principal.getName(), credentials, true);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private Boolean executeCheckPasswordRW(final Principal _principal, final String credentials) {
        return this.executor.execute(this.asroot, new Executor.SimpleWork<Boolean>((Object)this, "executeCheckPasswordRW", new Object[]{_principal}){

            @Override
            @Transactional(readOnly=false)
            public Boolean doWork(org.hibernate.Session session, ServiceFactory sf) {
                return ((LocalAdmin)sf.getAdminService()).checkPassword(_principal.getName(), credentials, false);
            }
        });
    }

    @Override
    public IObject setSecurityContext(Principal principal, IObject obj) {
        Long id;
        Long l = id = obj == null ? null : obj.getId();
        if (id == null) {
            throw new ApiUsageException("Security context must be managed!");
        }
        SessionContext sc = this.cache.getSessionContext(principal.getName());
        TextAnnotation ta = null;
        for (Annotation a : sc.getSession().linkedAnnotationList()) {
            if (a instanceof TextAnnotation && this.roles.isRootUser(a.getDetails().getOwner()) && GROUP_SUDO_NS.equals(a.getNs())) {
                ta = (TextAnnotation)a;
            }
            if (ta == null) continue;
            String[] groupIds = ta.getTextValue().split(",");
            throw new SecurityViolation("Group-sudo session cannot change context!");
        }
        long activeMethods = sc.stats().methodCount();
        if (activeMethods != 0L) {
            throw new SecurityViolation(activeMethods + " methods active. Aborting!");
        }
        Long shareId = sc.getCurrentShareId();
        Long groupId = sc.getCurrentGroupId();
        Object prevCtx = null;
        prevCtx = shareId != null ? new Share(shareId, false) : new ExperimenterGroup(groupId, false);
        ChangeSecurityContextEvent csce = new ChangeSecurityContextEvent(this, principal.getName(), (IObject)prevCtx, obj);
        try {
            this.context.publishMessage((InternalMessage)csce);
            csce.throwIfCancelled();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            InternalException ie = new InternalException("Failed to set call publishMessage");
            ie.initCause(e);
            throw ie;
        }
        if (obj instanceof ExperimenterGroup) {
            this.setGroupSecurityContext(principal, id);
        } else if (obj instanceof Share) {
            this.setShareSecurityContext(principal, id);
        } else {
            throw new ApiUsageException("Unknown security context:" + obj);
        }
        return prevCtx;
    }

    private void setGroupSecurityContext(final Principal principal, final Long id) {
        final EventContext ec = this.getEventContext(principal);
        final ExperimenterGroup[] group = new ExperimenterGroup[1];
        final Session s = this.executor.execute(principal, new Executor.SimpleWork<Session>((Object)this, "setGroupSecurityContext", new Object[]{id}){

            @Override
            @Transactional(readOnly=true)
            public Session doWork(org.hibernate.Session session, ServiceFactory sf) {
                if (ec.getCurrentShareId() != null) {
                    sf.getShareService().deactivate();
                }
                SessionContext sc = SessionManagerImpl.this.cache.getSessionContext(principal.getName());
                Session s = sc.getSession();
                if (!sc.isCurrentUserAdmin() && id >= 0L && !sc.getMemberOfGroupsList().contains(id)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("User ");
                    sb.append(sc.getCurrentUserId());
                    sb.append(" is not a member of group ");
                    sb.append(id);
                    throw new SecurityViolation(sb.toString());
                }
                group[0] = s.getDetails().getGroup();
                s.getDetails().setGroup(sf.getAdminService().getGroup(id.longValue()));
                return s;
            }
        });
        this.executor.execute(principal, new Executor.SimpleWork<EventContext>((Object)this, "checkGroupSecurityContext", new Object[]{id}){

            @Override
            @Transactional(readOnly=true)
            public EventContext doWork(org.hibernate.Session session, ServiceFactory sf) {
                try {
                    sf.getAdminService().getEventContext();
                }
                catch (RuntimeException re) {
                    s.getDetails().setGroup(group[0]);
                    throw re;
                }
                return null;
            }
        });
    }

    private void setShareSecurityContext(Principal principal, final Long id) {
        this.executor.execute(principal, new Executor.SimpleWork<Void>((Object)this, "setShareSecurityContext", new Object[]{id}){

            @Override
            @Transactional(readOnly=true)
            public Void doWork(org.hibernate.Session session, ServiceFactory sf) {
                sf.getShareService().activate(id.longValue());
                return null;
            }
        });
    }

    private ExperimenterGroup _getDefaultGroup(ServiceFactory sf, String name) {
        LocalAdmin admin = (LocalAdmin)sf.getAdminService();
        try {
            Experimenter exp = admin.userProxy(name);
            ExperimenterGroup grp = admin.getDefaultGroup(exp.getId());
            return grp;
        }
        catch (Exception e) {
            log.warn("Exception while running executeDefaultGroup", (Throwable)e);
            return null;
        }
    }

    private long executeLookupUser(ServiceFactory sf, Principal p) {
        List rv = sf.getQueryService().projection("select e.id from Experimenter e where e.omeName = :name", new Parameters().addString("name", p.getName()));
        if (rv.size() == 0) {
            throw new RemovedSessionException("Cannot find a user with name " + p.getName());
        }
        return (Long)((Object[])rv.get(0))[0];
    }

    private boolean isAnyPrivilegeRestricted(List<NamedValue> userConfig, String ... privilegeNames) {
        if (userConfig == null) {
            return false;
        }
        HashSet<String> configNamesRestricted = new HashSet<String>();
        for (NamedValue configProperty : userConfig) {
            String configName = configProperty.getName();
            String configValue = configProperty.getValue();
            if (Boolean.parseBoolean(configValue)) continue;
            configNamesRestricted.add(configName);
        }
        for (String privilegeName : privilegeNames) {
            AdminPrivilege privilege = this.adminPrivileges.getPrivilege(privilegeName);
            String privilegeConfigName = this.adminPrivileges.getConfigNameForPrivilege(privilege);
            if (!configNamesRestricted.contains(privilegeConfigName)) continue;
            return true;
        }
        return false;
    }

    private List<Object> executeSessionContextLookup(ServiceFactory sf, Principal principal, Session session) {
        LocalAdmin admin = (LocalAdmin)sf.getAdminService();
        Experimenter exp = admin.userProxy(principal.getName());
        ExperimenterGroup grp = admin.groupProxy(principal.getGroup());
        return this.executeSessionContextLookup(sf, principal, exp, grp, session);
    }

    private List<Object> executeSessionContextLookup(ServiceFactory sf, Principal principal, Experimenter exp, ExperimenterGroup grp, Session session) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            LocalAdmin admin = (LocalAdmin)sf.getAdminService();
            List memberOfGroupsIds = admin.getMemberOfGroupIds(exp);
            List leaderOfGroupsIds = admin.getLeaderOfGroupIds(exp);
            List<String> userRoles = admin.getUserRoles(exp);
            Session reloaded = this.sessionProvider.findSessionById((long)session.getId(), sf);
            Experimenter sudoer = reloaded.getSudoer();
            boolean hasAdminPrivileges = memberOfGroupsIds.contains(this.roles.getSystemGroupId());
            if (sudoer != null) {
                boolean hasSudoPrivilegeSudoer;
                List leaderOfGroupsIdsSudoer = admin.getLeaderOfGroupIds(sudoer);
                List memberOfGroupsIdsSudoer = admin.getMemberOfGroupIds(sudoer);
                if (memberOfGroupsIdsSudoer.contains(this.roles.getSystemGroupId())) {
                    hasSudoPrivilegeSudoer = !this.isAnyPrivilegeRestricted(sudoer.getConfig(), "Sudo");
                } else {
                    hasSudoPrivilegeSudoer = false;
                    hasAdminPrivileges = false;
                }
                if (!hasSudoPrivilegeSudoer) {
                    leaderOfGroupsIds.retainAll(leaderOfGroupsIdsSudoer);
                    memberOfGroupsIds.retainAll(memberOfGroupsIdsSudoer);
                }
            }
            list.add(exp);
            list.add(grp);
            list.add(hasAdminPrivileges ? this.adminPrivileges.getSessionPrivileges(reloaded) : Collections.emptySet());
            list.add(memberOfGroupsIds);
            list.add(leaderOfGroupsIds);
            list.add(userRoles);
            list.add(principal);
            list.add(reloaded);
            return list;
        }
        catch (Exception e) {
            log.info("No info for " + principal.getName(), (Throwable)e);
            return null;
        }
    }

    private Share newShare() {
        Share share = new Share();
        share.putAt("#2733", (Object)"ALLOW");
        return share;
    }
}

