/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmiraParameters {
    public int width;
    public int height;
    public int depth;
    public int firstDataStream;
    public double x0;
    public double y0;
    public double z0;
    public double x1;
    public double y1;
    public double z1;
    public boolean littleEndian;
    public boolean ascii;
    public int nStreams = 0;
    public String[] streamNames;
    public String[] streamTypes;
    protected transient RandomAccessInputStream in;
    protected Map map;
    protected Map streams;
    protected int column;
    protected int row;
    protected char c;
    private static final Logger LOGGER = LoggerFactory.getLogger(AmiraParameters.class);

    public AmiraParameters(String path) throws FormatException {
        this.readFile(path);
    }

    public AmiraParameters(RandomAccessInputStream inputStream) throws FormatException, IOException {
        this.readFile(inputStream);
    }

    protected void readFile(String path) throws FormatException {
        try {
            this.readFile(new RandomAccessInputStream(path));
        }
        catch (IOException e) {
            throw new FormatException("read error: " + path);
        }
    }

    protected void readFile(RandomAccessInputStream inputStream) throws FormatException, IOException {
        String firstLine = inputStream.readLine();
        Matcher amiraMeshDef = Pattern.compile("#\\s+(AmiraMesh|Avizo).*?(BINARY|ASCII)(-LITTLE-ENDIAN)*").matcher(firstLine);
        if (amiraMeshDef.find()) {
            if (amiraMeshDef.group(2).equals("BINARY")) {
                this.littleEndian = amiraMeshDef.group(3) != null;
            } else if (amiraMeshDef.group(2).equals("ASCII")) {
                this.ascii = true;
            } else {
                this.syntaxError("Can't recognise this Amira file type");
            }
        } else {
            this.syntaxError("Doesn't seem to be an Amira file");
        }
        this.column = 0;
        this.row = 1;
        this.in = inputStream;
        this.readByte();
        this.readTopLevel();
        this.extractCoreMetaData();
    }

    protected void extractCoreMetaData() throws FormatException {
        Map p;
        if (this.map.containsKey("Parameters") && (p = (Map)this.map.get("Parameters")).containsKey("BoundingBox")) {
            Double[] bb = (Double[])p.get("BoundingBox");
            this.x0 = bb[0];
            this.x1 = bb[1];
            this.y0 = bb[2];
            this.y1 = bb[3];
            this.z0 = bb[4];
            this.z1 = bb[5];
        }
        this.nStreams = this.streams.size();
        if (this.nStreams > 0) {
            this.streamNames = new String[this.nStreams];
            this.streamTypes = new String[this.nStreams];
            int i = 0;
            for (Object key : this.streams.keySet()) {
                ArrayList al = (ArrayList)this.streams.get(key);
                this.streamNames[i] = (String)al.get(0);
                Map streamMap = (Map)al.get(1);
                Iterator it = streamMap.keySet().iterator();
                if (it.hasNext()) {
                    this.streamTypes[i] = (String)it.next();
                } else {
                    this.syntaxError("Unable to identify data type");
                }
                ++i;
            }
        }
    }

    protected void syntaxError(String message) throws FormatException {
        throw new FormatException("Syntax Error:" + this.row + ":" + this.column + ": " + message);
    }

    protected void readTopLevel() throws FormatException, IOException {
        this.streams = new LinkedHashMap();
        this.map = new LinkedHashMap();
        while (true) {
            this.skipWhiteSpace();
            if (this.c == '#') {
                this.skipComment();
                continue;
            }
            if (this.c == '@') {
                this.readByte();
                this.firstDataStream = this.readNumber().intValue();
                this.skipComment();
                return;
            }
            String key = this.readKey();
            this.skipWhiteSpace();
            Object value = null;
            if (key.equals("define")) {
                key = "n" + this.readKey();
                this.skipWhiteSpace();
            }
            if (key.equals("nLattice")) {
                Integer[] dimensions = this.readIntArray();
                this.width = dimensions[0];
                if (dimensions.length > 1) {
                    this.height = dimensions[1];
                }
                if (dimensions.length > 2) {
                    this.depth = dimensions[2];
                }
                value = dimensions;
            } else {
                if (key.equals("nNodes") || key.equals("nTriangles") || key.equals("nTetrahedra") || key.equals("nEdges")) {
                    throw new FormatException("Don't know yet how to handle " + key);
                }
                if (key.equals("Parameters")) {
                    value = this.readMap();
                } else {
                    if (key.equals("Lattice") || key.equals("Vertices") || key.equals("Lines") || key.equals("Markers")) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(key);
                        list.add(this.readMap());
                        this.skipWhiteSpace();
                        if (this.c == '=') {
                            this.readByte();
                            this.skipWhiteSpace();
                        }
                        if (this.c != '@') {
                            this.syntaxError("Missing @");
                        }
                        this.readByte();
                        int index = this.readNumber().intValue();
                        if (this.c == '(') {
                            list.add(this.readQuotedString());
                        }
                        this.skipComment();
                        this.streams.put("@" + index, list);
                        continue;
                    }
                    this.skipComment();
                }
            }
            this.map.put(key, value);
        }
    }

    protected char readByte() throws IOException {
        this.c = (char)this.in.read();
        if (this.c == '\n') {
            ++this.row;
            this.column = 1;
        } else {
            ++this.column;
        }
        return this.c;
    }

    protected void skipComment() throws IOException {
        while (this.c != '\n') {
            this.readByte();
        }
    }

    protected void skipWhiteSpace() throws IOException {
        while (this.c == ' ' || this.c == '\t' || this.c == '\n') {
            this.readByte();
        }
    }

    protected String readKey() throws IOException {
        StringBuilder result = new StringBuilder();
        while (this.c >= '0' || this.c == '-' || this.c == '&') {
            result.append(this.c);
            this.readByte();
        }
        return result.toString();
    }

    protected Number readNumber() throws FormatException, IOException {
        StringBuilder string = new StringBuilder();
        while (this.c >= '0' && this.c <= '9' || this.c == '.' || this.c == '-' || this.c == '+' || this.c == 'e') {
            string.append(this.c);
            this.readByte();
        }
        try {
            if (string.indexOf(".") < 0 && string.indexOf("e") < 0) {
                return Integer.valueOf(string.toString());
            }
            return Double.valueOf(string.toString());
        }
        catch (NumberFormatException e) {
            this.syntaxError(e.getMessage());
            return null;
        }
    }

    protected Integer[] readIntArray() throws FormatException, IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int currentRow = this.row;
        while (currentRow == this.row && (this.c >= '0' && this.c <= '9' || this.c == '.' || this.c == '-' || this.c == '+')) {
            result.add((Integer)this.readNumber());
            this.skipWhiteSpace();
        }
        Integer[] intResult = new Integer[result.size()];
        return result.toArray(intResult);
    }

    protected Number[] readNumberArray() throws FormatException, IOException {
        ArrayList<Number> result = new ArrayList<Number>();
        boolean intsOnly = true;
        int currentRow = this.row;
        while (currentRow == this.row && (this.c >= '0' && this.c <= '9' || this.c == '.' || this.c == '-' || this.c == '+')) {
            Number n = this.readNumber();
            if (n instanceof Double) {
                intsOnly = false;
            }
            result.add(n);
            this.skipWhiteSpace();
        }
        if (intsOnly) {
            Integer[] intResult = new Integer[result.size()];
            return result.toArray(intResult);
        }
        Number[] doubleResult = new Double[result.size()];
        for (int i = 0; i < doubleResult.length; ++i) {
            doubleResult[i] = new Double(((Number)result.get(i)).doubleValue());
        }
        return doubleResult;
    }

    protected Integer[] readIntArray(int count) throws FormatException, IOException {
        Integer[] result = new Integer[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (Integer)this.readNumber();
            this.skipWhiteSpace();
        }
        return result;
    }

    protected Double[] readDoubleArray(int count) throws FormatException, IOException {
        Double[] result = new Double[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new Double(this.readNumber().doubleValue());
            this.skipWhiteSpace();
        }
        return result;
    }

    protected String readQuotedString() throws FormatException, IOException {
        char quote = this.c;
        if (quote == '(') {
            quote = ')';
        } else if (quote != '\"' && quote != '\'') {
            this.syntaxError("Invalid quote: " + this.c);
        }
        StringBuilder result = new StringBuilder();
        while (true) {
            this.readByte();
            if (this.c == quote) {
                this.readByte();
                return result.toString();
            }
            if (quote == '\"' && this.c == '\\') {
                this.readByte();
            }
            result.append(this.c);
        }
    }

    protected Map readMap() throws FormatException, IOException {
        if (this.c != '{') {
            this.syntaxError("Illegal block: " + this.c);
        }
        this.readByte();
        LinkedHashMap<String, Double[]> subMap = new LinkedHashMap<String, Double[]>();
        while (true) {
            Object value;
            this.skipWhiteSpace();
            if (this.c == '#') {
                this.skipComment();
                continue;
            }
            if (this.c == '}') {
                this.readByte();
                return subMap;
            }
            String key = this.readKey();
            if (key.equals("")) {
                LOGGER.warn("Syntax warning:" + this.row + ":" + this.column + ": Invalid key");
                this.skipComment();
                continue;
            }
            this.skipWhiteSpace();
            if (this.c == '{') {
                value = this.readMap();
            } else {
                Number[] na;
                value = key.equals("BoundingBox") ? this.readDoubleArray(6) : (key.equals("MinMax") ? this.readDoubleArray(2) : (key.startsWith("byte") || key.startsWith("short") || key.startsWith("ushort") || key.startsWith("float") ? this.readKey() : (this.c == '\"' || this.c == '\'' ? this.readQuotedString() : ((na = this.readNumberArray()).length == 1 ? na[0] : na))));
                if (this.c == ',') {
                    this.readByte();
                }
            }
            subMap.put(key, (Double[])value);
        }
    }

    public Map getMap() {
        return this.map;
    }

    public Map getStreams() {
        return this.streams;
    }

    public String toString() {
        try {
            return AmiraParameters.toString(this.map, "") + AmiraParameters.toString(this.streams, "");
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Map map, String indent) throws FormatException {
        String result = "";
        String separator = indent;
        for (Map.Entry entry : map.entrySet()) {
            if ((result = result + separator + entry.getKey() + " " + AmiraParameters.entryToString(entry.getValue(), indent)).endsWith("}")) {
                separator = "\n" + indent;
                continue;
            }
            separator = ",\n" + indent;
        }
        return result + "\n";
    }

    public static String entryToString(Object object, String indent) throws FormatException {
        if (object instanceof Integer || object instanceof Double) {
            return object.toString();
        }
        if (object instanceof String) {
            int nextOffset;
            String string = (String)object;
            StringBuilder result = new StringBuilder("\"");
            int offset = 0;
            while ((nextOffset = string.indexOf(34, offset + 1)) >= 0) {
                if (nextOffset > offset + 1) {
                    result.append(string, offset, nextOffset);
                }
                result.append("\\");
                offset = nextOffset;
            }
            if (offset + 1 < string.length()) {
                result.append(string, offset, string.length());
            }
            result.append("\"");
            return result.toString();
        }
        if (object instanceof Integer[]) {
            Integer[] array = (Integer[])object;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                result.append(array[i]);
            }
            return result.toString();
        }
        if (object instanceof Double[]) {
            Double[] array = (Double[])object;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                result.append(array[i]);
            }
            return result.toString();
        }
        if (object instanceof Map) {
            return "{\n" + AmiraParameters.toString((Map)object, indent + "\t") + indent + "}";
        }
        if (object instanceof ArrayList) {
            StringBuilder result = new StringBuilder("{\n");
            for (Object item : (ArrayList)object) {
                result.append(AmiraParameters.entryToString(item, indent + "\t"));
                result.append("\n");
            }
            result.append(indent);
            result.append("}");
            return result.toString();
        }
        throw new FormatException("Illegal value type: " + object.getClass().getName());
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("file: " + args[i]);
            try {
                System.out.println(new AmiraParameters(args[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

