/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.model.Permissions;
import omero.model.PermissionsI;

public class PermissionData {
    private final Permissions p;

    public PermissionData() {
        this.p = new PermissionsI();
    }

    public PermissionData(Permissions permissions) {
        this.p = permissions == null ? new PermissionsI() : permissions;
    }

    public int getPermissionsLevel() {
        if (this.isGroupRead()) {
            if (this.isGroupAnnotate()) {
                if (this.isGroupWrite()) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        if (this.isWorldRead()) {
            if (this.isWorldWrite()) {
                return 5;
            }
            return 4;
        }
        return 0;
    }

    public boolean isGroupRead() {
        return this.p.isGroupRead();
    }

    public boolean isGroupAnnotate() {
        return this.p.isGroupAnnotate();
    }

    public boolean isGroupWrite() {
        return this.p.isGroupWrite();
    }

    public boolean isUserRead() {
        return this.p.isUserRead();
    }

    public boolean isUserWrite() {
        return this.p.isUserWrite();
    }

    public boolean isWorldRead() {
        return this.p.isWorldRead();
    }

    public boolean isWorldWrite() {
        return this.p.isWorldWrite();
    }

    public void setGroupRead(boolean groupRead) {
        this.p.setGroupRead(groupRead);
    }

    public void setGroupAnnotate(boolean groupAnnotate) {
        this.p.setGroupAnnotate(groupAnnotate);
    }

    public void setGroupWrite(boolean groupWrite) {
        this.p.setGroupWrite(groupWrite);
    }

    public void setUserRead(boolean userRead) {
        this.p.setUserRead(userRead);
    }

    public void setUserWrite(boolean userWrite) {
        this.p.setUserWrite(userWrite);
    }

    public void setWorldRead(boolean worldRead) {
        this.p.setWorldRead(worldRead);
    }

    public void setWorldWrite(boolean worldWrite) {
        this.p.setWorldWrite(worldWrite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isUserRead()) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (this.isUserWrite()) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (this.isGroupRead()) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (this.isGroupWrite()) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (this.isWorldRead()) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (this.isWorldWrite()) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }
}

