/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ome.api.IAdmin;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.graphs.GroupPredicate;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import ome.system.Roles;
import ome.util.Utils;
import omero.cmd.Chmod2;
import omero.cmd.Chmod2Response;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import omero.cmd.graphs.WrappableRequest;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Chmod2I
extends Chmod2
implements IRequest,
ReadOnlyStatus.IsAware,
WrappableRequest<Chmod2> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Chmod2I.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of((Object)((Object)GraphPolicy.Ability.CHMOD));
    private final ACLVoter aclVoter;
    private final Roles securityRoles;
    private final GraphPathBean graphPathBean;
    private final Deletion deletionInstance;
    private final Set<Class<? extends IObject>> targetClasses;
    private GraphPolicy graphPolicy;
    private final SetMultimap<String, String> unnullable;
    private final ApplicationContext applicationContext;
    private long perm1;
    private List<Function<GraphPolicy, GraphPolicy>> graphPolicyAdjusters = new ArrayList<Function<GraphPolicy, GraphPolicy>>();
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private InternalProcessor internalProcessor;
    private Set<Long> acceptableGroups;
    private GraphTraversal.PlanExecutor unlinker;
    private GraphTraversal.PlanExecutor processor;
    private int targetObjectCount = 0;
    private int deletedObjectCount = 0;
    private int changedObjectCount = 0;

    public Chmod2I(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Deletion deletionInstance, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy, SetMultimap<String, String> unnullable, ApplicationContext applicationContext) {
        this.aclVoter = aclVoter;
        this.securityRoles = securityRoles;
        this.graphPathBean = graphPathBean;
        this.deletionInstance = deletionInstance;
        this.targetClasses = targetClasses;
        this.graphPolicy = graphPolicy;
        this.unnullable = unnullable;
        this.applicationContext = applicationContext;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("permissions", this.permissions);
            arguments.addParameter("targetObjects", this.targetObjects);
            arguments.addParameter("childOptions", (Object)this.childOptions);
            arguments.addParameter("dryRun", this.dryRun);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(this.dryRun ? 4 : 6);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        try {
            this.perm1 = (Long)Utils.internalForm((Permissions)Permissions.parseString((String)this.permissions));
        }
        catch (RuntimeException e) {
            throw helper.cancel(new ERR(), (Throwable)e, "bad-permissions", new String[0]);
        }
        EventContext eventContext = helper.getEventContext();
        if (eventContext.isCurrentUserAdmin()) {
            this.acceptableGroups = null;
        } else {
            Long userId = eventContext.getCurrentUserId();
            IAdmin iAdmin = helper.getServiceFactory().getAdminService();
            this.acceptableGroups = ImmutableSet.copyOf((Collection)iAdmin.getLeaderOfGroupIds(new Experimenter(userId, false)));
        }
        this.graphPolicy.registerPredicate(new GroupPredicate(this.securityRoles));
        this.internalProcessor = new InternalProcessor();
        this.graphTraversal = this.graphHelper.prepareGraphTraversal(this.childOptions, REQUIRED_ABILITIES, this.graphPolicy, this.graphPolicyAdjusters, this.aclVoter, this.graphPathBean, this.unnullable, this.internalProcessor, this.dryRun);
        this.graphPolicyAdjusters = null;
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    SetMultimap<String, Long> targetMultimap = this.graphHelper.getTargetMultimap(this.targetClasses, this.targetObjects);
                    this.targetObjectCount += targetMultimap.size();
                    Permissions newPermissions = Utils.toPermissions((Object)this.perm1);
                    boolean isToGroupReadable = newPermissions.isGranted(Permissions.Role.GROUP, Permissions.Right.READ);
                    if (isToGroupReadable) {
                        return this.graphTraversal.planOperation(targetMultimap, true, false);
                    }
                    String groupClass = ExperimenterGroup.class.getName();
                    HashMultimap targetsNotPrivate = HashMultimap.create();
                    HashMap<Long, Boolean> readableByGroupId = new HashMap<Long, Boolean>();
                    for (Long groupId : targetMultimap.get((Object)groupClass)) {
                        Boolean isFromGroupReadable = (Boolean)readableByGroupId.get(groupId);
                        if (isFromGroupReadable == null) {
                            Session session = this.helper.getSession();
                            ExperimenterGroup group = (ExperimenterGroup)session.get(ExperimenterGroup.class, (Serializable)groupId);
                            if (group == null) {
                                IllegalArgumentException e = new IllegalArgumentException("no group " + groupId);
                                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-group", new String[0]);
                            }
                            Permissions permissions = group.getDetails().getPermissions();
                            isFromGroupReadable = permissions.isGranted(Permissions.Role.GROUP, Permissions.Right.READ);
                            readableByGroupId.put(groupId, isFromGroupReadable);
                        }
                        if (!isFromGroupReadable.booleanValue()) continue;
                        targetsNotPrivate.put((Object)groupClass, (Object)groupId);
                    }
                    return this.graphTraversal.planOperation((SetMultimap<String, Long>)targetsNotPrivate, true, true);
                }
                case 1: {
                    this.graphTraversal.assertNoPolicyViolations();
                    return null;
                }
                case 2: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 3: {
                    this.unlinker = this.graphTraversal.unlinkTargets(false);
                    this.graphTraversal = null;
                    return null;
                }
                case 4: {
                    this.unlinker.execute();
                    return null;
                }
                case 5: {
                    this.processor.execute();
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            Map.Entry result = (Map.Entry)object;
            if (!this.dryRun) {
                try {
                    this.internalProcessor.deleteFiles(this.deletionInstance);
                }
                catch (Exception e) {
                    this.helper.cancel(new ERR(), (Throwable)e, "file-delete-fail", new String[0]);
                }
            }
            Map<String, List<Long>> changedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getKey()));
            Map<String, List<Long>> deletedObjects = GraphUtil.copyMultimapForResponse((SetMultimap<String, Long>)((SetMultimap)result.getValue()));
            this.changedObjectCount += ((SetMultimap)result.getKey()).size();
            this.deletedObjectCount += ((SetMultimap)result.getValue()).size();
            Chmod2Response response = new Chmod2Response(changedObjects, deletedObjects);
            this.helper.setResponseIfNull(response);
            this.helper.info("in " + (this.dryRun ? "mock " : "") + "chmod to " + this.permissions + " of " + this.targetObjectCount + ", changed " + this.changedObjectCount + " and deleted " + this.deletedObjectCount + " in total", new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
                arguments.addParameter("includedObjects", response.includedObjects);
                arguments.addParameter("deletedObjects", response.deletedObjects);
                LOGGER.debug("response: " + arguments);
            }
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    @Override
    public void copyFieldsTo(Chmod2 request) {
        GraphUtil.copyFields(this, request);
        request.permissions = this.permissions;
    }

    @Override
    public void adjustGraphPolicy(Function<GraphPolicy, GraphPolicy> adjuster) {
        if (this.graphPolicyAdjusters == null) {
            throw new IllegalStateException("request is already initialized");
        }
        this.graphPolicyAdjusters.add(adjuster);
    }

    @Override
    public int getStepProvidingCompleteResponse() {
        return 0;
    }

    @Override
    public GraphPolicy.Action getActionForStarting() {
        return GraphPolicy.Action.INCLUDE;
    }

    @Override
    public Map<String, List<Long>> getStartFrom(Response response) {
        return ((Chmod2Response)response).includedObjects;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return this.dryRun;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        private final Logger LOGGER;

        public InternalProcessor() {
            super(Chmod2I.this.helper.getSession());
            this.LOGGER = LoggerFactory.getLogger(InternalProcessor.class);
        }

        @Override
        public void deleteInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            super.deleteInstances(className, ids);
            Chmod2I.this.graphHelper.publishEventLog(Chmod2I.this.applicationContext, "DELETE", className, ids);
        }

        @Override
        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            String update = "UPDATE " + className + " SET details.permissions.perm1 = :permissions WHERE id IN (:ids)";
            int count = this.session.createQuery(update).setParameter("permissions", (Object)Chmod2I.this.perm1).setParameterList("ids", ids).executeUpdate();
            Chmod2I.this.graphHelper.publishEventLog(Chmod2I.this.applicationContext, "UPDATE", className, ids);
            if (count != ids.size()) {
                this.LOGGER.warn("not all the objects of type " + className + " could be processed");
            }
        }

        @Override
        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return REQUIRED_ABILITIES;
        }

        @Override
        public void assertMayProcess(String className, long id, Details details) throws ome.services.graphs.GraphException {
            if (Chmod2I.this.acceptableGroups != null && !Chmod2I.this.acceptableGroups.contains(id)) {
                throw new ome.services.graphs.GraphException("user is not an owner of group " + id);
            }
        }
    }
}

