/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import com.google.common.hash.HashCode;
import java.io.File;
import java.nio.ByteBuffer;
import ome.util.checksum.ChecksumProvider;

public class FileSizeChecksumProviderImpl
implements ChecksumProvider {
    private long size = 0L;
    private boolean isChecksumCalculated = false;

    @Override
    public ChecksumProvider putBytes(byte[] byteArray) {
        this.verifyState();
        this.size += (long)byteArray.length;
        return this;
    }

    @Override
    public ChecksumProvider putBytes(byte[] byteArray, int offset, int length) {
        this.verifyState();
        byte start = byteArray[offset];
        byte end = byteArray[offset + length - 1];
        this.size += (long)length;
        return this;
    }

    @Override
    public ChecksumProvider putBytes(ByteBuffer byteBuffer) {
        this.verifyState();
        if (!byteBuffer.hasArray()) {
            throw new IllegalArgumentException("Supplied ByteBuffer has inaccessible array.");
        }
        this.size += (long)(byteBuffer.limit() - byteBuffer.position());
        return this;
    }

    @Override
    public ChecksumProvider putFile(String filePath) {
        this.verifyState();
        this.size = new File(filePath).length();
        return this;
    }

    @Override
    public byte[] checksumAsBytes() {
        this.isChecksumCalculated = true;
        return HashCode.fromLong((long)this.size).asBytes();
    }

    @Override
    public String checksumAsString() {
        this.isChecksumCalculated = true;
        return HashCode.fromLong((long)this.size).toString();
    }

    private void verifyState() {
        if (this.isChecksumCalculated) {
            throw new IllegalStateException("Checksum state already set. Mutation illegal.");
        }
    }
}

