/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core;

import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface Node {
    public static final String ZARR_JSON = "zarr.json";
    public static final String ZARRAY = ".zarray";
    public static final String ZATTRS = ".zattrs";
    public static final String ZGROUP = ".zgroup";

    public static Node open(StoreHandle storeHandle) throws IOException, ZarrException {
        boolean isV2;
        boolean isV3 = storeHandle.resolve(ZARR_JSON).exists();
        boolean bl = isV2 = storeHandle.resolve(ZARRAY).exists() || storeHandle.resolve(ZGROUP).exists();
        if (isV3 && isV2) {
            throw new ZarrException("Both Zarr v2 and v3 nodes found at " + storeHandle);
        }
        if (isV3) {
            return dev.zarr.zarrjava.v3.Node.open(storeHandle);
        }
        if (isV2) {
            return dev.zarr.zarrjava.v2.Node.open(storeHandle);
        }
        throw new NoSuchFileException("No Zarr node found at " + storeHandle);
    }

    public static Node open(Path path) throws IOException, ZarrException {
        return Node.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Node open(String path) throws IOException, ZarrException {
        return Node.open(Paths.get(path, new String[0]));
    }
}

