/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3.codec;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import dev.zarr.zarrjava.v3.codec.Codec;
import dev.zarr.zarrjava.v3.codec.core.BloscCodec;
import dev.zarr.zarrjava.v3.codec.core.BytesCodec;
import dev.zarr.zarrjava.v3.codec.core.Crc32cCodec;
import dev.zarr.zarrjava.v3.codec.core.GzipCodec;
import dev.zarr.zarrjava.v3.codec.core.ShardingIndexedCodec;
import dev.zarr.zarrjava.v3.codec.core.TransposeCodec;
import dev.zarr.zarrjava.v3.codec.core.ZstdCodec;
import java.util.HashMap;
import java.util.Map;

public class CodecRegistry {
    static Map<String, Class<? extends Codec>> map = new HashMap<String, Class<? extends Codec>>();

    public static void addType(String name, Class<? extends Codec> codecClass) {
        map.put(name, codecClass);
    }

    public static NamedType[] getNamedTypes() {
        return (NamedType[])map.entrySet().stream().map(entry -> new NamedType((Class)entry.getValue(), (String)entry.getKey())).toArray(NamedType[]::new);
    }

    static {
        CodecRegistry.addType("transpose", TransposeCodec.class);
        CodecRegistry.addType("bytes", BytesCodec.class);
        CodecRegistry.addType("blosc", BloscCodec.class);
        CodecRegistry.addType("gzip", GzipCodec.class);
        CodecRegistry.addType("zstd", ZstdCodec.class);
        CodecRegistry.addType("crc32c", Crc32cCodec.class);
        CodecRegistry.addType("sharding_indexed", ShardingIndexedCodec.class);
    }
}

