/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.ArrayMetadata;
import dev.zarr.zarrjava.core.chunkkeyencoding.ChunkKeyEncoding;
import dev.zarr.zarrjava.core.chunkkeyencoding.Separator;
import dev.zarr.zarrjava.utils.MultiArrayUtils;
import dev.zarr.zarrjava.v2.DataType;
import dev.zarr.zarrjava.v2.Endianness;
import dev.zarr.zarrjava.v2.Order;
import dev.zarr.zarrjava.v2.chunkkeyencoding.V2ChunkKeyEncoding;
import dev.zarr.zarrjava.v2.codec.Codec;
import javax.annotation.Nullable;
import ucar.ma2.Array;

public class ArrayMetadata
implements dev.zarr.zarrjava.core.ArrayMetadata {
    static final int ZARR_FORMAT = 2;
    @JsonProperty(value="zarr_format")
    public final int zarrFormat = 2;
    public long[] shape;
    public int[] chunks;
    @JsonProperty(value="dtype")
    public DataType dataType;
    @JsonIgnore
    public final Endianness endianness;
    @JsonProperty(value="order")
    public Order order;
    @JsonProperty(value="dimension_separator")
    public Separator dimensionSeparator;
    @JsonProperty(value="fill_value")
    public Object fillValue;
    @JsonIgnore
    public final Object parsedFillValue;
    @Nullable
    public Codec[] filters;
    @Nullable
    public Codec compressor;
    @JsonIgnore
    public ArrayMetadata.CoreArrayMetadata coreArrayMetadata;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ArrayMetadata(@JsonProperty(value="zarr_format", required=true) int zarrFormat, @JsonProperty(value="shape", required=true) long[] shape, @JsonProperty(value="chunks", required=true) int[] chunks, @JsonProperty(value="dtype", required=true) DataType dataType, @Nullable @JsonProperty(value="fill_value", required=true) Object fillValue, @JsonProperty(value="order", required=true) Order order, @Nullable @JsonProperty(value="filters", required=true) Codec[] filters, @Nullable @JsonProperty(value="compressor", required=true) Codec compressor, @Nullable @JsonProperty(value="dimension_separator") Separator dimensionSeparator) throws ZarrException {
        if (zarrFormat != this.zarrFormat) {
            throw new ZarrException("Expected zarr format '" + this.zarrFormat + "', got '" + zarrFormat + "'.");
        }
        this.shape = shape;
        this.chunks = chunks;
        this.dataType = dataType;
        this.endianness = dataType.getEndianness();
        this.fillValue = fillValue;
        this.parsedFillValue = fillValue == null ? null : dev.zarr.zarrjava.core.ArrayMetadata.parseFillValue(fillValue, this.dataType);
        this.order = order;
        this.dimensionSeparator = dimensionSeparator;
        this.filters = filters;
        this.compressor = compressor;
        this.coreArrayMetadata = new ArrayMetadata.CoreArrayMetadata(shape, chunks, this.dataType, this.parsedFillValue);
    }

    @Override
    public int ndim() {
        return this.shape.length;
    }

    @Override
    public int[] chunkShape() {
        return this.chunks;
    }

    @Override
    public long[] shape() {
        return this.shape;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Array allocateFillValueChunk() {
        Array outputArray = Array.factory((ucar.ma2.DataType)this.dataType.getMA2DataType(), (int[])this.chunks);
        if (this.parsedFillValue != null) {
            MultiArrayUtils.fill(outputArray, this.parsedFillValue);
        }
        return outputArray;
    }

    @Override
    public ChunkKeyEncoding chunkKeyEncoding() {
        Separator separator = this.dimensionSeparator == null ? Separator.DOT : this.dimensionSeparator;
        return new V2ChunkKeyEncoding(separator);
    }

    @Override
    public Object parsedFillValue() {
        return this.parsedFillValue;
    }
}

