/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class ShortFieldSource
extends FieldCacheSource {
    FieldCache.ShortParser parser;

    public ShortFieldSource(String field) {
        this(field, null);
    }

    public ShortFieldSource(String field, FieldCache.ShortParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "short(" + this.field + ')';
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final short[] arr = this.parser == null ? this.cache.getShorts(reader, this.field) : this.cache.getShorts(reader, this.field, this.parser);
        return new DocValues(){

            public byte byteVal(int doc) {
                return (byte)arr[doc];
            }

            public short shortVal(int doc) {
                return arr[doc];
            }

            public float floatVal(int doc) {
                return arr[doc];
            }

            public int intVal(int doc) {
                return arr[doc];
            }

            public long longVal(int doc) {
                return arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Short.toString(arr[doc]);
            }

            public String toString(int doc) {
                return ShortFieldSource.this.description() + '=' + this.shortVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != ShortFieldSource.class) {
            return false;
        }
        ShortFieldSource other = (ShortFieldSource)o;
        return super.equals(other) && this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int hashCode() {
        int h = this.parser == null ? Short.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

