/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IObject;
import ome.model.core.Image;
import ome.services.search.AnnotationCriteria;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.services.search.TypeEqualityExpression;
import ome.system.ServiceFactory;
import ome.util.search.InvalidQueryException;
import ome.util.search.LuceneQueryBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class FullText
extends SearchAction {
    public static final String ALL_PROJECTIONS = "__ALL_PROJECTIONS";
    public static final String TOTAL_SIZE = "TOTAL_SIZE";
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final Logger log = LoggerFactory.getLogger(FullText.class);
    private static final long serialVersionUID = 1L;
    private final String queryStr;
    private final Query q;
    private final Class<? extends Analyzer> analyzer;

    public FullText(SearchValues values, String fields, String from, String to, String dateType, String query, Class<? extends Analyzer> analyzer) {
        super(values);
        ApiUsageException aue;
        Date dTo;
        Date dFrom;
        String[] tmp;
        Assert.notNull(analyzer, (String)"Analyzer required");
        this.analyzer = analyzer;
        if (values.onlyTypes == null || values.onlyTypes.size() != 1) {
            throw new ApiUsageException("Searches by full text are currently limited to a single type.\nPlese use Search.onlyType()");
        }
        if (!(query != null && query.length() >= 1 || from != null && from.length() >= 1 || to != null && to.length() >= 1)) {
            throw new IllegalArgumentException("Query string must be non-empty if no date range is provided");
        }
        if ((query.startsWith("*") || query.startsWith("?")) && !values.leadingWildcard) {
            throw new ApiUsageException("Searches starting with a leading wildcard (*,?) can be slow.\nPlease use setAllowLeadingWildcard() to permit this usage.");
        }
        if (query.equals("*")) {
            throw new ApiUsageException("Wildcard searches (*) must contain more than a single wildcard. ");
        }
        ArrayList<String> fieldsArray = new ArrayList<String>();
        for (String t : tmp = fields.split("\\,")) {
            if ((t = t.trim()).length() <= 0) continue;
            fieldsArray.add(t);
        }
        try {
            dFrom = from != null && from.trim().length() > 0 ? DATEFORMAT.parse(from) : null;
            dTo = to != null && to.trim().length() > 0 ? DATEFORMAT.parse(to) : null;
        }
        catch (java.text.ParseException e1) {
            throw new ApiUsageException("Invalid date format, dates must be in format YYYYMMDD.");
        }
        if ("acquisitionDate".equals(dateType) && !values.onlyTypes.contains(Image.class)) {
            dateType = "details.creationEvent.time";
        }
        try {
            this.queryStr = LuceneQueryBuilder.buildLuceneQuery(fieldsArray, (Date)dFrom, (Date)dTo, (String)dateType, (String)query);
            if (this.queryStr.isEmpty()) {
                this.q = null;
                log.info("Generated empty Lucene query");
                return;
            }
            log.info("Generated Lucene query: " + this.queryStr);
        }
        catch (InvalidQueryException e1) {
            throw new ApiUsageException("Invalid query: " + e1.getMessage());
        }
        try {
            Analyzer a = analyzer.newInstance();
            QueryParser parser = new QueryParser(Version.LUCENE_31, "combined_fields", a);
            parser.setAllowLeadingWildcard(values.leadingWildcard);
            this.q = parser.parse(this.queryStr);
        }
        catch (ParseException pe) {
            String msg = this.queryStr + " caused a parse exception: " + pe.getMessage();
            ApiUsageException aue2 = new ApiUsageException(msg);
            throw aue2;
        }
        catch (InstantiationException e) {
            aue = new ApiUsageException(analyzer.getName() + " cannot be instantiated.");
            throw aue;
        }
        catch (IllegalAccessException e) {
            aue = new ApiUsageException(analyzer.getName() + " cannot be instantiated.");
            throw aue;
        }
    }

    public FullText(SearchValues values, String query, Class<? extends Analyzer> analyzer) {
        super(values);
        Assert.notNull(analyzer, (String)"Analyzer required");
        this.analyzer = analyzer;
        if (values.onlyTypes == null || values.onlyTypes.size() != 1) {
            throw new ApiUsageException("Searches by full text are currently limited to a single type.\nPlese use Search.onlyType()");
        }
        if (query == null || query.length() < 1) {
            throw new IllegalArgumentException("Query string must be non-empty");
        }
        if ((query.startsWith("*") || query.startsWith("?")) && !values.leadingWildcard) {
            throw new ApiUsageException("Searches starting with a leading wildcard (*,?) can be slow.\nPlease use setAllowLeadingWildcard() to permit this usage.");
        }
        if (query.equals("*")) {
            throw new ApiUsageException("Wildcard searches (*) must contain more than a single wildcard. ");
        }
        this.queryStr = query;
        try {
            Analyzer a = analyzer.newInstance();
            QueryParser parser = new QueryParser(Version.LUCENE_31, "combined_fields", a);
            parser.setAllowLeadingWildcard(values.leadingWildcard);
            this.q = parser.parse(this.queryStr);
        }
        catch (ParseException pe) {
            String msg = this.queryStr + " caused a parse exception: " + pe.getMessage();
            ApiUsageException aue = new ApiUsageException(msg);
            throw aue;
        }
        catch (InstantiationException e) {
            ApiUsageException aue = new ApiUsageException(analyzer.getName() + " cannot be instantiated.");
            throw aue;
        }
        catch (IllegalAccessException e) {
            ApiUsageException aue = new ApiUsageException(analyzer.getName() + " cannot be instantiated.");
            throw aue;
        }
    }

    private Criteria criteria(FullTextSession session) {
        Class cls = this.values.onlyTypes.get(0);
        Criteria criteria = session.createCriteria(cls);
        if (this.timeout != null) {
            criteria.setTimeout(this.timeout.intValue());
        }
        AnnotationCriteria ann = new AnnotationCriteria(criteria, this.values.fetchAnnotations);
        this.ids(criteria);
        this.ownerOrGroup(cls, criteria);
        this.createdOrModified(cls, criteria);
        this.annotatedBy(ann);
        this.annotatedBetween(ann);
        if (this.values.onlyAnnotatedWith != null) {
            if (this.values.onlyAnnotatedWith.size() > 1) {
                throw new ApiUsageException("HHH-879: At the moment Hibernate cannot fulfill this request.\nPlease use only a single onlyAnnotatedWith parameter when performing full text searches.");
            }
            if (this.values.onlyAnnotatedWith.size() > 0) {
                if (!IAnnotated.class.isAssignableFrom(cls)) {
                    return null;
                }
                for (Class annCls : this.values.onlyAnnotatedWith) {
                    TypeEqualityExpression ofType = new TypeEqualityExpression("class", annCls);
                    ann.getChild().add((Criterion)ofType);
                }
            } else {
                criteria.add(Restrictions.isEmpty((String)"annotationLinks"));
            }
        }
        if (this.values.orderBy.size() > 0) {
            for (int i = 0; i < this.values.orderBy.size(); ++i) {
                String orderBy = this.values.orderBy.get(i);
                String orderWithoutMode = FullText.orderByPath(orderBy);
                boolean ascending = FullText.orderByAscending(orderBy);
                if (ascending) {
                    criteria.addOrder(Order.asc((String)orderWithoutMode));
                    continue;
                }
                criteria.addOrder(Order.desc((String)orderWithoutMode));
            }
        }
        return criteria;
    }

    protected void initializeQuery(FullTextQuery ftQuery) {
        ftQuery.setProjection(new String[]{"__HSearch_Score", "__HSearch_id"});
    }

    @Transactional(readOnly=true)
    public Object doWork(Session s, ServiceFactory sf) {
        if (this.q == null) {
            return null;
        }
        Class cls = this.values.onlyTypes.get(0);
        FullTextSession session = Search.createFullTextSession((Session)s);
        Criteria criteria = this.criteria(session);
        if (criteria == null) {
            return null;
        }
        String ticket975 = "ticket:975 - Wrong return type: %s instead of %s\nUnder some circumstances, byFullText and related methods \nlike bySomeMustNone can return instances of the wrong \ntypes. One known case is the use of onlyAnnotatedWith(). \nIf you are recieving this error, please try using the \nintersection/union methods to achieve the same results.";
        FullTextQuery ftQuery = session.createFullTextQuery(this.q, new Class[]{cls});
        if (this.timeout != null) {
            ftQuery.setTimeout(this.timeout.intValue());
        }
        this.initializeQuery(ftQuery);
        List result = ftQuery.list();
        int totalSize = ftQuery.getResultSize();
        if (result.size() == 0) {
            return result;
        }
        final HashMap<Long, Integer> order = new HashMap<Long, Integer>();
        HashMap<Long, Float> scores = new HashMap<Long, Float>();
        HashMap<Long, Object[]> projections = new HashMap<Long, Object[]>();
        for (int i = 0; i < result.size(); ++i) {
            Object[] parts = (Object[])result.get(i);
            scores.put((Long)parts[1], (Float)parts[0]);
            order.put((Long)parts[1], i);
            projections.put((Long)parts[1], parts);
        }
        LinkedList ids = new LinkedList(scores.keySet());
        ArrayList check975 = new ArrayList();
        while (ids.size() > 0) {
            ArrayList page = new ArrayList();
            for (int i = 0; i < 1000 && ids.size() > 0; ++i) {
                page.add((Long)ids.removeFirst());
            }
            if (criteria == null) {
                criteria = this.criteria(session);
            }
            criteria.add(Restrictions.in((String)"id", (Collection)page));
            check975.addAll(criteria.list());
            criteria = null;
        }
        for (IObject object : check975) {
            if (!cls.isAssignableFrom(object.getClass())) {
                throw new ApiUsageException(String.format("ticket:975 - Wrong return type: %s instead of %s\nUnder some circumstances, byFullText and related methods \nlike bySomeMustNone can return instances of the wrong \ntypes. One known case is the use of onlyAnnotatedWith(). \nIf you are recieving this error, please try using the \nintersection/union methods to achieve the same results.", object.getClass(), cls));
            }
            object.putAt(TOTAL_SIZE, (Object)totalSize);
            object.putAt("__HSearch_Score", scores.get(object.getId()));
            object.putAt(ALL_PROJECTIONS, projections.get(object.getId()));
        }
        Comparator cmp = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IObject o1 = (IObject)obj1;
                IObject o2 = (IObject)obj2;
                Long id1 = o1.getId();
                Long id2 = o2.getId();
                Integer idx1 = (Integer)order.get(id1);
                Integer idx2 = (Integer)order.get(id2);
                return idx1.compareTo(idx2);
            }
        };
        Collections.sort(check975, cmp);
        return check975;
    }

    public Float getScore(IObject object) {
        Object o = object.retrieve("__HSearch_Score");
        if (o instanceof Float) {
            return (Float)o;
        }
        return null;
    }

    public Integer getTotalSize(IObject object) {
        Object o = object.retrieve(TOTAL_SIZE);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    public Object[] getProjections(IObject object) {
        Object o = object.retrieve(ALL_PROJECTIONS);
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        return null;
    }
}

