/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import java.util.List;
import ome.model.meta.Session;
import ome.services.sessions.stats.SessionStats;
import ome.system.EventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SessionContext
extends EventContext {
    public Session getSession();

    public List<String> getUserRoles();

    public void setShareId(Long var1);

    public SessionStats stats();

    public Count count();

    public static class Count {
        private final Logger log = LoggerFactory.getLogger(Count.class);
        private final Object[] refLock = new Object[0];
        private int ref;
        private String uuid;

        public Count(String uuid) {
            this.uuid = uuid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get() {
            Object[] objectArray = this.refLock;
            synchronized (this.refLock) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.ref;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int increment() {
            Object[] objectArray = this.refLock;
            synchronized (this.refLock) {
                if (this.ref < 0) {
                    this.ref = 1;
                } else if (this.ref < Integer.MAX_VALUE) {
                    ++this.ref;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("+Reference count: " + this.uuid + "=" + this.ref);
                    }
                } else {
                    this.log.warn("Reference count == MAX_VALUE");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.ref;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int decrement() {
            Object[] objectArray = this.refLock;
            synchronized (this.refLock) {
                if (this.ref < 1) {
                    this.ref = 0;
                } else {
                    --this.ref;
                    this.log.info("-Reference count: " + this.uuid + "=" + this.ref);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.ref;
            }
        }
    }
}

