/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TextualAnnotationData;
import omero.model.Annotation;
import omero.model.CommentAnnotation;
import omero.model.DatasetAnnotationLink;
import omero.model.ImageAnnotationLink;
import omero.model.ProjectAnnotationLink;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.rtypes;

public class TagAnnotationData
extends AnnotationData {
    public static final String INSIGHT_TAGSET_NS = "openmicroscopy.org/omero/insight/tagset";
    private List<TextualAnnotationData> descriptions;
    private Set<DataObject> dataObjects;
    private Set<TagAnnotationData> tags;

    public TagAnnotationData(String tag, boolean asTagSet) {
        this(tag, null, asTagSet);
    }

    public TagAnnotationData(String tag) {
        this(tag, null, false);
    }

    public TagAnnotationData(String tag, String description) {
        this(tag, description, false);
    }

    public TagAnnotationData(String tag, String description, boolean asTagSet) {
        super(TagAnnotationI.class);
        this.setTagValue(tag);
        this.setTagDescription(description);
        if (asTagSet) {
            this.setNameSpace(INSIGHT_TAGSET_NS);
        }
    }

    public TagAnnotationData(TagAnnotation tag) {
        super(tag);
    }

    public TagAnnotationData(TagAnnotation tag, List<CommentAnnotation> value) {
        super(tag);
        if (value == null) {
            return;
        }
        this.descriptions = new ArrayList<TextualAnnotationData>();
        Iterator<CommentAnnotation> i = value.iterator();
        while (i.hasNext()) {
            this.descriptions.add(new TextualAnnotationData(i.next()));
        }
    }

    public void setDataObjects(Set<DataObject> dataObjects) {
        String ns = this.getNameSpace();
        if (INSIGHT_TAGSET_NS.equals(ns)) {
            throw new IllegalArgumentException("Cannot add dataObject to a Tag Set.");
        }
        this.dataObjects = dataObjects;
    }

    public Set<TagAnnotationData> getTags() {
        String ns = this.getNameSpace();
        if (!INSIGHT_TAGSET_NS.equals(ns)) {
            return null;
        }
        TagAnnotation tagSet = (TagAnnotation)this.asIObject();
        if (this.tags == null && tagSet.sizeOfAnnotationLinks() >= 0) {
            this.tags = new HashSet<TagAnnotationData>();
            List l = tagSet.linkedAnnotationList();
            for (Annotation data : l) {
                if (!(data instanceof TagAnnotation)) continue;
                this.tags.add(new TagAnnotationData((TagAnnotation)data));
            }
        }
        return this.tags;
    }

    public Set<DataObject> getDataObjects() {
        if (this.dataObjects == null && this.asAnnotation().sizeOfAnnotationLinks() >= 0) {
            List l = this.asAnnotation().copyAnnotationLinks();
            this.dataObjects = new HashSet<DataObject>();
            for (Object object : l) {
                if (object instanceof ImageAnnotationLink) {
                    ImageAnnotationLink iaLink = (ImageAnnotationLink)object;
                    this.dataObjects.add(new ImageData(iaLink.getParent()));
                    continue;
                }
                if (object instanceof DatasetAnnotationLink) {
                    DatasetAnnotationLink daLink = (DatasetAnnotationLink)object;
                    this.dataObjects.add(new DatasetData(daLink.getParent()));
                    continue;
                }
                if (!(object instanceof ProjectAnnotationLink)) continue;
                ProjectAnnotationLink paLink = (ProjectAnnotationLink)object;
                this.dataObjects.add(new ProjectData(paLink.getParent()));
            }
        }
        return this.dataObjects == null ? null : new HashSet<DataObject>(this.dataObjects);
    }

    public void setTagDescriptions(List<TextualAnnotationData> value) {
        this.descriptions = value;
    }

    public List getTagDescriptions() {
        return this.descriptions;
    }

    public void setTagDescription(String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        this.setDirty(true);
        this.asAnnotation().setDescription(rtypes.rstring((String)value));
    }

    public String getTagDescription() {
        RString value = this.asAnnotation().getDescription();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setTagValue(String tag) {
        this.setContent(tag);
    }

    public String getTagValue() {
        return this.getContentAsString();
    }

    @Override
    public Object getContent() {
        RString s = ((TagAnnotation)this.asAnnotation()).getTextValue();
        return s == null ? null : s.getValue();
    }

    @Override
    public String getContentAsString() {
        Object o = this.getContent();
        if (o == null) {
            return "";
        }
        return (String)o;
    }

    @Override
    public void setContent(Object content) {
        if (content == null) {
            throw new IllegalArgumentException("Tag value cannot be null.");
        }
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("Object must be of type String");
        }
        String tag = (String)content;
        if (tag.trim().length() == 0) {
            throw new IllegalArgumentException("Tag value cannot be null.");
        }
        this.setDirty(true);
        ((TagAnnotation)this.asAnnotation()).setTextValue(rtypes.rstring((String)tag));
    }
}

