/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ome.annotations.RolesAllowed;
import ome.api.IRenderingSettings;
import ome.api.IUpdate;
import ome.api.ServiceInterface;
import ome.api.ThumbnailStore;
import ome.api.local.LocalCompress;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.InMemoryPlanarPixelBuffer;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.model.IObject;
import ome.model.core.Channel;
import ome.model.core.LogicalChannel;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.QuantumDef;
import ome.model.display.RenderingDef;
import ome.model.display.ReverseIntensityContext;
import ome.model.enums.Family;
import ome.model.enums.PixelsType;
import ome.model.enums.RenderingModel;
import ome.model.roi.Mask;
import ome.model.stats.StatsInfo;
import ome.parameters.Parameters;
import ome.security.SecuritySystem;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.ServiceFactory;
import ome.system.SimpleEventContext;
import ome.util.ImageUtil;
import ome.util.ShallowCopy;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.Renderer;
import omeis.providers.re.RenderingEngine;
import omeis.providers.re.codomain.CodomainChain;
import omeis.providers.re.codomain.CodomainMapContext;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.data.RegionDef;
import omeis.providers.re.lut.LutProvider;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumFactory;
import org.hibernate.Session;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class RenderingBean
implements RenderingEngine,
Serializable {
    private static final long serialVersionUID = -4383698215540637039L;
    private static final Logger log = LoggerFactory.getLogger(RenderingBean.class);
    private transient Renderer renderer;
    private Pixels pixelsObj;
    private RenderingDef rendDefObj;
    private transient PixelsService pixDataSrv;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Executor ex;
    private final SecuritySystem secSys;
    private final LocalCompress compressionSrv;
    private final LutProvider lutProvider;
    private transient boolean wasPassivated = false;
    private Integer resolutionLevel;
    private boolean requestedRenderingDef = false;
    protected static final String NULL_RENDERER = "RenderingEngine not ready: renderer is null.\nThis method can only be called after the renderer is properly initialized (not-null).\nTry lookup and/or use methods.";

    public Class<? extends ServiceInterface> getServiceInterface() {
        return RenderingEngine.class;
    }

    public RenderingBean(PixelsService dataService, LocalCompress compress, Executor ex, SecuritySystem secSys, LutProvider lutProvider) {
        this.ex = ex;
        this.secSys = secSys;
        this.pixDataSrv = dataService;
        this.compressionSrv = compress;
        this.lutProvider = lutProvider;
    }

    @RolesAllowed(value={"user"})
    public long getRenderingDefId() {
        if (this.rendDefObj == null || this.rendDefObj.getId() == null) {
            throw new ApiUsageException("No rendering def");
        }
        return this.rendDefObj.getId();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void passivate() {
        log.debug("***** Passivating... ******");
        this.rwl.writeLock().lock();
        try {
            this.closeRenderer();
            this.renderer = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void activate() {
        log.debug("***** Returning from passivation... ******");
        this.rwl.writeLock().lock();
        try {
            this.wasPassivated = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void close() {
        this.rwl.writeLock().lock();
        try {
            this.closeRenderer();
            this.renderer = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void lookupPixels(long pixelsId) {
        this.rwl.writeLock().lock();
        try {
            this.pixelsObj = this.retrievePixels(pixelsId);
            this.closeRenderer();
            this.renderer = null;
            this.resolutionLevel = null;
            if (this.pixelsObj == null) {
                throw new ValidationException("Pixels object with id " + pixelsId + " not found.");
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("lookupPixels for id " + pixelsId + " succeeded: " + this.pixelsObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public boolean lookupRenderingDef(long pixelsId) {
        this.rwl.writeLock().lock();
        try {
            this.rendDefObj = this.retrieveRndSettings(pixelsId);
            this.requestedRenderingDef = false;
            this.closeRenderer();
            this.renderer = null;
            if (this.rendDefObj == null) {
                boolean bl = false;
                return bl;
            }
            Pixels unloadedPixels = new Pixels(Long.valueOf(pixelsId), false);
            this.rendDefObj.setPixels(unloadedPixels);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("lookupRenderingDef for Pixels=" + pixelsId + " succeeded: " + this.rendDefObj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void loadRenderingDef(long renderingDefId) {
        this.rwl.writeLock().lock();
        try {
            this.rendDefObj = this.loadRndSettings(renderingDefId);
            this.requestedRenderingDef = true;
            if (this.rendDefObj == null) {
                throw new ValidationException("No rendering definition exists with ID: " + renderingDefId);
            }
            if (this.rendDefObj.getPixels() == null) {
                this.rendDefObj = null;
                throw new ValidationException("The rendering definition " + renderingDefId + " is not linked to a pixels set.");
            }
            Pixels pixels = this.retrievePixels(this.rendDefObj.getPixels().getId());
            if (!this.sanityCheckPixels(this.pixelsObj, pixels)) {
                this.rendDefObj = null;
                throw new ValidationException("The rendering definition " + renderingDefId + " is incompatible with pixels set " + this.pixelsObj.getId());
            }
            this.closeRenderer();
            this.renderer = null;
            Pixels unloadedPixels = new Pixels(this.rendDefObj.getPixels().getId(), false);
            this.rendDefObj.setPixels(unloadedPixels);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("loadRenderingDef for RenderingDef=" + renderingDefId + " succeeded: " + this.rendDefObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void load() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfNullPixels();
            this.errorIfNullRenderingDef();
            this.closeRenderer();
            List families = this.getAllEnumerations(Family.class);
            List renderingModels = this.getAllEnumerations(RenderingModel.class);
            QuantumFactory quantumFactory = new QuantumFactory(families);
            PixelBuffer buffer = this.getPixelBuffer();
            this.renderer = new Renderer(quantumFactory, renderingModels, this.pixelsObj, this.rendDefObj, buffer, this.lutProvider);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void setOverlays(Map<byte[], Integer> overlays) {
        this.renderer.setOverlays(overlays);
    }

    @RolesAllowed(value={"user"})
    public EventContext getCurrentEventContext() {
        return new SimpleEventContext(this.secSys.getEventContext());
    }

    @RolesAllowed(value={"user"})
    public RGBBuffer render(PlaneDef pd) {
        this.rwl.readLock().lock();
        try {
            Map<byte[], Integer> overlays = this.getMasks(pd);
            if (overlays.size() > 0) {
                this.renderer.setOverlays(overlays);
            }
            this.errorIfInvalidState();
            RGBBuffer rGBBuffer = this.renderer.render(pd);
            return rGBBuffer;
        }
        catch (IOException e) {
            log.error("IO error while rendering.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        catch (QuantizationException e) {
            log.error("Quantization exception while rendering.", (Throwable)e);
            throw new InternalException(e.getMessage());
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public int[] renderAsPackedInt(PlaneDef pd) {
        this.rwl.writeLock().lock();
        try {
            Map<byte[], Integer> overlays = this.getMasks(pd);
            if (overlays.size() > 0) {
                this.renderer.setOverlays(overlays);
            }
            this.errorIfInvalidState();
            this.checkPlaneDef(pd);
            if (this.resolutionLevel != null) {
                this.renderer.setResolutionLevel(this.resolutionLevel.intValue());
            }
            int[] nArray = this.renderer.renderAsPackedInt(pd, null);
            return nArray;
        }
        catch (IOException e) {
            log.error("IO error while rendering.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        catch (QuantizationException e) {
            log.error("Quantization exception while rendering.", (Throwable)e);
            throw new InternalException(e.getMessage());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public byte[] renderCompressed(PlaneDef pd) {
        this.rwl.writeLock().lock();
        ByteArrayOutputStream byteStream = null;
        try {
            int stride;
            Map<byte[], Integer> overlays = this.getMasks(pd);
            if (overlays.size() > 0) {
                this.renderer.setOverlays(overlays);
            }
            if ((stride = pd.getStride()) < 0) {
                stride = 0;
            }
            ++stride;
            int[] buf = this.renderAsPackedInt(pd);
            int sizeX = this.pixelsObj.getSizeX();
            int sizeY = this.pixelsObj.getSizeY();
            RegionDef region = pd.getRegion();
            if (region != null) {
                sizeX = region.getWidth();
                sizeY = region.getHeight();
            }
            BufferedImage image = ImageUtil.createBufferedImage((int[])buf, (int)(sizeX /= stride), (int)(sizeY /= stride));
            byteStream = new ByteArrayOutputStream();
            this.compressionSrv.compressToStream(image, byteStream);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("Could not compress rendered image.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        finally {
            this.rwl.writeLock().unlock();
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                log.error("Could not close byte stream.", (Throwable)e);
                throw new ResourceError(e.getMessage());
            }
        }
    }

    @RolesAllowed(value={"user"})
    public int[] renderProjectedAsPackedInt(int algorithm, int timepoint, int stepping, int start, int end) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            if (this.resolutionLevel != null) {
                this.renderer.setResolutionLevel(this.resolutionLevel.intValue());
            }
            ChannelBinding[] channelBindings = this.renderer.getChannelBindings();
            byte[][][][] planes = new byte[1][this.pixelsObj.getSizeC().intValue()][1][];
            long pixelsId = this.pixelsObj.getId();
            int projectedSizeC = 0;
            for (int i = 0; i < channelBindings.length; ++i) {
                if (!channelBindings[i].getActive().booleanValue()) continue;
                planes[0][i][0] = this.projectStack(algorithm, timepoint, stepping, start, end, pixelsId, i);
                ++projectedSizeC;
            }
            if (projectedSizeC == 0) {
                projectedSizeC = 1;
            }
            Pixels projectedPixels = new Pixels();
            projectedPixels.setSizeX(this.pixelsObj.getSizeX());
            projectedPixels.setSizeY(this.pixelsObj.getSizeY());
            projectedPixels.setSizeZ(Integer.valueOf(1));
            projectedPixels.setSizeT(Integer.valueOf(1));
            projectedPixels.setSizeC(Integer.valueOf(projectedSizeC));
            projectedPixels.setPixelsType(this.pixelsObj.getPixelsType());
            InMemoryPlanarPixelBuffer projectedPlanes = new InMemoryPlanarPixelBuffer(projectedPixels, planes);
            PlaneDef pd = new PlaneDef(0, 0);
            pd.setZ(0);
            int[] nArray = this.renderer.renderAsPackedInt(pd, (PixelBuffer)projectedPlanes);
            return nArray;
        }
        catch (IOException e) {
            log.error("IO error while rendering.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        catch (QuantizationException e) {
            log.error("Quantization exception while rendering.", (Throwable)e);
            throw new InternalException(e.getMessage());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public byte[] renderProjectedCompressed(int algorithm, int timepoint, int stepping, int start, int end) {
        this.rwl.writeLock().lock();
        ByteArrayOutputStream byteStream = null;
        try {
            if (this.resolutionLevel != null) {
                this.renderer.setResolutionLevel(this.resolutionLevel.intValue());
            }
            int[] buf = this.renderProjectedAsPackedInt(algorithm, timepoint, stepping, start, end);
            int sizeX = this.pixelsObj.getSizeX();
            int sizeY = this.pixelsObj.getSizeY();
            BufferedImage image = ImageUtil.createBufferedImage((int[])buf, (int)sizeX, (int)sizeY);
            byteStream = new ByteArrayOutputStream();
            this.compressionSrv.compressToStream(image, byteStream);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error("Could not compress rendered image.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        finally {
            this.rwl.writeLock().unlock();
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                log.error("Could not close byte stream.", (Throwable)e);
                throw new ResourceError(e.getMessage());
            }
        }
    }

    @RolesAllowed(value={"user"})
    public long resetDefaultSettings(boolean save) {
        return this.internalReset(save);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalReset(boolean save) {
        if (save) {
            save = !this.requestedRenderingDef;
        }
        this.rwl.writeLock().lock();
        try {
            if (!save) {
                this.errorIfInvalidState();
                this.ex.execute(null, new Executor.SimpleWork(this, "resetDefaultsNoSave", new Object[0]){

                    @Override
                    @Transactional(readOnly=true)
                    public Object doWork(Session session, ServiceFactory sf) {
                        IRenderingSettings settingsSrv = sf.getRenderingSettingsService();
                        settingsSrv.resetDefaultsNoSave(RenderingBean.this.rendDefObj, RenderingBean.this.pixelsObj);
                        return null;
                    }
                });
                this.load();
            } else {
                this.errorIfNullPixels();
                long pixelsId = this.pixelsObj.getId();
                if (this.rendDefObj == null) {
                    this.rendDefObj = this.retrieveRndSettings(pixelsId);
                    this.requestedRenderingDef = false;
                    if (this.rendDefObj != null) {
                        this.errorIfInvalidState();
                    }
                    this.rendDefObj = this.createNewRenderingDef(this.pixelsObj);
                    this._resetDefaults(this.rendDefObj, this.pixelsObj);
                } else {
                    this.errorIfInvalidState();
                    if (!this.settingsBelongToCurrentUser()) {
                        this.rendDefObj = this.createNewRenderingDef(this.pixelsObj);
                    }
                    this._resetDefaults(this.rendDefObj, this.pixelsObj);
                    this.rendDefObj = this.retrieveRndSettings(this.pixelsObj.getId());
                    this.load();
                }
            }
            long l = this.rendDefObj.getId();
            return l;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void setCompressionLevel(float percentage) {
        this.compressionSrv.setCompressionLevel(percentage);
    }

    @RolesAllowed(value={"user"})
    public float getCompressionLevel() {
        return this.compressionSrv.getCompressionLevel();
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long saveAsNewSettings() {
        return this.internalSave(true);
    }

    @RolesAllowed(value={"user"})
    public void updateSettings(RenderingDef settings) {
        QuantumDef quantumDef;
        Integer defaultT;
        Integer defaultZ;
        if (settings == null) {
            return;
        }
        RenderingModel model = settings.getModel();
        if (model != null) {
            this.setModel(model);
        }
        if ((defaultZ = settings.getDefaultZ()) != null) {
            this.setDefaultZ(settings.getDefaultZ());
        }
        if ((defaultT = settings.getDefaultT()) != null) {
            this.setDefaultT(settings.getDefaultT());
        }
        if ((quantumDef = settings.getQuantization()) != null) {
            Integer bitResolution = quantumDef.getBitResolution();
            if (bitResolution != null) {
                this.setQuantumStrategy(bitResolution);
            }
            Integer start = quantumDef.getCdStart();
            Integer end = quantumDef.getCdEnd();
            if (start != null && end != null) {
                this.setCodomainInterval(start, end);
            }
        }
        for (int w = 0; w < settings.sizeOfWaveRendering() && w < this.pixelsObj.getSizeC(); ++w) {
            String lookupTable;
            ChannelBinding cb = settings.getChannelBinding(w);
            if (cb == null) continue;
            Boolean active = cb.getActive();
            if (active != null) {
                this.setActive(w, active);
            }
            Double start = cb.getInputStart();
            Double end = cb.getInputEnd();
            if (start != null && end != null) {
                this.setChannelWindow(w, start, end);
            }
            Family family = cb.getFamily();
            Double coefficient = cb.getCoefficient();
            Boolean noiseReduction = cb.getNoiseReduction();
            if (family != null && coefficient != null && noiseReduction != null) {
                this.setQuantizationMap(w, family, coefficient, noiseReduction);
            }
            Integer red = cb.getRed();
            Integer green = cb.getGreen();
            Integer blue = cb.getBlue();
            Integer alpha = cb.getAlpha();
            if (red != null && green != null && blue != null && alpha != null) {
                this.setRGBA(w, red, green, blue, alpha);
            }
            if ((lookupTable = cb.getLookupTable()) != null) {
                this.setChannelLookupTable(w, lookupTable);
            }
            for (int i = 0; i < cb.sizeOfSpatialDomainEnhancement(); ++i) {
                ome.model.display.CodomainMapContext ctx = cb.getCodomainMapContext(i);
                if (ctx == null) continue;
                this.addCodomainMapToChannel(this.reverse(ctx), w);
            }
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void saveCurrentSettings() {
        this.internalSave(!this.requestedRenderingDef && !this.settingsBelongToCurrentUser());
    }

    private ome.model.display.CodomainMapContext copyContext(ome.model.display.CodomainMapContext ctx, Collection<ome.model.display.CodomainMapContext> saved, boolean saveAs) {
        if (ctx == null) {
            return null;
        }
        if (!saveAs && ctx.getId() != null && ctx.getId() >= 0L) {
            return ctx;
        }
        if (saved != null) {
            for (ome.model.display.CodomainMapContext cmc : saved) {
                if (!cmc.getClass().equals(ctx.getClass())) continue;
                return cmc;
            }
        }
        if (ctx instanceof ReverseIntensityContext) {
            ReverseIntensityContext nc = new ReverseIntensityContext();
            nc.setReverse(((ReverseIntensityContext)ctx).getReverse());
            return nc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long internalSave(boolean saveAs) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfNullRenderingDef();
            RenderingDef saved = null;
            if (!saveAs) {
                saved = this.retrieveRndSettings(this.pixelsObj.getId());
            }
            RenderingDef old = this.rendDefObj;
            this.rendDefObj = this.createNewRenderingDef(this.pixelsObj);
            if (!saveAs) {
                this.rendDefObj.setId(old.getId());
                this.rendDefObj.setVersion(Integer.valueOf(old.getVersion() + 1));
            }
            this.rendDefObj.setDefaultZ(old.getDefaultZ());
            this.rendDefObj.setDefaultT(old.getDefaultT());
            this.rendDefObj.setCompression(old.getCompression());
            this.rendDefObj.setName(old.getName());
            QuantumDef qDefNew = this.rendDefObj.getQuantization();
            QuantumDef qDefOld = old.getQuantization();
            if (!saveAs) {
                qDefNew.setId(qDefOld.getId());
            }
            qDefNew.setBitResolution(qDefOld.getBitResolution());
            qDefNew.setCdStart(qDefOld.getCdStart());
            qDefNew.setCdEnd(qDefOld.getCdEnd());
            RenderingModel unloadedModel = new RenderingModel(old.getModel().getId(), false);
            this.rendDefObj.setModel(unloadedModel);
            int index = 0;
            Collection bindings = old.unmodifiableWaveRendering();
            ChannelBinding[] savedBindings = new ChannelBinding[bindings.size()];
            if (saved != null) {
                savedBindings = saved.unmodifiableWaveRendering().toArray(new ChannelBinding[bindings.size()]);
            }
            for (ChannelBinding binding : bindings) {
                ChannelBinding scb = savedBindings[index];
                Family family = new Family(binding.getFamily().getId(), false);
                ChannelBinding cb = this.rendDefObj.getChannelBinding(index);
                cb.setFamily(family);
                cb.setActive(binding.getActive());
                cb.setAlpha(binding.getAlpha());
                cb.setBlue(binding.getBlue());
                cb.setRed(binding.getRed());
                cb.setGreen(binding.getGreen());
                if (!saveAs) {
                    cb.setId(binding.getId());
                }
                cb.setInputStart(binding.getInputStart());
                cb.setInputEnd(binding.getInputEnd());
                cb.setCoefficient(binding.getCoefficient());
                cb.setNoiseReduction(binding.getNoiseReduction());
                cb.setLookupTable(binding.getLookupTable());
                cb.clearSpatialDomainEnhancement();
                Collection ctx = binding.unmodifiableSpatialDomainEnhancement();
                Collection octx = null;
                if (!saveAs) {
                    octx = scb.unmodifiableSpatialDomainEnhancement();
                }
                Iterator i = ctx.iterator();
                cb.clearSpatialDomainEnhancement();
                ArrayList types = new ArrayList();
                while (i.hasNext()) {
                    ome.model.display.CodomainMapContext nc = this.copyContext((ome.model.display.CodomainMapContext)i.next(), octx, saveAs);
                    if (nc == null || types.contains(nc.getClass())) continue;
                    types.add(nc.getClass());
                    cb.addCodomainMapContext(nc);
                }
                ++index;
            }
            Long id = (Long)this.ex.execute(null, new Executor.SimpleWork(this, "saveCurrentSettings", new Object[0]){

                @Override
                @Transactional(readOnly=false)
                public Object doWork(Session session, ServiceFactory sf) {
                    IUpdate update = sf.getUpdateService();
                    return ((RenderingDef)update.saveAndReturnObject((IObject)RenderingBean.this.rendDefObj)).getId();
                }
            });
            if (saveAs) {
                this.loadRenderingDef(id);
            } else {
                this.rendDefObj = this.retrieveRndSettings(this.pixelsObj.getId());
                Pixels unloadedPixels = new Pixels(this.pixelsObj.getId(), false);
                this.rendDefObj.setPixels(unloadedPixels);
            }
            this.load();
            long l = id;
            return l;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public double getChannelCurveCoefficient(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            double d = cb[w].getCoefficient();
            return d;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public Family getChannelFamily(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            Family family = cb[w].getFamily();
            Family family2 = this.copyFamily(family);
            return family2;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public boolean getChannelNoiseReduction(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            boolean bl = cb[w].getNoiseReduction();
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public double[] getChannelStats(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            double[] dArray = null;
            return dArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public double getChannelWindowEnd(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            double d = cb[w].getInputEnd();
            return d;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public double getChannelWindowStart(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            double d = cb[w].getInputStart();
            return d;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public int[] getRGBA(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            int[] rgba = new int[4];
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            rgba[0] = cb[w].getRed();
            rgba[1] = cb[w].getGreen();
            rgba[2] = cb[w].getBlue();
            rgba[3] = cb[w].getAlpha();
            int[] nArray = rgba;
            return nArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public boolean isActive(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            boolean bl = cb[w].getActive();
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public String getChannelLookupTable(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            String string = cb[w].getLookupTable();
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setChannelLookupTable(int w, String lookup) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setChannelLookupTable");
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            this.renderer.setChannelLookupTable(w, lookup);
        }
        finally {
            this.rwl.readLock().unlock();
            t0.stop();
        }
    }

    @RolesAllowed(value={"user"})
    public int getDefaultT() {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            int n = this.rendDefObj.getDefaultT();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public int getDefaultZ() {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            int n = this.rendDefObj.getDefaultZ();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public RenderingModel getModel() {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            RenderingModel renderingModel = this.copyRenderingModel(this.rendDefObj.getModel());
            return renderingModel;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public QuantumDef getQuantumDef() {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullRenderingDef();
            QuantumDef quantumDef = (QuantumDef)new ShallowCopy().copy((IObject)this.rendDefObj.getQuantization());
            return quantumDef;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public Pixels getPixels() {
        this.rwl.readLock().lock();
        try {
            this.errorIfNullPixels();
            Pixels pixels = this.copyPixels(this.pixelsObj);
            return pixels;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public List getAvailableModels() {
        this.rwl.readLock().lock();
        try {
            List models = this.getAllEnumerations(RenderingModel.class);
            ArrayList<RenderingModel> result = new ArrayList<RenderingModel>();
            for (RenderingModel model : models) {
                result.add(this.copyRenderingModel(model));
            }
            ArrayList<RenderingModel> arrayList = result;
            return arrayList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public List getAvailableFamilies() {
        this.rwl.readLock().lock();
        try {
            List families = this.getAllEnumerations(Family.class);
            ArrayList<Family> result = new ArrayList<Family>();
            for (Family family : families) {
                result.add(this.copyFamily(family));
            }
            ArrayList<Family> arrayList = result;
            return arrayList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Deprecated
    public void addCodomainMap(CodomainMapContext mapCtx) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            for (int i = 0; i < this.pixelsObj.getSizeC(); ++i) {
                boolean b = this.renderer.getCodomainChain(i).add(mapCtx);
                if (!b) continue;
                cb[i].addCodomainMapContext(this.convert(mapCtx));
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void addCodomainMapToChannel(CodomainMapContext mapCtx, int w) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            boolean b = this.renderer.getCodomainChain(w).add(mapCtx);
            if (b) {
                ChannelBinding[] cb = this.renderer.getChannelBindings();
                cb[w].addCodomainMapContext(this.convert(mapCtx));
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private ome.model.display.CodomainMapContext convert(CodomainMapContext mapCtx) {
        if (mapCtx instanceof omeis.providers.re.codomain.ReverseIntensityContext) {
            ReverseIntensityContext c = new ReverseIntensityContext();
            c.setReverse(Boolean.valueOf(true));
            return c;
        }
        return null;
    }

    private CodomainMapContext reverse(ome.model.display.CodomainMapContext ctx) {
        if (ctx instanceof ReverseIntensityContext) {
            return new omeis.providers.re.codomain.ReverseIntensityContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Deprecated
    public void removeCodomainMap(CodomainMapContext mapCtx) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            for (int i = 0; i < this.pixelsObj.getSizeC(); ++i) {
                boolean b = this.renderer.getCodomainChain(i).remove(mapCtx.copy());
                if (!b) continue;
                cb[i].clearSpatialDomainEnhancement();
                CodomainChain chain = this.renderer.getCodomainChain(i);
                List l = chain.getContexts();
                Iterator j = l.iterator();
                while (j.hasNext()) {
                    cb[i].addCodomainMapContext(this.convert((CodomainMapContext)j.next()));
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void removeCodomainMapFromChannel(CodomainMapContext mapCtx, int w) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            boolean b = this.renderer.getCodomainChain(w).remove(mapCtx.copy());
            if (b) {
                ChannelBinding[] cb = this.renderer.getChannelBindings();
                cb[w].clearSpatialDomainEnhancement();
                CodomainChain chain = this.renderer.getCodomainChain(w);
                List l = chain.getContexts();
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    cb[w].addCodomainMapContext(this.convert((CodomainMapContext)i.next()));
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    @Deprecated
    public void updateCodomainMap(CodomainMapContext mapCtx) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            for (int i = 0; i < this.pixelsObj.getSizeC(); ++i) {
                this.renderer.getCodomainChain(i).update(mapCtx.copy());
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setActive(int w, boolean active) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setActive");
        try {
            this.rwl.writeLock().lock();
            this.errorIfInvalidState();
            this.renderer.setActive(w, active);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setChannelWindow(int w, double start, double end) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setChannelWindow");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setChannelWindow(w, start, end);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setCodomainInterval(int start, int end) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setCodomainInterval");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setCodomainInterval(start, end);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    @RolesAllowed(value={"user"})
    public void setDefaultT(int t) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setDefaultT");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setDefaultT(t);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    @RolesAllowed(value={"user"})
    public void setDefaultZ(int z) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setDefaultZ");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setDefaultZ(z);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setModel(RenderingModel model) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setModel");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            RenderingModel m = this.lookup(model);
            this.renderer.setModel(m);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setQuantizationMap(int w, Family family, double coefficient, boolean noiseReduction) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setQuantizationMap");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            Family f = this.lookup(family);
            this.renderer.setQuantizationMap(w, f, coefficient, noiseReduction);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    @RolesAllowed(value={"user"})
    public void setQuantumStrategy(int bitResolution) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setQuantumStrategy");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setQuantumStrategy(bitResolution);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public void setRGBA(int w, int red, int green, int blue, int alpha) {
        Slf4JStopWatch t0 = new Slf4JStopWatch("omero.rendering_bean.setRGBA");
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.renderer.setRGBA(w, red, green, blue, alpha);
        }
        finally {
            this.rwl.writeLock().unlock();
            t0.stop();
        }
    }

    @RolesAllowed(value={"user"})
    public boolean isPixelsTypeSigned() {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            boolean bl = this.renderer.isPixelsTypeSigned();
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public double getPixelsTypeLowerBound(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            double d = this.renderer.getPixelsTypeLowerBound(w);
            return d;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public int getResolutionLevel() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            int n = this.renderer.getResolutionLevel();
            return n;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public int getResolutionLevels() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            int n = this.renderer.getResolutionLevels();
            return n;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public List<List<Integer>> getResolutionDescriptions() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            List list = this.renderer.getResolutionDescriptions();
            return list;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public int[] getTileSize() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            Dimension tileSize = this.renderer.getTileSize();
            int[] nArray = new int[]{(int)tileSize.getWidth(), (int)tileSize.getHeight()};
            return nArray;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public boolean requiresPixelsPyramid() {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            boolean bl = this.pixDataSrv.requiresPixelsPyramid(this.pixelsObj);
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void setResolutionLevel(int resolutionLevel) {
        this.rwl.writeLock().lock();
        try {
            this.errorIfInvalidState();
            this.resolutionLevel = resolutionLevel;
            this.renderer.setResolutionLevel(resolutionLevel);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public double getPixelsTypeUpperBound(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            double d = this.renderer.getPixelsTypeUpperBound(w);
            return d;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    public List<CodomainMapContext> getCodomainMapContext(int w) {
        this.rwl.readLock().lock();
        try {
            this.errorIfInvalidState();
            ChannelBinding[] cb = this.renderer.getChannelBindings();
            List list = cb[w].collectSpatialDomainEnhancement(null);
            return list;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private void checkPlaneDef(PlaneDef pd) {
        RegionDef rd = pd.getRegion();
        if (rd == null) {
            return;
        }
        PixelBuffer pixelBuffer = this.renderer.getPixels();
        int sizeX = pixelBuffer.getSizeX();
        int sizeY = pixelBuffer.getSizeY();
        if (rd.getWidth() + rd.getX() > sizeX) {
            int newWidth = sizeX - rd.getX();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Resetting out of bounds region XOffset %d width %d vs. sizeX %d to %d", rd.getX(), rd.getWidth(), sizeX, newWidth));
            }
            rd.setWidth(newWidth);
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("Leaving region xOffset %d width %d alone vs. sizeX %d", rd.getX(), rd.getWidth(), sizeX));
        }
        if (rd.getHeight() + rd.getY() > sizeY) {
            int newHeight = sizeY - rd.getY();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Resetting out of bounds region yOffset %d height %d vs. sizeY %d to %d", rd.getY(), rd.getHeight(), sizeY, newHeight));
            }
            rd.setHeight(newHeight);
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("Leaving region yOffset %d height %d alone vs. sizeY %d", rd.getY(), rd.getHeight(), sizeY));
        }
    }

    private void closeRenderer() {
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    protected void errorIfInvalidState() {
        this.errorIfNullPixels();
        this.errorIfNullRenderingDef();
        this.errorIfNullRenderer();
    }

    protected void errorIfNullPixels() {
        if (this.pixelsObj == null) {
            throw new ApiUsageException("RenderingEngine not ready: Pixels object not set.");
        }
    }

    protected void errorIfNullRenderingDef() {
        if (this.rendDefObj == null) {
            throw new ApiUsageException("RenderingEngine not ready: RenderingDef object not set.");
        }
    }

    protected void errorIfNullRenderer() {
        if (this.renderer == null && this.wasPassivated) {
            this.load();
        } else if (this.renderer == null) {
            throw new ApiUsageException(NULL_RENDERER);
        }
    }

    private Pixels copyPixels(Pixels pixels) {
        if (pixels == null) {
            return null;
        }
        Pixels newPixels = (Pixels)new ShallowCopy().copy((IObject)pixels);
        newPixels.putAt("ome.model.core.Pixels_channels", new ArrayList());
        this.copyChannels(pixels, newPixels);
        newPixels.setPixelsType((PixelsType)new ShallowCopy().copy((IObject)pixels.getPixelsType()));
        return newPixels;
    }

    private void copyChannels(Pixels from, Pixels to) {
        Iterator it = from.iterateChannels();
        while (it.hasNext()) {
            to.addChannel(this.copyChannel((Channel)it.next()));
        }
    }

    private Channel copyChannel(Channel channel) {
        if (channel == null) {
            return null;
        }
        Channel newChannel = (Channel)new ShallowCopy().copy((IObject)channel);
        newChannel.setLogicalChannel((LogicalChannel)new ShallowCopy().copy((IObject)channel.getLogicalChannel()));
        if (channel.getStatsInfo() != null) {
            newChannel.setStatsInfo((StatsInfo)new ShallowCopy().copy((IObject)channel.getStatsInfo()));
        }
        return newChannel;
    }

    private RenderingModel copyRenderingModel(RenderingModel model) {
        if (model == null) {
            return null;
        }
        RenderingModel newModel = new RenderingModel();
        newModel.setId(model.getId());
        newModel.setValue(model.getValue());
        newModel.getDetails().copy(model.getDetails() == null ? null : model.getDetails().shallowCopy());
        return newModel;
    }

    private Family copyFamily(Family family) {
        if (family == null) {
            return null;
        }
        Family newFamily = new Family();
        newFamily.setId(family.getId());
        newFamily.setValue(family.getValue());
        newFamily.getDetails().copy(family.getDetails() == null ? null : family.getDetails().shallowCopy());
        return newFamily;
    }

    private <T extends IObject> T lookup(final T argument) {
        if (argument == null) {
            return null;
        }
        if (argument.getId() == null) {
            return argument;
        }
        return (T)((IObject)this.ex.execute(null, new Executor.SimpleWork(this, "lookup", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().get(argument.getClass(), argument.getId().longValue());
            }
        }));
    }

    private Pixels retrievePixels(final long pixelsId) {
        return (Pixels)this.ex.execute(null, new Executor.SimpleWork(this, "retrievePixels", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getPixelsService().retrievePixDescription(pixelsId);
            }
        });
    }

    private RenderingDef retrieveRndSettings(final long pixelsId) {
        return (RenderingDef)this.ex.execute(null, new Executor.SimpleWork(this, "retrieveRndDef", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getPixelsService().retrieveRndSettings(pixelsId);
            }
        });
    }

    private RenderingDef loadRndSettings(final long rdefId) {
        return (RenderingDef)this.ex.execute(null, new Executor.SimpleWork(this, "loadRndDef", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getPixelsService().loadRndSettings(rdefId);
            }
        });
    }

    private List getAllEnumerations(final Class k) {
        return (List)this.ex.execute(null, new Executor.SimpleWork(this, "getAllEnumerations", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getPixelsService().getAllEnumerations(k);
            }
        });
    }

    private boolean sanityCheckPixels(final Pixels pix1, final Pixels pix2) {
        return (Boolean)this.ex.execute(null, new Executor.SimpleWork(this, "sanityCheck", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getRenderingSettingsService().sanityCheckPixels(pix1, pix2);
            }
        });
    }

    private byte[] projectStack(final int algorithm, final int timepoint, final int stepping, final int start, final int end, final long pixelsId, final int i) {
        return (byte[])this.ex.execute(null, new Executor.SimpleWork(this, "projectStack", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getProjectionService().projectStack(pixelsId, null, algorithm, timepoint, i, stepping, start, end);
            }
        });
    }

    private RenderingDef createNewRenderingDef(final Pixels pixels) {
        return (RenderingDef)this.ex.execute(null, new Executor.SimpleWork(this, "createNewRenderingDef", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getRenderingSettingsService().createNewRenderingDef(pixels);
            }
        });
    }

    private void _resetDefaults(final RenderingDef def, final Pixels pixels) {
        this.ex.execute(null, new Executor.SimpleWork(this, "_resetDefaults", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                sf.getRenderingSettingsService().resetDefaults(def, pixels);
                return null;
            }
        });
    }

    private PixelBuffer getPixelBuffer() {
        return (PixelBuffer)this.ex.execute(null, new Executor.SimpleWork(this, "getPixelBuffer", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                return RenderingBean.this.pixDataSrv.getPixelBuffer(RenderingBean.this.pixelsObj, false);
            }
        });
    }

    private boolean settingsBelongToCurrentUser() {
        return (Boolean)this.ex.execute(null, new Executor.SimpleWork(this, "checkSettingsOwner", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List rv = sf.getQueryService().projection("select o.id from RenderingDef r join r.details.owner o where r.id = :id", new Parameters().addId(RenderingBean.this.rendDefObj.getId()));
                Long currentUser = RenderingBean.this.getCurrentEventContext().getCurrentUserId();
                Long ownerId = (Long)((Object[])rv.get(0))[0];
                return ownerId.equals(currentUser);
            }
        });
    }

    private void getThumbnail(final long rid) {
        final long pid = this.pixelsObj.getId();
        this.ex.execute(null, new Executor.SimpleWork(this, "generateThumbnail", new Object[0]){

            @Override
            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                ThumbnailStore tb = sf.createThumbnailService();
                tb.setPixelsId(pid);
                tb.setRenderingDefId(rid);
                tb.getThumbnailByLongestSide(Integer.valueOf(96));
                return null;
            }
        });
    }

    private List<IObject> getMasksById(PlaneDef pd) {
        long pid = this.pixelsObj.getId();
        long width = this.pixelsObj.getSizeX().intValue();
        long height = this.pixelsObj.getSizeY().intValue();
        long z = pd.getZ();
        long t = pd.getT();
        ArrayList<Long> channelIds = new ArrayList<Long>();
        for (int c = 0; c < this.pixelsObj.getSizeC(); ++c) {
            if (!this.rendDefObj.getChannelBinding(c).getActive().booleanValue()) continue;
            channelIds.add(Long.valueOf(c));
        }
        final Parameters params = new Parameters();
        params.addLong("pid", Long.valueOf(pid));
        params.addLong("width", Long.valueOf(width));
        params.addLong("height", Long.valueOf(height));
        params.addLong("theZ", Long.valueOf(z));
        params.addLong("theT", Long.valueOf(t));
        params.addList("channelIds", channelIds);
        params.addList("shapeIds", pd.getShapeIds());
        String query = "select m from Mask as m join m.roi as r join r.image as i where i.pixels.id = :pixelsId  and m.width = :width  and m.height = :height  and m.x = 0  and m.y = 0  and m.theZ = :theZ  and m.theT = :theT and m.theC in (:channelIds) and m.id in (:shapeIds)";
        return (List)this.ex.execute(null, new Executor.SimpleWork(this, "getMaskList", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public List<IObject> doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery("select m from Mask as m join m.roi as r join r.image as i where i.pixels.id = :pixelsId  and m.width = :width  and m.height = :height  and m.x = 0  and m.y = 0  and m.theZ = :theZ  and m.theT = :theT and m.theC in (:channelIds) and m.id in (:shapeIds)", params);
            }
        });
    }

    private List<IObject> getAllMasks(PlaneDef pd) {
        long pid = this.pixelsObj.getId();
        long width = this.pixelsObj.getSizeX().intValue();
        long height = this.pixelsObj.getSizeY().intValue();
        long z = pd.getZ();
        long t = pd.getT();
        ArrayList<Long> channelIds = new ArrayList<Long>();
        for (int c = 0; c < this.pixelsObj.getSizeC(); ++c) {
            if (!this.rendDefObj.getChannelBinding(c).getActive().booleanValue()) continue;
            channelIds.add(Long.valueOf(c));
        }
        final Parameters params = new Parameters();
        params.addLong("pid", Long.valueOf(pid));
        params.addLong("width", Long.valueOf(width));
        params.addLong("height", Long.valueOf(height));
        params.addLong("theZ", Long.valueOf(z));
        params.addLong("theT", Long.valueOf(t));
        params.addList("channelIds", channelIds);
        String query = "select m from Mask as m join m.roi as r join r.image as i where i.pixels.id = :pixelsId  and m.width = :width  and m.height = :height  and m.x = 0  and m.y = 0  and m.theZ = :theZ  and m.theT = :theT and m.theC in (:channelIds)";
        return (List)this.ex.execute(null, new Executor.SimpleWork(this, "getMaskList", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public List<IObject> doWork(Session session, ServiceFactory sf) {
                return sf.getQueryService().findAllByQuery("select m from Mask as m join m.roi as r join r.image as i where i.pixels.id = :pixelsId  and m.width = :width  and m.height = :height  and m.x = 0  and m.y = 0  and m.theZ = :theZ  and m.theT = :theT and m.theC in (:channelIds)", params);
            }
        });
    }

    private Map<byte[], Integer> getMasks(PlaneDef pd) {
        List<Object> masks = new ArrayList();
        LinkedHashMap<byte[], Integer> maskMap = new LinkedHashMap<byte[], Integer>();
        if (!pd.getRenderShapes()) {
            return maskMap;
        }
        masks = pd.getShapeIds().isEmpty() ? this.getAllMasks(pd) : this.getMasksById(pd);
        for (int i = 0; i < masks.size(); ++i) {
            maskMap.put(((Mask)masks.get(i)).getBytes(), ((Mask)masks.get(i)).getFillColor());
        }
        return maskMap;
    }
}

