/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.bc.zarr.ZarrUtils;
import com.bc.zarr.storage.Store;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemStore
implements Store {
    private Path root;
    AmazonS3 client;
    public static final String ENDPOINT_PROTOCOL = "https://";
    protected static final Logger LOGGER = LoggerFactory.getLogger(S3FileSystemStore.class);

    public S3FileSystemStore(String path, FileSystem fileSystem) {
        this.root = fileSystem == null ? Paths.get(path, new String[0]) : fileSystem.getPath(path, new String[0]);
        this.setupClient();
    }

    public void updateRoot(String path) {
        this.root = Paths.get(path, new String[0]);
    }

    public String getRoot() {
        return this.root.toString();
    }

    private void setupClient() {
        String[] pathSplit = this.root.toString().split("/");
        String endpoint = ENDPOINT_PROTOCOL + pathSplit[1] + "/";
        try {
            this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, "auto"))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).build();
        }
        catch (Exception e) {
            LOGGER.info("Exception caught while constructing S3 client", (Throwable)e);
        }
    }

    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    public S3FileSystemStore(Path rootPath) {
        this.root = rootPath;
        this.setupClient();
    }

    public InputStream getInputStream(String key) throws IOException {
        String[] pathSplit = this.root.toString().split("/");
        String bucketName = pathSplit[2];
        String key2 = this.root.toString().substring(this.root.toString().indexOf(pathSplit[3]), this.root.toString().length()) + "/" + key;
        try {
            S3Object o = this.client.getObject(bucketName, key2);
            S3ObjectInputStream responseStream = o.getObjectContent();
            return responseStream;
        }
        catch (Exception e) {
            LOGGER.info("Unable to locate or access key: " + key2, (Throwable)e);
            return null;
        }
    }

    public OutputStream getOutputStream(String key) throws IOException {
        Path filePath = this.root.resolve(key);
        Path dir = filePath.getParent();
        Files.createDirectories(dir, new FileAttribute[0]);
        return Files.newOutputStream(filePath, new OpenOption[0]);
    }

    public void delete(String key) throws IOException {
        Path toBeDeleted = this.root.resolve(key);
        if (Files.isDirectory(toBeDeleted, new LinkOption[0])) {
            ZarrUtils.deleteDirectoryTreeRecursively((Path)toBeDeleted);
        }
        if (Files.exists(toBeDeleted, new LinkOption[0])) {
            Files.delete(toBeDeleted);
        }
        if (Files.exists(toBeDeleted, new LinkOption[0]) || Files.isDirectory(toBeDeleted, new LinkOption[0])) {
            throw new IOException("Unable to initialize " + toBeDeleted.toAbsolutePath().toString());
        }
    }

    public TreeSet<String> getArrayKeys() throws IOException {
        return this.getKeysFor(".zarray");
    }

    public TreeSet<String> getGroupKeys() throws IOException {
        return this.getKeysFor(".zgroup");
    }

    public TreeSet<String> getKeysEndingWith(String suffix) throws IOException {
        return Files.walk(this.root, new FileVisitOption[0]).filter(path -> path.toString().endsWith(suffix)).map(path -> this.root.relativize((Path)path).toString()).collect(Collectors.toCollection(TreeSet::new));
    }

    public Stream<String> getRelativeLeafKeys(String key) throws IOException {
        Path walkingRoot = this.root.resolve(key);
        return Files.walk(walkingRoot, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> walkingRoot.relativize((Path)path).toString()).map(ZarrUtils::normalizeStoragePath).filter(s -> s.trim().length() > 0);
    }

    private TreeSet<String> getKeysFor(String suffix) throws IOException {
        TreeSet<String> keys = new TreeSet<String>();
        String[] pathSplit = this.root.toString().split("/");
        String bucketName = pathSplit[2];
        String key2 = this.root.toString().substring(this.root.toString().indexOf(pathSplit[3]), this.root.toString().length());
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(key2);
        ObjectListing listObjectsResponse = null;
        String lastKey = null;
        do {
            if (listObjectsResponse != null) {
                listObjectsRequest = listObjectsRequest.withMarker(lastKey);
            }
            listObjectsResponse = this.client.listObjects(listObjectsRequest);
            List objects = listObjectsResponse.getObjectSummaries();
            ListIterator iterVals = objects.listIterator();
            while (iterVals.hasNext()) {
                String key;
                S3ObjectSummary object = (S3ObjectSummary)iterVals.next();
                String k = object.getKey();
                if (k.contains(suffix) && !(key = k.substring(k.indexOf(key2) + key2.length() + 1, k.indexOf(suffix))).isEmpty()) {
                    keys.add(key.substring(0, key.length() - 1));
                }
                lastKey = k;
            }
        } while (listObjectsResponse.isTruncated());
        return keys;
    }
}

