/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.plan.ByInterfaceDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.ReportingDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.SingleDetectorFactorySelector;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader
extends URLClassLoader {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.debug.PluginLoader");
    private static int nextUnknownId;
    private Plugin plugin;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$PluginLoader;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$Detector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$Detector2;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$TrainingDetector;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector;

    public PluginLoader(URL url) throws PluginException {
        super(new URL[]{url});
        this.init();
    }

    public PluginLoader(URL url, ClassLoader parent) throws PluginException {
        super(new URL[]{url}, parent);
        this.init();
    }

    public Plugin getPlugin() throws PluginException {
        if (this.plugin == null) {
            this.init();
        }
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws PluginException {
        String website;
        String defaultEnabled;
        Document pluginDescriptor;
        ArrayList<Document> messageCollectionList = new ArrayList<Document>();
        try {
            URL descriptorURL = this.findResource("findbugs.xml");
            if (descriptorURL == null) {
                throw new PluginException("Couldn't find \"findbugs.xml\" in plugin");
            }
            SAXReader reader = new SAXReader();
            pluginDescriptor = reader.read(descriptorURL);
        }
        catch (DocumentException e) {
            throw new PluginException("Couldn't parse \"findbugs.xml\"", e);
        }
        String pluginId = pluginDescriptor.valueOf("/FindbugsPlugin/@pluginid");
        if (pluginId.equals("")) {
            Class e = class$edu$umd$cs$findbugs$PluginLoader == null ? (class$edu$umd$cs$findbugs$PluginLoader = PluginLoader.class$("edu.umd.cs.findbugs.PluginLoader")) : class$edu$umd$cs$findbugs$PluginLoader;
            synchronized (e) {
                pluginId = new StringBuffer().append("plugin").append(nextUnknownId++).toString();
            }
        }
        boolean pluginEnabled = (defaultEnabled = pluginDescriptor.valueOf("/FindbugsPlugin/@defaultenabled")).equals("") || Boolean.valueOf(defaultEnabled) != false;
        try {
            Locale locale = I18N.defaultLocale;
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (country != null) {
                this.addCollection(messageCollectionList, new StringBuffer().append("messages_").append(language).append("_").append(country).append(".xml").toString());
            }
            this.addCollection(messageCollectionList, new StringBuffer().append("messages_").append(language).append(".xml").toString());
            this.addCollection(messageCollectionList, "messages.xml");
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new PluginException("Couldn't parse \"messages.xml\"", e);
        }
        Plugin plugin = new Plugin(pluginId);
        plugin.setEnabled(pluginEnabled);
        String provider = pluginDescriptor.valueOf("/FindbugsPlugin/@provider");
        if (!provider.equals("")) {
            plugin.setProvider(provider);
        }
        if (!(website = pluginDescriptor.valueOf("/FindbugsPlugin/@website")).equals("")) {
            plugin.setWebsite(website);
        }
        Node pluginShortDesc = null;
        try {
            pluginShortDesc = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Plugin/ShortDescription", "no plugin description");
        }
        catch (PluginException e) {
            // empty catch block
        }
        if (pluginShortDesc != null) {
            plugin.setShortDescription(pluginShortDesc.getText());
        }
        try {
            List detectorNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/Detector");
            int detectorCount = 0;
            for (Node detectorNode : detectorNodeList) {
                Class<?> detectorClass;
                String className = detectorNode.valueOf("@class");
                String speed = detectorNode.valueOf("@speed");
                String disabled = detectorNode.valueOf("@disabled");
                String reports = detectorNode.valueOf("@reports");
                String requireJRE = detectorNode.valueOf("@requirejre");
                String hidden = detectorNode.valueOf("@hidden");
                if (!(class$edu$umd$cs$findbugs$Detector == null ? PluginLoader.class$("edu.umd.cs.findbugs.Detector") : class$edu$umd$cs$findbugs$Detector).isAssignableFrom(detectorClass = this.loadClass(className)) && !(class$edu$umd$cs$findbugs$Detector2 == null ? PluginLoader.class$("edu.umd.cs.findbugs.Detector2") : class$edu$umd$cs$findbugs$Detector2).isAssignableFrom(detectorClass)) {
                    throw new PluginException(new StringBuffer().append("Class ").append(className).append(" does not implement Detector or Detector2").toString());
                }
                DetectorFactory factory = new DetectorFactory(plugin, detectorClass, !disabled.equals("true"), speed, reports, requireJRE);
                if (Boolean.valueOf(hidden).booleanValue()) {
                    factory.setHidden(true);
                }
                factory.setPositionSpecifiedInPluginDescriptor(detectorCount++);
                plugin.addDetectorFactory(factory);
                Node node = PluginLoader.findMessageNode(messageCollectionList, new StringBuffer().append("/MessageCollection/Detector[@class='").append(className).append("']/Details").toString(), new StringBuffer().append("Missing Detector description for detector ").append(className).toString());
                Element details = (Element)node;
                String detailHTML = details.getText();
                StringBuffer buf = new StringBuffer();
                buf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                buf.append("<HTML><HEAD><TITLE>Detector Description</TITLE></HEAD><BODY>\n");
                buf.append(detailHTML);
                buf.append("</BODY></HTML>\n");
                factory.setDetailHTML(buf.toString());
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(new StringBuffer().append("Could not instantiate detector class: ").append(e).toString(), e);
        }
        Node orderingConstraintsNode = pluginDescriptor.selectSingleNode("/FindbugsPlugin/OrderingConstraints");
        if (orderingConstraintsNode != null) {
            for (Element constraintElement : orderingConstraintsNode.selectNodes("./SplitPass|./WithinPass")) {
                DetectorFactorySelector earlierSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Earlier", "EarlierCategory");
                DetectorFactorySelector laterSelector = PluginLoader.getConstraintSelector(constraintElement, plugin, "Later", "LaterCategory");
                DetectorOrderingConstraint constraint = new DetectorOrderingConstraint(earlierSelector, laterSelector);
                if (constraintElement.getName().equals("SplitPass")) {
                    plugin.addInterPassOrderingConstraint(constraint);
                    continue;
                }
                plugin.addIntraPassOrderingConstraint(constraint);
            }
        }
        I18N i18n = I18N.instance();
        for (Document messageCollection : messageCollectionList) {
            List categoryNodeList = messageCollection.selectNodes("/MessageCollection/BugCategory");
            if (DEBUG) {
                System.out.println(new StringBuffer().append("found ").append(categoryNodeList.size()).append(" categories in ").append(messageCollection.getName()).toString());
            }
            for (Node categoryNode : categoryNodeList) {
                BugCategory bc;
                String key;
                block42: {
                    key = categoryNode.valueOf("@category");
                    if (key.equals("")) {
                        throw new PluginException("BugCategory element with missing category attribute");
                    }
                    String shortDesc = PluginLoader.getChildText(categoryNode, "Description");
                    bc = new BugCategory(key, shortDesc);
                    boolean b = i18n.registerBugCategory(key, bc);
                    if (DEBUG) {
                        System.out.println(b ? new StringBuffer().append("category ").append(key).append(" -> ").append(shortDesc).toString() : new StringBuffer().append("rejected \"").append(shortDesc).append("\" for category ").append(key).append(": ").append(i18n.getBugCategoryDescription(key)).toString());
                    }
                    if (!b) {
                        bc = i18n.getBugCategory(key);
                    }
                    try {
                        String abbrev = PluginLoader.getChildText(categoryNode, "Abbreviation");
                        if (bc.getAbbrev() == null) {
                            bc.setAbbrev(abbrev);
                            if (DEBUG) {
                                System.out.println(new StringBuffer().append("category ").append(key).append(" abbrev -> ").append(abbrev).toString());
                            }
                        } else if (DEBUG) {
                            System.out.println(new StringBuffer().append("rejected abbrev '").append(abbrev).append("' for category ").append(key).append(": ").append(bc.getAbbrev()).toString());
                        }
                    }
                    catch (PluginException pe) {
                        if (!DEBUG) break block42;
                        System.out.println(new StringBuffer().append("missing Abbreviation for category ").append(key).append("/").append(shortDesc).toString());
                    }
                }
                try {
                    String details = PluginLoader.getChildText(categoryNode, "Details");
                    if (bc.getDetailText() == null) {
                        bc.setDetailText(details);
                        if (!DEBUG) continue;
                        System.out.println(new StringBuffer().append("category ").append(key).append(" details -> ").append(details).toString());
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println(new StringBuffer().append("rejected details [").append(details).append("] for category ").append(key).append(": [").append(bc.getDetailText()).append(']').toString());
                }
                catch (PluginException pe) {}
            }
        }
        List bugPatternNodeList = pluginDescriptor.selectNodes("/FindbugsPlugin/BugPattern");
        for (Node bugPatternNode : bugPatternNodeList) {
            String type = bugPatternNode.valueOf("@type");
            String abbrev = bugPatternNode.valueOf("@abbrev");
            String category = bugPatternNode.valueOf("@category");
            String experimental = bugPatternNode.valueOf("@experimental");
            String query = new StringBuffer().append("/MessageCollection/BugPattern[@type='").append(type).append("']").toString();
            Node messageNode = PluginLoader.findMessageNode(messageCollectionList, query, new StringBuffer().append("messages.xml missing BugPattern element for type ").append(type).toString());
            String shortDesc = PluginLoader.getChildText(messageNode, "ShortDescription");
            String longDesc = PluginLoader.getChildText(messageNode, "LongDescription");
            String detailText = PluginLoader.getChildText(messageNode, "Details");
            BugPattern bugPattern = new BugPattern(type, abbrev, category, Boolean.valueOf(experimental), shortDesc, longDesc, detailText);
            plugin.addBugPattern(bugPattern);
            boolean unknownCategory = null == i18n.getBugCategory(category);
            if (!unknownCategory) continue;
            i18n.registerBugCategory(category, new BugCategory(category, category));
            if (!DEBUG) continue;
            System.out.println(new StringBuffer().append("Category ").append(category).append(" (of BugPattern ").append(type).append(") has no description in messages*.xml").toString());
        }
        HashSet<String> definedBugCodes = new HashSet<String>();
        for (Document messageCollection : messageCollectionList) {
            List bugCodeNodeList = messageCollection.selectNodes("/MessageCollection/BugCode");
            for (Node bugCodeNode : bugCodeNodeList) {
                String abbrev = bugCodeNode.valueOf("@abbrev");
                if (abbrev.equals("")) {
                    throw new PluginException("BugCode element with missing abbrev attribute");
                }
                if (definedBugCodes.contains(abbrev)) continue;
                String description = bugCodeNode.getText();
                BugCode bugCode = new BugCode(abbrev, description);
                plugin.addBugCode(bugCode);
                definedBugCodes.add(abbrev);
            }
        }
        this.plugin = plugin;
    }

    private static DetectorFactorySelector getConstraintSelector(Element constraintElement, Plugin plugin, String singleDetectorElementName, String detectorCategoryElementName) throws PluginException {
        Node node = constraintElement.selectSingleNode(new StringBuffer().append("./").append(singleDetectorElementName).toString());
        if (node != null) {
            String detectorClass = node.valueOf("@class");
            return new SingleDetectorFactorySelector(plugin, detectorClass);
        }
        node = constraintElement.selectSingleNode(new StringBuffer().append("./").append(detectorCategoryElementName).toString());
        if (node != null) {
            String categoryName = node.valueOf("@name");
            boolean spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            if (categoryName.equals("reporting")) {
                return new ReportingDetectorFactorySelector(spanPlugins ? null : plugin);
            }
            if (categoryName.equals("training")) {
                return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, class$edu$umd$cs$findbugs$TrainingDetector == null ? (class$edu$umd$cs$findbugs$TrainingDetector = PluginLoader.class$("edu.umd.cs.findbugs.TrainingDetector")) : class$edu$umd$cs$findbugs$TrainingDetector);
            }
            if (categoryName.equals("interprocedural")) {
                return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector == null ? (class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector = PluginLoader.class$("edu.umd.cs.findbugs.InterproceduralFirstPassDetector")) : class$edu$umd$cs$findbugs$InterproceduralFirstPassDetector);
            }
            throw new PluginException("Invalid constraint selector node");
        }
        throw new PluginException("Invalid constraint selector node");
    }

    private String lookupDetectorClass(Plugin plugin, String name) throws PluginException {
        if (name.indexOf(46) < 0) {
            DetectorFactory factory = plugin.getFactoryByShortName(name);
            if (factory == null) {
                throw new PluginException(new StringBuffer().append("No detector found for short name '").append(name).append("'").toString());
            }
            name = factory.getFullName();
        }
        return name;
    }

    private void addCollection(List<Document> messageCollectionList, String filename) throws DocumentException {
        URL messageURL = this.findResource(filename);
        if (messageURL != null) {
            SAXReader reader = new SAXReader();
            Document messageCollection = reader.read(messageURL);
            messageCollectionList.add(messageCollection);
        }
    }

    private static Node findMessageNode(List<Document> messageCollectionList, String xpath, String missingMsg) throws PluginException {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node;
        }
        throw new PluginException(missingMsg);
    }

    private static String getChildText(Node node, String childName) throws PluginException {
        Node child = node.selectSingleNode(childName);
        if (child == null) {
            throw new PluginException(new StringBuffer().append("Could not find child \"").append(childName).append("\" for node").toString());
        }
        return child.getText();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

